/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.authentication.PlcUsernamePasswordAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.CallContext;
import org.apache.plc4x.java.opcua.context.CertificateKeyPair;
import org.apache.plc4x.java.opcua.context.Conversation;
import org.apache.plc4x.java.opcua.context.OpcuaDriverContext;
import org.apache.plc4x.java.opcua.readwrite.ActivateSessionRequest;
import org.apache.plc4x.java.opcua.readwrite.ActivateSessionResponse;
import org.apache.plc4x.java.opcua.readwrite.AnonymousIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.ApplicationDescription;
import org.apache.plc4x.java.opcua.readwrite.ApplicationType;
import org.apache.plc4x.java.opcua.readwrite.BinaryPayload;
import org.apache.plc4x.java.opcua.readwrite.ChannelSecurityToken;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.CloseSecureChannelRequest;
import org.apache.plc4x.java.opcua.readwrite.CloseSessionRequest;
import org.apache.plc4x.java.opcua.readwrite.CloseSessionResponse;
import org.apache.plc4x.java.opcua.readwrite.CreateSessionRequest;
import org.apache.plc4x.java.opcua.readwrite.CreateSessionResponse;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensiblePayload;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.opcua.readwrite.GetEndpointsRequest;
import org.apache.plc4x.java.opcua.readwrite.GetEndpointsResponse;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.NodeIdFourByte;
import org.apache.plc4x.java.opcua.readwrite.OpcuaCloseRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaConstants;
import org.apache.plc4x.java.opcua.readwrite.OpcuaNodeIdServicesObject;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenResponse;
import org.apache.plc4x.java.opcua.readwrite.OpenChannelMessageRequest;
import org.apache.plc4x.java.opcua.readwrite.OpenSecureChannelRequest;
import org.apache.plc4x.java.opcua.readwrite.OpenSecureChannelResponse;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.SecurityHeader;
import org.apache.plc4x.java.opcua.readwrite.SecurityTokenRequestType;
import org.apache.plc4x.java.opcua.readwrite.SequenceHeader;
import org.apache.plc4x.java.opcua.readwrite.ServiceFault;
import org.apache.plc4x.java.opcua.readwrite.SignatureData;
import org.apache.plc4x.java.opcua.readwrite.UserIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.UserNameIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.UserTokenPolicy;
import org.apache.plc4x.java.opcua.readwrite.UserTokenType;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureChannel.class);
    private static final String PASSWORD_ENCRYPTION_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#rsa-oaep";
    public static final PascalString NULL_STRING = new PascalString("");
    public static final PascalByteString NULL_BYTE_STRING = new PascalByteString(-1, null);
    public static final Pattern INET_ADDRESS_PATTERN = Pattern.compile("(.(?<transportCode>tcp|https?))?://(?<transportHost>[\\w.-]+)(:(?<transportPort>\\d*))?");
    public static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>opc)" + INET_ADDRESS_PATTERN + "(?<transportEndpoint>[\\w/=]*)[?]?");
    private static final PascalString APPLICATION_URI = new PascalString("urn:apache:plc4x:client");
    private static final PascalString PRODUCT_URI = new PascalString("urn:apache:plc4x:client");
    private static final PascalString APPLICATION_TEXT = new PascalString("OPCUA client for the Apache PLC4X:PLC4J project");
    public static final ScheduledExecutorService KEEP_ALIVE_EXECUTOR = Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, "plc4x-opcua-keep-alive"));
    private final String sessionName = "UaSession:" + APPLICATION_TEXT.getStringValue() + ":" + RandomStringUtils.random((int)20, (boolean)true, (boolean)true);
    private final PascalByteString localCertificateString;
    private final PascalByteString remoteCertificateThumbprint;
    private PascalString policyId;
    private UserTokenType tokenType;
    private final PascalString endpoint;
    private final String username;
    private final String password;
    private final RequestTransactionManager tm;
    private final OpcuaConfiguration configuration;
    private final OpcuaDriverContext driverContext;
    private final Conversation conversation;
    private ScheduledFuture<?> keepAlive;
    private final List<String> endpoints = new ArrayList<String>();
    private double sessionTimeout;
    private long revisedLifetime;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecureChannel(Conversation conversation, RequestTransactionManager tm, OpcuaDriverContext driverContext, OpcuaConfiguration configuration, PlcAuthentication authentication) {
        this.conversation = conversation;
        this.tm = tm;
        this.configuration = configuration;
        this.driverContext = driverContext;
        this.endpoint = new PascalString(driverContext.getEndpoint());
        this.sessionTimeout = configuration.getSessionTimeout();
        if (authentication != null) {
            if (!(authentication instanceof PlcUsernamePasswordAuthentication)) throw new PlcRuntimeException("This type of connection only supports username-password authentication");
            this.username = ((PlcUsernamePasswordAuthentication)authentication).getUsername();
            this.password = ((PlcUsernamePasswordAuthentication)authentication).getPassword();
        } else {
            this.username = configuration.getUsername();
            this.password = configuration.getPassword();
        }
        try {
            InetAddress address = InetAddress.getByName(driverContext.getHost());
            this.endpoints.add(address.getHostAddress());
            this.endpoints.add(address.getHostName());
            this.endpoints.add(address.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to resolve host name. Using original host from connection string which may cause issues connecting to server");
            this.endpoints.add(driverContext.getHost());
        }
        if (conversation.getSecurityPolicy() == SecurityPolicy.NONE) {
            this.localCertificateString = NULL_BYTE_STRING;
            this.remoteCertificateThumbprint = NULL_BYTE_STRING;
            return;
        }
        CertificateKeyPair keyPair = driverContext.getCertificateKeyPair();
        this.remoteCertificateThumbprint = driverContext.getThumbprint();
        try {
            byte[] encoded = keyPair.getCertificate().getEncoded();
            this.localCertificateString = new PascalByteString(encoded.length, encoded);
            return;
        }
        catch (CertificateEncodingException e) {
            throw new PlcRuntimeException("Could not decode certificate", (Throwable)e);
        }
    }

    public CompletableFuture<ActivateSessionResponse> onConnect() {
        LOGGER.debug("Opcua Driver running in ACTIVE mode.");
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.conversation.requestHello().thenCompose(r -> this.onConnectOpenSecureChannel(SecurityTokenRequestType.securityTokenRequestTypeIssue))).thenCompose(r -> this.onConnectCreateSessionRequest((OpenSecureChannelResponse)r))).thenCompose(r -> this.onConnectActivateSessionRequest((CreateSessionResponse)r))).thenApply(response -> {
            this.keepAlive();
            return response;
        });
    }

    public CompletableFuture<OpenSecureChannelResponse> onConnectOpenSecureChannel(SecurityTokenRequestType securityTokenRequestType) {
        OpenSecureChannelRequest openSecureChannelRequest;
        LOGGER.debug("Sending open secure channel message to {}", (Object)this.driverContext.getEndpoint());
        RequestHeader requestHeader = this.conversation.createRequestHeader(this.configuration.getNegotiationTimeout(), 0);
        if (this.conversation.getSecurityPolicy() != SecurityPolicy.NONE) {
            byte[] localNonce = this.conversation.getLocalNonce();
            openSecureChannelRequest = new OpenSecureChannelRequest(requestHeader, OpcuaConstants.PROTOCOLVERSION.shortValue(), securityTokenRequestType, this.configuration.getMessageSecurity().getMode(), new PascalByteString(localNonce.length, localNonce), this.configuration.getChannelLifetime());
        } else {
            openSecureChannelRequest = new OpenSecureChannelRequest(requestHeader, OpcuaConstants.PROTOCOLVERSION.shortValue(), securityTokenRequestType, MessageSecurityMode.messageSecurityModeNone, NULL_BYTE_STRING, this.configuration.getChannelLifetime());
        }
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(openSecureChannelRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, openSecureChannelRequest);
        Function<CallContext, OpcuaOpenRequest> openRequest = context -> {
            LOGGER.debug("Submitting OpenSecureChannel with id of {}", (Object)context.getRequestId());
            return new OpcuaOpenRequest(ChunkType.FINAL, new OpenChannelMessageRequest(0, new PascalString(this.conversation.getSecurityPolicy().getSecurityPolicyUri()), this.localCertificateString, this.remoteCertificateThumbprint), new ExtensiblePayload(new SequenceHeader(context.getNextSequenceNumber(), context.getRequestId()), extObject));
        };
        return ((CompletableFuture)((CompletableFuture)this.conversation.requestChannelOpen(openRequest).thenApply(response -> {
            LOGGER.info("Received open channel response {}, parsing it", (Object)response.getMessage().getSequenceHeader().getRequestId());
            return response;
        })).thenApply(this::onOpenResponse)).thenApply(openSecureChannelResponse -> {
            ChannelSecurityToken securityToken = (ChannelSecurityToken)openSecureChannelResponse.getSecurityToken();
            LOGGER.debug("Opened secure response id: {}, channel id:{}, token:{} lifetime:{}", new Object[]{openSecureChannelResponse.getIdentifier(), securityToken.getChannelId(), securityToken.getTokenId(), securityToken.getRevisedLifetime()});
            this.conversation.setSecurityHeader(new SecurityHeader(securityToken.getChannelId(), securityToken.getTokenId()));
            this.revisedLifetime = securityToken.getRevisedLifetime();
            return openSecureChannelResponse;
        });
    }

    public CompletableFuture<CreateSessionResponse> onConnectCreateSessionRequest(OpenSecureChannelResponse response) {
        LOGGER.debug("Sending create session request to {}", (Object)this.driverContext.getEndpoint());
        RequestHeader requestHeader = this.conversation.createRequestHeader();
        LocalizedText applicationName = new LocalizedText(true, true, new PascalString("en"), APPLICATION_TEXT);
        int noOfDiscoveryUrls = -1;
        ArrayList<PascalString> discoveryUrls = new ArrayList<PascalString>(0);
        ApplicationDescription clientDescription = new ApplicationDescription(this.driverContext.getApplicationUri().map(PascalString::new).orElse(APPLICATION_URI), PRODUCT_URI, applicationName, ApplicationType.applicationTypeClient, NULL_STRING, NULL_STRING, noOfDiscoveryUrls, discoveryUrls);
        ChannelSecurityToken securityToken = (ChannelSecurityToken)response.getSecurityToken();
        LOGGER.debug("Opened secure response id: {}, channel id:{}, token:{} lifetime:{}", new Object[]{response.getIdentifier(), securityToken.getChannelId(), securityToken.getTokenId(), securityToken.getRevisedLifetime()});
        this.conversation.setRemoteNonce(response.getServerNonce().getStringValue());
        byte[] temporaryNonce = this.conversation.createNonce(32);
        CreateSessionRequest createSessionRequest = new CreateSessionRequest(requestHeader, clientDescription, NULL_STRING, this.endpoint, new PascalString(this.sessionName), this.conversation.getSecurityPolicy() == SecurityPolicy.NONE ? NULL_BYTE_STRING : SecureChannel.createPascalString(temporaryNonce), this.conversation.getSecurityPolicy() == SecurityPolicy.NONE ? NULL_BYTE_STRING : this.localCertificateString, this.sessionTimeout, 0L);
        return ((CompletableFuture)this.conversation.submit(createSessionRequest, CreateSessionResponse.class).thenApply(sessionResponse -> {
            if (this.conversation.getSecurityPolicy() != SecurityPolicy.NONE) {
                SignatureData signatureData = this.extractSignatureData(sessionResponse.getServerSignature());
                if (signatureData == null) {
                    throw new IllegalArgumentException("Returned signature data is not valid");
                }
                String algorithm = signatureData.getAlgorithm().getStringValue();
                SecurityPolicy.SignatureAlgorithm signatureAlgorithm = this.conversation.getSecurityPolicy().getAsymmetricSignatureAlgorithm();
                if (!signatureAlgorithm.getUri().equals(algorithm)) {
                    throw new IllegalArgumentException("Invalid signature algorithm. Expected " + signatureAlgorithm.getUri());
                }
                try {
                    int certificateLength = this.localCertificateString.getStringLength();
                    byte[] rawData = new byte[certificateLength + 32];
                    System.arraycopy(this.localCertificateString.getStringValue(), 0, rawData, 0, certificateLength);
                    System.arraycopy(temporaryNonce, 0, rawData, certificateLength, 32);
                    X509Certificate remoteCertificate = this.conversation.getRemoteCertificate();
                    this.driverContext.getCertificateVerifier().checkCertificateTrusted(remoteCertificate);
                    Signature signature = signatureAlgorithm.getSignature();
                    signature.initVerify(remoteCertificate.getPublicKey());
                    signature.update(rawData);
                    if (!signature.verify(signatureData.getSignature().getStringValue())) {
                        throw new IllegalArgumentException("Could not verify server signature");
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            return sessionResponse;
        })).thenApply(responseMessage -> {
            this.conversation.setAuthenticationToken(responseMessage.getAuthenticationToken().getNodeId());
            this.sessionTimeout = responseMessage.getRevisedSessionTimeout();
            return responseMessage;
        });
    }

    private SignatureData extractSignatureData(ExtensionObjectDefinition object) {
        if (object instanceof SignatureData) {
            return (SignatureData)object;
        }
        return null;
    }

    private CompletableFuture<ActivateSessionResponse> onConnectActivateSessionRequest(CreateSessionResponse sessionResponse) {
        LOGGER.debug("Sending activate session request to {}", (Object)this.driverContext.getEndpoint());
        this.conversation.setRemoteCertificate(SecureChannel.getX509Certificate(sessionResponse.getServerCertificate().getStringValue()));
        this.conversation.setRemoteNonce(sessionResponse.getServerNonce().getStringValue());
        String[] endpoints = new String[3];
        try {
            InetAddress address = InetAddress.getByName(this.driverContext.getHost());
            endpoints[0] = "opc.tcp://" + address.getHostAddress() + ":" + this.driverContext.getPort() + this.driverContext.getTransportEndpoint();
            endpoints[1] = "opc.tcp://" + address.getHostName() + ":" + this.driverContext.getPort() + this.driverContext.getTransportEndpoint();
            endpoints[2] = "opc.tcp://" + address.getCanonicalHostName() + ":" + this.driverContext.getPort() + this.driverContext.getTransportEndpoint();
        }
        catch (UnknownHostException e) {
            LOGGER.debug("error getting host", (Throwable)e);
        }
        this.selectEndpoint(sessionResponse);
        if (this.policyId == null) {
            throw new PlcRuntimeException("Unable to find endpoint - " + endpoints[1]);
        }
        ExtensionObject userIdentityToken = this.getIdentityToken(this.tokenType, this.policyId.getStringValue());
        RequestHeader requestHeader = this.conversation.createRequestHeader();
        SignatureData clientSignature = new SignatureData(NULL_STRING, NULL_BYTE_STRING);
        if (this.conversation.getSecurityPolicy() != SecurityPolicy.NONE) {
            try {
                clientSignature = this.conversation.createClientSignature();
            }
            catch (GeneralSecurityException e) {
                throw new PlcRuntimeException("Could not create client signature", (Throwable)e);
            }
        }
        ActivateSessionRequest activateSessionRequest = new ActivateSessionRequest(requestHeader, clientSignature, 0, null, 0, null, userIdentityToken, clientSignature);
        return this.conversation.submit(activateSessionRequest, ActivateSessionResponse.class).thenApply(responseMessage -> {
            this.conversation.setRemoteNonce(responseMessage.getServerNonce().getStringValue());
            return responseMessage;
        });
    }

    public void onDisconnect() {
        LOGGER.info("Disconnecting");
        if (this.keepAlive != null) {
            this.keepAlive.cancel(true);
            this.keepAlive = null;
        }
        RequestHeader requestHeader = this.conversation.createRequestHeader(50000L);
        CloseSessionRequest closeSessionRequest = new CloseSessionRequest(requestHeader, true);
        this.conversation.submit(closeSessionRequest, CloseSessionResponse.class).thenAccept(responseMessage -> {
            LOGGER.trace("Got Close Session Response Connection Response" + responseMessage);
            this.onDisconnectCloseSecureChannel();
        });
    }

    private void onDisconnectCloseSecureChannel() {
        RequestHeader requestHeader = this.conversation.createRequestHeader();
        CloseSecureChannelRequest closeSecureChannelRequest = new CloseSecureChannelRequest(requestHeader);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(closeSecureChannelRequest.getIdentifier())), null, null);
        Function<CallContext, OpcuaCloseRequest> closeRequest = ctx -> new OpcuaCloseRequest(ChunkType.FINAL, ctx.getSecurityHeader(), new ExtensiblePayload(new SequenceHeader(ctx.getNextSequenceNumber(), ctx.getRequestId()), new ExtensionObject(expandedNodeId, null, closeSecureChannelRequest)));
        this.conversation.requestChannelClose(closeRequest);
    }

    public CompletableFuture<EndpointDescription> onDiscover() {
        LOGGER.debug("Opcua Driver running in ACTIVE mode, discovering endpoints");
        return ((CompletableFuture)((CompletableFuture)this.conversation.requestHello().thenCompose(ack -> this.onConnectOpenSecureChannel(SecurityTokenRequestType.securityTokenRequestTypeIssue))).thenCompose(scr -> this.onDiscoverGetEndpointsRequest((OpenSecureChannelResponse)scr))).thenApply(endpoint -> {
            LOGGER.info("Finished discovery of communication endpoint");
            return endpoint;
        });
    }

    public CompletableFuture<EndpointDescription> onDiscoverGetEndpointsRequest(OpenSecureChannelResponse openSecureChannelResponse) {
        RequestHeader requestHeader = this.conversation.createRequestHeader();
        GetEndpointsRequest endpointsRequest = new GetEndpointsRequest(requestHeader, this.endpoint, 0, null, 0, null);
        return this.conversation.submit(endpointsRequest, GetEndpointsResponse.class).thenApply(response -> {
            List<ExtensionObjectDefinition> endpoints = response.getEndpoints();
            MessageSecurityMode effectiveMode = this.configuration.getSecurityPolicy() == SecurityPolicy.NONE ? MessageSecurityMode.messageSecurityModeNone : this.configuration.getMessageSecurity().getMode();
            for (ExtensionObjectDefinition endpoint : endpoints) {
                EndpointDescription endpointDescription = (EndpointDescription)endpoint;
                boolean urlMatch = endpointDescription.getEndpointUrl().getStringValue().equals(this.endpoint.getStringValue());
                boolean policyMatch = endpointDescription.getSecurityPolicyUri().getStringValue().equals(this.configuration.getSecurityPolicy().getSecurityPolicyUri());
                boolean msgSecurityMatch = endpointDescription.getSecurityMode().equals((Object)effectiveMode);
                LOGGER.debug("Validate OPC UA endpoint {} during discovery phase.Expected {}. Endpoint policy {} looking for {}. Message security {}, looking for {}", new Object[]{endpointDescription.getEndpointUrl().getStringValue(), this.endpoint.getStringValue(), endpointDescription.getSecurityPolicyUri().getStringValue(), this.configuration.getSecurityPolicy().getSecurityPolicyUri(), endpointDescription.getSecurityMode(), this.configuration.getMessageSecurity().getMode()});
                if (!urlMatch || !policyMatch || !msgSecurityMatch) continue;
                LOGGER.info("Found OPC UA endpoint {}", (Object)this.endpoint.getStringValue());
                return endpointDescription;
            }
            throw new IllegalArgumentException("Could not find endpoint matching client configuration. Tested " + endpoints.size() + " endpoints. " + "None matched " + this.endpoint.getStringValue() + " " + this.configuration.getSecurityPolicy().getSecurityPolicyUri() + " " + (Object)((Object)this.configuration.getMessageSecurity().getMode()));
        });
    }

    private OpenSecureChannelResponse onOpenResponse(OpcuaOpenResponse opcuaOpenResponse) {
        try {
            ReadBufferByteBased readBuffer = SecureChannel.toBuffer(opcuaOpenResponse::getMessage);
            ExtensionObject message = ExtensionObject.staticParse((ReadBuffer)readBuffer, false);
            if (message.getBody() instanceof ServiceFault) {
                ServiceFault fault = (ServiceFault)message.getBody();
                throw new PlcRuntimeException((Throwable)Conversation.toProtocolException(fault));
            }
            LOGGER.debug("Received valid answer for open secure channel request, forwarding it to call initiator");
            return (OpenSecureChannelResponse)message.getBody();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not handle response", e);
        }
    }

    private void keepAlive() {
        long keepAliveTime = (long)Math.ceil((float)this.revisedLifetime * 0.75f);
        LOGGER.debug("Scheduling session keep alive to happen within {}s", (Object)TimeUnit.MILLISECONDS.toSeconds(keepAliveTime));
        this.keepAlive = KEEP_ALIVE_EXECUTOR.schedule(() -> {
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.onConnectOpenSecureChannel(SecurityTokenRequestType.securityTokenRequestTypeRenew).whenComplete((response, error) -> {
                if (error != null) {
                    transaction.failRequest(error);
                    return;
                }
                transaction.endRequest();
            }));
        }, keepAliveTime, TimeUnit.MILLISECONDS);
    }

    private static ReadBufferByteBased toBuffer(Supplier<Payload> supplier) {
        Payload payload = supplier.get();
        if (!(payload instanceof BinaryPayload)) {
            throw new IllegalArgumentException("Unexpected payload kind");
        }
        return new ReadBufferByteBased(((BinaryPayload)payload).getPayload(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
    }

    private void selectEndpoint(CreateSessionResponse sessionResponse) throws PlcRuntimeException {
        Stream<EndpointDescription> filteredEndpoints = sessionResponse.getServerEndpoints().stream().map(e -> (EndpointDescription)e).filter(this::isEndpoint);
        filteredEndpoints.forEach(endpoint -> this.hasIdentity((UserTokenPolicy[])endpoint.getUserIdentityTokens().stream().map(p -> (UserTokenPolicy)p).toArray(UserTokenPolicy[]::new)));
        if (this.policyId == null) {
            throw new PlcRuntimeException("Unable to find endpoint - " + this.endpoints.get(0));
        }
        if (this.tokenType == null) {
            throw new PlcRuntimeException("Unable to find Security Policy for endpoint - " + this.endpoints.get(0));
        }
    }

    private boolean isEndpoint(EndpointDescription endpoint) throws PlcRuntimeException {
        String endpointUri = endpoint.getEndpointUrl().getStringValue();
        Matcher matcher = URI_PATTERN.matcher(endpointUri);
        if (!matcher.matches()) {
            throw new PlcRuntimeException("Endpoint " + endpointUri + "  returned from the server doesn't match the format '{protocol-code}:({transport-code})?//{transport-host}(:{transport-port})(/{transport-endpoint})'");
        }
        LOGGER.trace("Using Endpoint {} {} {}", new Object[]{matcher.group("transportHost"), matcher.group("transportPort"), matcher.group("transportEndpoint")});
        if (!this.configuration.isDiscovery() && StringUtils.isBlank((CharSequence)this.driverContext.getTransportEndpoint())) {
            this.driverContext.setTransportEndpoint(matcher.group("transportEndpoint"));
            return true;
        }
        if (this.configuration.isDiscovery() && !this.endpoints.contains(matcher.group("transportHost"))) {
            return false;
        }
        if (!this.driverContext.getPort().equals(matcher.group("transportPort"))) {
            return false;
        }
        return this.driverContext.getTransportEndpoint().equals(matcher.group("transportEndpoint"));
    }

    private void hasIdentity(UserTokenPolicy[] policies) {
        UserTokenPolicy[] userTokenPolicyArray = policies;
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            UserTokenPolicy identityToken = userTokenPolicyArray[n2];
            if (identityToken.getTokenType() == UserTokenType.userTokenTypeAnonymous && this.username == null) {
                this.policyId = identityToken.getPolicyId();
                this.tokenType = identityToken.getTokenType();
            } else if (identityToken.getTokenType() == UserTokenType.userTokenTypeUserName && this.username != null) {
                this.policyId = identityToken.getPolicyId();
                this.tokenType = identityToken.getTokenType();
            }
            ++n2;
        }
    }

    private ExtensionObject getIdentityToken(UserTokenType tokenType, String securityPolicy) {
        switch (tokenType) {
            case userTokenTypeAnonymous: {
                AnonymousIdentityToken anonymousIdentityToken = new AnonymousIdentityToken();
                ExpandedNodeId extExpandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, OpcuaNodeIdServicesObject.AnonymousIdentityToken_Encoding_DefaultBinary.getValue()), null, null);
                return new ExtensionObject(extExpandedNodeId, new ExtensionObjectEncodingMask(false, false, true), new UserIdentityToken(new PascalString(securityPolicy), anonymousIdentityToken));
            }
            case userTokenTypeUserName: {
                byte[] remoteNonce = this.conversation.getRemoteNonce();
                byte[] passwordBytes = this.password == null ? new byte[]{} : this.password.getBytes();
                ByteBuffer encodeableBuffer = ByteBuffer.allocate(4 + passwordBytes.length + remoteNonce.length);
                encodeableBuffer.order(ByteOrder.LITTLE_ENDIAN);
                encodeableBuffer.putInt(passwordBytes.length + remoteNonce.length);
                encodeableBuffer.put(passwordBytes);
                encodeableBuffer.put(remoteNonce);
                byte[] encodeablePassword = new byte[4 + passwordBytes.length + remoteNonce.length];
                encodeableBuffer.position(0);
                encodeableBuffer.get(encodeablePassword);
                byte[] encryptedPassword = this.conversation.encryptPassword(encodeablePassword);
                UserNameIdentityToken userNameIdentityToken = new UserNameIdentityToken(new PascalString(this.username), new PascalByteString(encryptedPassword.length, encryptedPassword), new PascalString(PASSWORD_ENCRYPTION_ALGORITHM));
                ExpandedNodeId extExpandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, OpcuaNodeIdServicesObject.UserNameIdentityToken_Encoding_DefaultBinary.getValue()), null, null);
                return new ExtensionObject(extExpandedNodeId, new ExtensionObjectEncodingMask(false, false, true), new UserIdentityToken(new PascalString(securityPolicy), userNameIdentityToken));
            }
        }
        return null;
    }

    public static X509Certificate getX509Certificate(byte[] certificate) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate));
        }
        catch (Exception e) {
            LOGGER.error("Unable to get certificate from String {}", (Object)certificate);
            return null;
        }
    }

    private static PascalByteString createPascalString(byte[] bytes) {
        if (bytes == null) {
            return NULL_BYTE_STRING;
        }
        return new PascalByteString(bytes.length, bytes);
    }
}

