/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.plc4x.java.opcua.context.BaseEncryptionHandler;
import org.apache.plc4x.java.opcua.context.Conversation;
import org.apache.plc4x.java.opcua.protocol.chunk.Chunk;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;
import org.apache.plc4x.java.opcua.security.SymmetricKeys;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;

public class SymmetricEncryptionHandler
extends BaseEncryptionHandler {
    private SymmetricKeys keys = null;

    public SymmetricEncryptionHandler(Conversation channel, SecurityPolicy policy) {
        super(channel, policy);
    }

    @Override
    protected void verify(WriteBufferByteBased buffer, Chunk chunk, int messageLength) throws Exception {
        int signatureStart = messageLength - chunk.getSignatureSize();
        byte[] message = buffer.getBytes(0, signatureStart);
        byte[] signatureData = buffer.getBytes(signatureStart, signatureStart + chunk.getSignatureSize());
        SymmetricKeys symmetricKeys = this.getSymmetricKeys(this.conversation.getLocalNonce(), this.conversation.getRemoteNonce());
        SecurityPolicy.MacSignatureAlgorithm algorithm = this.securityPolicy.getSymmetricSignatureAlgorithm();
        Mac signature = algorithm.getSignature();
        signature.init(new SecretKeySpec(symmetricKeys.getServerKeys().getSignatureKey(), algorithm.getName()));
        signature.update(message);
        byte[] signatureBytes = signature.doFinal();
        if (!MessageDigest.isEqual(signatureData, signatureBytes)) {
            throw new IllegalArgumentException("Invalid signature");
        }
    }

    @Override
    protected int decrypt(WriteBufferByteBased chunkBuffer, Chunk chunk, int messageLength) throws Exception {
        int bodyStart = 12 + chunk.getSecurityHeaderSize();
        int bodySize = messageLength - bodyStart;
        int blockCount = bodySize / chunk.getCipherTextBlockSize();
        assert (bodySize % chunk.getCipherTextBlockSize() == 0);
        byte[] encrypted = chunkBuffer.getBytes(bodyStart, bodyStart + bodySize);
        byte[] plainText = new byte[chunk.getCipherTextBlockSize() * blockCount];
        SymmetricKeys symmetricKeys = this.getSymmetricKeys(this.conversation.getLocalNonce(), this.conversation.getRemoteNonce());
        Cipher cipher = SymmetricEncryptionHandler.getCipher(symmetricKeys.getServerKeys(), this.securityPolicy.getSymmetricEncryptionAlgorithm(), 2);
        int bodyLength = cipher.doFinal(encrypted, 0, encrypted.length, plainText, 0);
        chunkBuffer.setPos(bodyStart);
        chunkBuffer.writeByteArray("payload", plainText, new WithWriterArgs[0]);
        return bodyLength;
    }

    @Override
    protected void encrypt(WriteBufferByteBased buffer, int securityHeaderSize, int plainTextBlockSize, int cipherTextBlockSize, int blockCount) throws Exception {
        SymmetricKeys symmetricKeys = this.getSymmetricKeys(this.conversation.getLocalNonce(), this.conversation.getRemoteNonce());
        int bodyStart = 12 + securityHeaderSize;
        byte[] copy = buffer.getBytes(bodyStart, bodyStart + plainTextBlockSize * blockCount);
        byte[] encrypted = new byte[cipherTextBlockSize * blockCount];
        SecurityPolicy.EncryptionAlgorithm transformation = this.securityPolicy.getSymmetricEncryptionAlgorithm();
        Cipher cipher = SymmetricEncryptionHandler.getCipher(symmetricKeys.getClientKeys(), transformation, 1);
        cipher.doFinal(copy, 0, copy.length, encrypted, 0);
        buffer.setPos(bodyStart);
        buffer.writeByteArray("encrypted", encrypted, new WithWriterArgs[0]);
    }

    @Override
    protected byte[] sign(byte[] data) throws GeneralSecurityException {
        SymmetricKeys symmetricKeys = this.getSymmetricKeys(this.conversation.getLocalNonce(), this.conversation.getRemoteNonce());
        SecurityPolicy.MacSignatureAlgorithm algorithm = this.securityPolicy.getSymmetricSignatureAlgorithm();
        Mac signature = algorithm.getSignature();
        signature.init(new SecretKeySpec(symmetricKeys.getClientKeys().getSignatureKey(), algorithm.getName()));
        signature.update(data);
        return signature.doFinal();
    }

    private SymmetricKeys getSymmetricKeys(byte[] senderNonce, byte[] receiverNonce) {
        if (this.keys == null) {
            this.keys = SymmetricKeys.generateKeyPair(senderNonce, receiverNonce, this.securityPolicy);
        }
        return this.keys;
    }

    private static Cipher getCipher(SymmetricKeys.Keys symmetricKeys, SecurityPolicy.EncryptionAlgorithm transformation, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = transformation.getCipher();
        SecretKeySpec keySpec = new SecretKeySpec(symmetricKeys.getEncryptionKey(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(symmetricKeys.getInitializationVector());
        cipher.init(mode, (Key)keySpec, ivSpec);
        return cipher;
    }
}

