/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol.chunk;

import java.nio.ByteBuffer;
import org.apache.plc4x.java.opcua.readwrite.BinaryPayload;
import org.apache.plc4x.java.opcua.readwrite.ExtensiblePayload;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;

public class PayloadConverter {
    public static BinaryPayload toBinary(Payload payload) throws SerializationException {
        if (payload instanceof BinaryPayload) {
            return (BinaryPayload)payload;
        }
        return PayloadConverter.toBinary((ExtensiblePayload)payload);
    }

    public static BinaryPayload toBinary(ExtensiblePayload extensible) throws SerializationException {
        ExtensionObject payload = extensible.getPayload();
        WriteBufferByteBased buffer = new WriteBufferByteBased(payload.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
        payload.serialize((WriteBuffer)buffer);
        return new BinaryPayload(extensible.getSequenceHeader(), buffer.getBytes());
    }

    public static ExtensiblePayload toExtensible(BinaryPayload binary) throws ParseException {
        byte[] payload = binary.getPayload();
        ReadBufferByteBased buffer = new ReadBufferByteBased(payload, ByteOrder.LITTLE_ENDIAN);
        ExtensionObject extensionObject = ExtensionObject.staticParse((ReadBuffer)buffer, false);
        return new ExtensiblePayload(binary.getSequenceHeader(), extensionObject);
    }

    public static byte[] toStream(Payload payload) throws SerializationException {
        return PayloadConverter.serialize(payload);
    }

    public static byte[] toStream(MessagePDU apdu) throws SerializationException {
        return PayloadConverter.serialize(apdu);
    }

    private static byte[] serialize(Message message) throws SerializationException {
        WriteBufferByteBased buffer = new WriteBufferByteBased(message.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
        message.serialize((WriteBuffer)buffer);
        return buffer.getBytes();
    }

    public static Payload fromStream(byte[] payload, boolean extensible) throws ParseException {
        ReadBufferByteBased buffer = new ReadBufferByteBased(payload, ByteOrder.LITTLE_ENDIAN);
        return Payload.staticParse((ReadBuffer)buffer, extensible, Long.valueOf(extensible ? -1 : payload.length - 8));
    }

    public static MessagePDU fromStream(ByteBuffer chunkBuffer, boolean response, boolean encrypted) throws ParseException {
        ReadBufferByteBased buffer = new ReadBufferByteBased(chunkBuffer.array(), ByteOrder.LITTLE_ENDIAN);
        return MessagePDU.staticParse((ReadBuffer)buffer, response, encrypted);
    }

    public static MessagePDU pduFromStream(byte[] message, boolean response) throws ParseException {
        ReadBufferByteBased buffer = new ReadBufferByteBased(message, ByteOrder.LITTLE_ENDIAN);
        return MessagePDU.staticParse((ReadBuffer)buffer, response);
    }
}

