/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeClass;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AddReferencesItem
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId sourceNodeId;
    protected final NodeId referenceTypeId;
    protected final boolean isForward;
    protected final PascalString targetServerUri;
    protected final ExpandedNodeId targetNodeId;
    protected final NodeClass targetNodeClass;

    @Override
    public String getIdentifier() {
        return "381";
    }

    public AddReferencesItem(NodeId sourceNodeId, NodeId referenceTypeId, boolean isForward, PascalString targetServerUri, ExpandedNodeId targetNodeId, NodeClass targetNodeClass) {
        this.sourceNodeId = sourceNodeId;
        this.referenceTypeId = referenceTypeId;
        this.isForward = isForward;
        this.targetServerUri = targetServerUri;
        this.targetNodeId = targetNodeId;
        this.targetNodeClass = targetNodeClass;
    }

    public NodeId getSourceNodeId() {
        return this.sourceNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public boolean getIsForward() {
        return this.isForward;
    }

    public PascalString getTargetServerUri() {
        return this.targetServerUri;
    }

    public ExpandedNodeId getTargetNodeId() {
        return this.targetNodeId;
    }

    public NodeClass getTargetNodeClass() {
        return this.targetNodeClass;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AddReferencesItem", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sourceNodeId", (Object)this.sourceNodeId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"referenceTypeId", (Object)this.referenceTypeId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"isForward", (Object)this.isForward, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"targetServerUri", (Object)this.targetServerUri, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"targetNodeId", (Object)this.targetNodeId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"targetNodeClass", (String)"NodeClass", (Object)((Object)this.targetNodeClass), (DataWriter)new DataWriterEnumDefault(NodeClass::getValue, Enum::name, DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AddReferencesItem", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AddReferencesItem _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.sourceNodeId.getLengthInBits();
        lengthInBits += this.referenceTypeId.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += this.targetServerUri.getLengthInBits();
        lengthInBits += this.targetNodeId.getLengthInBits();
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("AddReferencesItem", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId sourceNodeId = (NodeId)FieldReaderFactory.readSimpleField((String)"sourceNodeId", (DataReader)new DataReaderComplexDefault(() -> NodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId referenceTypeId = (NodeId)FieldReaderFactory.readSimpleField((String)"referenceTypeId", (DataReader)new DataReaderComplexDefault(() -> NodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isForward = (Boolean)FieldReaderFactory.readSimpleField((String)"isForward", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString targetServerUri = (PascalString)FieldReaderFactory.readSimpleField((String)"targetServerUri", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExpandedNodeId targetNodeId = (ExpandedNodeId)FieldReaderFactory.readSimpleField((String)"targetNodeId", (DataReader)new DataReaderComplexDefault(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeClass targetNodeClass = (NodeClass)((Object)FieldReaderFactory.readEnumField((String)"targetNodeClass", (String)"NodeClass", (DataReader)new DataReaderEnumDefault(NodeClass::enumForValue, DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        readBuffer.closeContext("AddReferencesItem", new WithReaderArgs[0]);
        return new AddReferencesItemBuilderImpl(sourceNodeId, referenceTypeId, isForward, targetServerUri, targetNodeId, targetNodeClass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddReferencesItem)) {
            return false;
        }
        AddReferencesItem that = (AddReferencesItem)o;
        return this.getSourceNodeId() == that.getSourceNodeId() && this.getReferenceTypeId() == that.getReferenceTypeId() && this.getIsForward() == that.getIsForward() && this.getTargetServerUri() == that.getTargetServerUri() && this.getTargetNodeId() == that.getTargetNodeId() && this.getTargetNodeClass() == that.getTargetNodeClass() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getSourceNodeId(), this.getReferenceTypeId(), this.getIsForward(), this.getTargetServerUri(), this.getTargetNodeId(), this.getTargetNodeClass()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AddReferencesItemBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId sourceNodeId;
        private final NodeId referenceTypeId;
        private final boolean isForward;
        private final PascalString targetServerUri;
        private final ExpandedNodeId targetNodeId;
        private final NodeClass targetNodeClass;

        public AddReferencesItemBuilderImpl(NodeId sourceNodeId, NodeId referenceTypeId, boolean isForward, PascalString targetServerUri, ExpandedNodeId targetNodeId, NodeClass targetNodeClass) {
            this.sourceNodeId = sourceNodeId;
            this.referenceTypeId = referenceTypeId;
            this.isForward = isForward;
            this.targetServerUri = targetServerUri;
            this.targetNodeId = targetNodeId;
            this.targetNodeClass = targetNodeClass;
        }

        @Override
        public AddReferencesItem build() {
            AddReferencesItem addReferencesItem = new AddReferencesItem(this.sourceNodeId, this.referenceTypeId, this.isForward, this.targetServerUri, this.targetNodeId, this.targetNodeClass);
            return addReferencesItem;
        }
    }
}

