/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BrowsePath
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId startingNode;
    protected final ExtensionObjectDefinition relativePath;

    @Override
    public String getIdentifier() {
        return "545";
    }

    public BrowsePath(NodeId startingNode, ExtensionObjectDefinition relativePath) {
        this.startingNode = startingNode;
        this.relativePath = relativePath;
    }

    public NodeId getStartingNode() {
        return this.startingNode;
    }

    public ExtensionObjectDefinition getRelativePath() {
        return this.relativePath;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BrowsePath", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"startingNode", (Object)this.startingNode, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"relativePath", (Object)this.relativePath, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BrowsePath", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BrowsePath _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.startingNode.getLengthInBits();
        return lengthInBits += this.relativePath.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("BrowsePath", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId startingNode = (NodeId)FieldReaderFactory.readSimpleField((String)"startingNode", (DataReader)new DataReaderComplexDefault(() -> NodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObjectDefinition relativePath = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"relativePath", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "542"), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BrowsePath", new WithReaderArgs[0]);
        return new BrowsePathBuilderImpl(startingNode, relativePath);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowsePath)) {
            return false;
        }
        BrowsePath that = (BrowsePath)o;
        return this.getStartingNode() == that.getStartingNode() && this.getRelativePath() == that.getRelativePath() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStartingNode(), this.getRelativePath());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BrowsePathBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId startingNode;
        private final ExtensionObjectDefinition relativePath;

        public BrowsePathBuilderImpl(NodeId startingNode, ExtensionObjectDefinition relativePath) {
            this.startingNode = startingNode;
            this.relativePath = relativePath;
        }

        @Override
        public BrowsePath build() {
            BrowsePath browsePath = new BrowsePath(this.startingNode, this.relativePath);
            return browsePath;
        }
    }
}

