/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EndpointType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString endpointUrl;
    protected final MessageSecurityMode securityMode;
    protected final PascalString securityPolicyUri;
    protected final PascalString transportProfileUri;

    @Override
    public String getIdentifier() {
        return "15530";
    }

    public EndpointType(PascalString endpointUrl, MessageSecurityMode securityMode, PascalString securityPolicyUri, PascalString transportProfileUri) {
        this.endpointUrl = endpointUrl;
        this.securityMode = securityMode;
        this.securityPolicyUri = securityPolicyUri;
        this.transportProfileUri = transportProfileUri;
    }

    public PascalString getEndpointUrl() {
        return this.endpointUrl;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalString getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public PascalString getTransportProfileUri() {
        return this.transportProfileUri;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EndpointType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"endpointUrl", (Object)this.endpointUrl, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"securityMode", (String)"MessageSecurityMode", (Object)((Object)this.securityMode), (DataWriter)new DataWriterEnumDefault(MessageSecurityMode::getValue, Enum::name, DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityPolicyUri", (Object)this.securityPolicyUri, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"transportProfileUri", (Object)this.transportProfileUri, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("EndpointType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EndpointType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.endpointUrl.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += this.securityPolicyUri.getLengthInBits();
        return lengthInBits += this.transportProfileUri.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("EndpointType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString endpointUrl = (PascalString)FieldReaderFactory.readSimpleField((String)"endpointUrl", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField((String)"securityMode", (String)"MessageSecurityMode", (DataReader)new DataReaderEnumDefault(MessageSecurityMode::enumForValue, DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString securityPolicyUri = (PascalString)FieldReaderFactory.readSimpleField((String)"securityPolicyUri", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString transportProfileUri = (PascalString)FieldReaderFactory.readSimpleField((String)"transportProfileUri", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("EndpointType", new WithReaderArgs[0]);
        return new EndpointTypeBuilderImpl(endpointUrl, securityMode, securityPolicyUri, transportProfileUri);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointType)) {
            return false;
        }
        EndpointType that = (EndpointType)o;
        return this.getEndpointUrl() == that.getEndpointUrl() && this.getSecurityMode() == that.getSecurityMode() && this.getSecurityPolicyUri() == that.getSecurityPolicyUri() && this.getTransportProfileUri() == that.getTransportProfileUri() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getEndpointUrl(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getTransportProfileUri()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EndpointTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString endpointUrl;
        private final MessageSecurityMode securityMode;
        private final PascalString securityPolicyUri;
        private final PascalString transportProfileUri;

        public EndpointTypeBuilderImpl(PascalString endpointUrl, MessageSecurityMode securityMode, PascalString securityPolicyUri, PascalString transportProfileUri) {
            this.endpointUrl = endpointUrl;
            this.securityMode = securityMode;
            this.securityPolicyUri = securityPolicyUri;
            this.transportProfileUri = transportProfileUri;
        }

        @Override
        public EndpointType build() {
            EndpointType endpointType = new EndpointType(this.endpointUrl, this.securityMode, this.securityPolicyUri, this.transportProfileUri);
            return endpointType;
        }
    }
}

