/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.OpcuaDriverContext;
import org.apache.plc4x.java.opcua.optimizer.OpcuaOptimizer;
import org.apache.plc4x.java.opcua.protocol.OpcuaProtocolLogic;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.tag.OpcuaTag;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.values.LegacyPlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class OpcuaPlcDriver
extends GeneratedDriverBase<OpcuaAPU> {
    public String getProtocolCode() {
        return "opcua";
    }

    public String getProtocolName() {
        return "Opcua";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return OpcuaConfiguration.class;
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    protected PlcValueHandler getValueHandler() {
        return new LegacyPlcValueHandler();
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected OpcuaOptimizer getOptimizer() {
        return new OpcuaOptimizer();
    }

    protected boolean fireDiscoverEvent() {
        return true;
    }

    protected boolean awaitDiscoverComplete() {
        return true;
    }

    protected ProtocolStackConfigurer<OpcuaAPU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(OpcuaAPU.class, io -> OpcuaAPU.staticParse(io, true, true)).withProtocol(OpcuaProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withDriverContext(OpcuaDriverContext.class).littleEndian().build();
    }

    public OpcuaTag prepareTag(String tagAddress) {
        return OpcuaTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 8) {
                return Integer.reverseBytes(byteBuf.getInt(byteBuf.readerIndex() + 4));
            }
            return -1;
        }
    }
}

