/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.SignatureData;
import org.apache.plc4x.java.opcua.readwrite.SignedSoftwareCertificate;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ActivateSessionRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final SignatureData clientSignature;
    protected final List<SignedSoftwareCertificate> clientSoftwareCertificates;
    protected final List<PascalString> localeIds;
    protected final ExtensionObject userIdentityToken;
    protected final SignatureData userTokenSignature;

    @Override
    public Integer getExtensionId() {
        return 467;
    }

    public ActivateSessionRequest(RequestHeader requestHeader, SignatureData clientSignature, List<SignedSoftwareCertificate> clientSoftwareCertificates, List<PascalString> localeIds, ExtensionObject userIdentityToken, SignatureData userTokenSignature) {
        this.requestHeader = requestHeader;
        this.clientSignature = clientSignature;
        this.clientSoftwareCertificates = clientSoftwareCertificates;
        this.localeIds = localeIds;
        this.userIdentityToken = userIdentityToken;
        this.userTokenSignature = userTokenSignature;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public SignatureData getClientSignature() {
        return this.clientSignature;
    }

    public List<SignedSoftwareCertificate> getClientSoftwareCertificates() {
        return this.clientSoftwareCertificates;
    }

    public List<PascalString> getLocaleIds() {
        return this.localeIds;
    }

    public ExtensionObject getUserIdentityToken() {
        return this.userIdentityToken;
    }

    public SignatureData getUserTokenSignature() {
        return this.userTokenSignature;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ActivateSessionRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"clientSignature", (Object)this.clientSignature, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfClientSoftwareCertificates = this.getClientSoftwareCertificates() == null ? -1 : StaticHelper.COUNT(this.getClientSoftwareCertificates());
        FieldWriterFactory.writeImplicitField((String)"noOfClientSoftwareCertificates", (Object)noOfClientSoftwareCertificates, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"clientSoftwareCertificates", this.clientSoftwareCertificates, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfLocaleIds = this.getLocaleIds() == null ? -1 : StaticHelper.COUNT(this.getLocaleIds());
        FieldWriterFactory.writeImplicitField((String)"noOfLocaleIds", (Object)noOfLocaleIds, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"localeIds", this.localeIds, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"userIdentityToken", (Object)this.userIdentityToken, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"userTokenSignature", (Object)this.userTokenSignature, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ActivateSessionRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ActivateSessionRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.clientSignature.getLengthInBits();
        lengthInBits += 32;
        if (this.clientSoftwareCertificates != null) {
            i = 0;
            for (SignedSoftwareCertificate signedSoftwareCertificate : this.clientSoftwareCertificates) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.clientSoftwareCertificates.size());
                lengthInBits += signedSoftwareCertificate.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.localeIds != null) {
            i = 0;
            for (PascalString pascalString : this.localeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.localeIds.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += this.userIdentityToken.getLengthInBits();
        return lengthInBits += this.userTokenSignature.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ActivateSessionRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        SignatureData clientSignature = (SignatureData)FieldReaderFactory.readSimpleField((String)"clientSignature", (DataReader)DataReaderFactory.readComplex(() -> (SignatureData)ExtensionObjectDefinition.staticParse(readBuffer, 458), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfClientSoftwareCertificates = (Integer)FieldReaderFactory.readImplicitField((String)"noOfClientSoftwareCertificates", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List clientSoftwareCertificates = FieldReaderFactory.readCountArrayField((String)"clientSoftwareCertificates", (DataReader)DataReaderFactory.readComplex(() -> (SignedSoftwareCertificate)ExtensionObjectDefinition.staticParse(readBuffer, 346), (ReadBuffer)readBuffer), (long)noOfClientSoftwareCertificates, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfLocaleIds = (Integer)FieldReaderFactory.readImplicitField((String)"noOfLocaleIds", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List localeIds = FieldReaderFactory.readCountArrayField((String)"localeIds", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfLocaleIds, (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject userIdentityToken = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"userIdentityToken", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        SignatureData userTokenSignature = (SignatureData)FieldReaderFactory.readSimpleField((String)"userTokenSignature", (DataReader)DataReaderFactory.readComplex(() -> (SignatureData)ExtensionObjectDefinition.staticParse(readBuffer, 458), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ActivateSessionRequest", new WithReaderArgs[0]);
        return new ActivateSessionRequestBuilderImpl(requestHeader, clientSignature, clientSoftwareCertificates, localeIds, userIdentityToken, userTokenSignature);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivateSessionRequest)) {
            return false;
        }
        ActivateSessionRequest that = (ActivateSessionRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getClientSignature() == that.getClientSignature() && this.getClientSoftwareCertificates() == that.getClientSoftwareCertificates() && this.getLocaleIds() == that.getLocaleIds() && this.getUserIdentityToken() == that.getUserIdentityToken() && this.getUserTokenSignature() == that.getUserTokenSignature() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getClientSignature(), this.getClientSoftwareCertificates(), this.getLocaleIds(), this.getUserIdentityToken(), this.getUserTokenSignature());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ActivateSessionRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final SignatureData clientSignature;
        private final List<SignedSoftwareCertificate> clientSoftwareCertificates;
        private final List<PascalString> localeIds;
        private final ExtensionObject userIdentityToken;
        private final SignatureData userTokenSignature;

        public ActivateSessionRequestBuilderImpl(RequestHeader requestHeader, SignatureData clientSignature, List<SignedSoftwareCertificate> clientSoftwareCertificates, List<PascalString> localeIds, ExtensionObject userIdentityToken, SignatureData userTokenSignature) {
            this.requestHeader = requestHeader;
            this.clientSignature = clientSignature;
            this.clientSoftwareCertificates = clientSoftwareCertificates;
            this.localeIds = localeIds;
            this.userIdentityToken = userIdentityToken;
            this.userTokenSignature = userTokenSignature;
        }

        @Override
        public ActivateSessionRequest build() {
            ActivateSessionRequest activateSessionRequest = new ActivateSessionRequest(this.requestHeader, this.clientSignature, this.clientSoftwareCertificates, this.localeIds, this.userIdentityToken, this.userTokenSignature);
            return activateSessionRequest;
        }
    }
}

