/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.BrowsePathTarget;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BrowsePathResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final List<BrowsePathTarget> targets;

    @Override
    public Integer getExtensionId() {
        return 551;
    }

    public BrowsePathResult(StatusCode statusCode, List<BrowsePathTarget> targets) {
        this.statusCode = statusCode;
        this.targets = targets;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public List<BrowsePathTarget> getTargets() {
        return this.targets;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BrowsePathResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfTargets = this.getTargets() == null ? -1 : StaticHelper.COUNT(this.getTargets());
        FieldWriterFactory.writeImplicitField((String)"noOfTargets", (Object)noOfTargets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"targets", this.targets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BrowsePathResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BrowsePathResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.targets != null) {
            int i = 0;
            for (BrowsePathTarget element : this.targets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.targets.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("BrowsePathResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfTargets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfTargets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List targets = FieldReaderFactory.readCountArrayField((String)"targets", (DataReader)DataReaderFactory.readComplex(() -> (BrowsePathTarget)ExtensionObjectDefinition.staticParse(readBuffer, 548), (ReadBuffer)readBuffer), (long)noOfTargets, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BrowsePathResult", new WithReaderArgs[0]);
        return new BrowsePathResultBuilderImpl(statusCode, targets);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowsePathResult)) {
            return false;
        }
        BrowsePathResult that = (BrowsePathResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getTargets() == that.getTargets() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getTargets());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BrowsePathResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final List<BrowsePathTarget> targets;

        public BrowsePathResultBuilderImpl(StatusCode statusCode, List<BrowsePathTarget> targets) {
            this.statusCode = statusCode;
            this.targets = targets;
        }

        @Override
        public BrowsePathResult build() {
            BrowsePathResult browsePathResult = new BrowsePathResult(this.statusCode, this.targets);
            return browsePathResult;
        }
    }
}

