/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ContentFilterElementResult;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ContentFilterResult
extends ExtensionObjectDefinition
implements Message {
    protected final List<ContentFilterElementResult> elementResults;
    protected final List<DiagnosticInfo> elementDiagnosticInfos;

    @Override
    public Integer getExtensionId() {
        return 609;
    }

    public ContentFilterResult(List<ContentFilterElementResult> elementResults, List<DiagnosticInfo> elementDiagnosticInfos) {
        this.elementResults = elementResults;
        this.elementDiagnosticInfos = elementDiagnosticInfos;
    }

    public List<ContentFilterElementResult> getElementResults() {
        return this.elementResults;
    }

    public List<DiagnosticInfo> getElementDiagnosticInfos() {
        return this.elementDiagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ContentFilterResult", new WithWriterArgs[0]);
        int noOfElementResults = this.getElementResults() == null ? -1 : StaticHelper.COUNT(this.getElementResults());
        FieldWriterFactory.writeImplicitField((String)"noOfElementResults", (Object)noOfElementResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"elementResults", this.elementResults, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfElementDiagnosticInfos = this.getElementDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getElementDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfElementDiagnosticInfos", (Object)noOfElementDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"elementDiagnosticInfos", this.elementDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ContentFilterResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ContentFilterResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.elementResults != null) {
            i = 0;
            for (ContentFilterElementResult contentFilterElementResult : this.elementResults) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.elementResults.size());
                lengthInBits += contentFilterElementResult.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.elementDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.elementDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.elementDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ContentFilterResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfElementResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfElementResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List elementResults = FieldReaderFactory.readCountArrayField((String)"elementResults", (DataReader)DataReaderFactory.readComplex(() -> (ContentFilterElementResult)ExtensionObjectDefinition.staticParse(readBuffer, 606), (ReadBuffer)readBuffer), (long)noOfElementResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfElementDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfElementDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List elementDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"elementDiagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfElementDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ContentFilterResult", new WithReaderArgs[0]);
        return new ContentFilterResultBuilderImpl(elementResults, elementDiagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentFilterResult)) {
            return false;
        }
        ContentFilterResult that = (ContentFilterResult)o;
        return this.getElementResults() == that.getElementResults() && this.getElementDiagnosticInfos() == that.getElementDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getElementResults(), this.getElementDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ContentFilterResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<ContentFilterElementResult> elementResults;
        private final List<DiagnosticInfo> elementDiagnosticInfos;

        public ContentFilterResultBuilderImpl(List<ContentFilterElementResult> elementResults, List<DiagnosticInfo> elementDiagnosticInfos) {
            this.elementResults = elementResults;
            this.elementDiagnosticInfos = elementDiagnosticInfos;
        }

        @Override
        public ContentFilterResult build() {
            ContentFilterResult contentFilterResult = new ContentFilterResult(this.elementResults, this.elementDiagnosticInfos);
            return contentFilterResult;
        }
    }
}

