/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataChangeTrigger;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DataChangeFilter
extends ExtensionObjectDefinition
implements Message {
    protected final DataChangeTrigger trigger;
    protected final long deadbandType;
    protected final double deadbandValue;

    @Override
    public Integer getExtensionId() {
        return 724;
    }

    public DataChangeFilter(DataChangeTrigger trigger, long deadbandType, double deadbandValue) {
        this.trigger = trigger;
        this.deadbandType = deadbandType;
        this.deadbandValue = deadbandValue;
    }

    public DataChangeTrigger getTrigger() {
        return this.trigger;
    }

    public long getDeadbandType() {
        return this.deadbandType;
    }

    public double getDeadbandValue() {
        return this.deadbandValue;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DataChangeFilter", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"trigger", (String)"DataChangeTrigger", (Object)((Object)this.trigger), (DataWriter)DataWriterFactory.writeEnum(DataChangeTrigger::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"deadbandType", (Object)this.deadbandType, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"deadbandValue", (Object)this.deadbandValue, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DataChangeFilter", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DataChangeFilter _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += 64;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DataChangeFilter", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        DataChangeTrigger trigger = (DataChangeTrigger)((Object)FieldReaderFactory.readEnumField((String)"trigger", (String)"DataChangeTrigger", (DataReader)DataReaderFactory.readEnum(DataChangeTrigger::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        long deadbandType = (Long)FieldReaderFactory.readSimpleField((String)"deadbandType", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        double deadbandValue = (Double)FieldReaderFactory.readSimpleField((String)"deadbandValue", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DataChangeFilter", new WithReaderArgs[0]);
        return new DataChangeFilterBuilderImpl(trigger, deadbandType, deadbandValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataChangeFilter)) {
            return false;
        }
        DataChangeFilter that = (DataChangeFilter)o;
        return this.getTrigger() == that.getTrigger() && this.getDeadbandType() == that.getDeadbandType() && this.getDeadbandValue() == that.getDeadbandValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getTrigger(), this.getDeadbandType(), this.getDeadbandValue()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DataChangeFilterBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final DataChangeTrigger trigger;
        private final long deadbandType;
        private final double deadbandValue;

        public DataChangeFilterBuilderImpl(DataChangeTrigger trigger, long deadbandType, double deadbandValue) {
            this.trigger = trigger;
            this.deadbandType = deadbandType;
            this.deadbandValue = deadbandValue;
        }

        @Override
        public DataChangeFilter build() {
            DataChangeFilter dataChangeFilter = new DataChangeFilter(this.trigger, this.deadbandType, this.deadbandValue);
            return dataChangeFilter;
        }
    }
}

