/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.EnumDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.SimpleTypeDescription;
import org.apache.plc4x.java.opcua.readwrite.StructureDescription;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DataTypeSchemaHeader
extends ExtensionObjectDefinition
implements Message {
    protected final List<PascalString> namespaces;
    protected final List<StructureDescription> structureDataTypes;
    protected final List<EnumDescription> enumDataTypes;
    protected final List<SimpleTypeDescription> simpleDataTypes;

    @Override
    public Integer getExtensionId() {
        return 15536;
    }

    public DataTypeSchemaHeader(List<PascalString> namespaces, List<StructureDescription> structureDataTypes, List<EnumDescription> enumDataTypes, List<SimpleTypeDescription> simpleDataTypes) {
        this.namespaces = namespaces;
        this.structureDataTypes = structureDataTypes;
        this.enumDataTypes = enumDataTypes;
        this.simpleDataTypes = simpleDataTypes;
    }

    public List<PascalString> getNamespaces() {
        return this.namespaces;
    }

    public List<StructureDescription> getStructureDataTypes() {
        return this.structureDataTypes;
    }

    public List<EnumDescription> getEnumDataTypes() {
        return this.enumDataTypes;
    }

    public List<SimpleTypeDescription> getSimpleDataTypes() {
        return this.simpleDataTypes;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DataTypeSchemaHeader", new WithWriterArgs[0]);
        int noOfNamespaces = this.getNamespaces() == null ? -1 : StaticHelper.COUNT(this.getNamespaces());
        FieldWriterFactory.writeImplicitField((String)"noOfNamespaces", (Object)noOfNamespaces, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"namespaces", this.namespaces, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfStructureDataTypes = this.getStructureDataTypes() == null ? -1 : StaticHelper.COUNT(this.getStructureDataTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfStructureDataTypes", (Object)noOfStructureDataTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"structureDataTypes", this.structureDataTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfEnumDataTypes = this.getEnumDataTypes() == null ? -1 : StaticHelper.COUNT(this.getEnumDataTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfEnumDataTypes", (Object)noOfEnumDataTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"enumDataTypes", this.enumDataTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSimpleDataTypes = this.getSimpleDataTypes() == null ? -1 : StaticHelper.COUNT(this.getSimpleDataTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfSimpleDataTypes", (Object)noOfSimpleDataTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"simpleDataTypes", this.simpleDataTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DataTypeSchemaHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        DataTypeSchemaHeader _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.namespaces != null) {
            i = 0;
            for (PascalString pascalString : this.namespaces) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.namespaces.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.structureDataTypes != null) {
            i = 0;
            for (StructureDescription structureDescription : this.structureDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.structureDataTypes.size());
                lengthInBits += structureDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.enumDataTypes != null) {
            i = 0;
            for (EnumDescription enumDescription : this.enumDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.enumDataTypes.size());
                lengthInBits += enumDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.simpleDataTypes != null) {
            i = 0;
            for (SimpleTypeDescription simpleTypeDescription : this.simpleDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.simpleDataTypes.size());
                lengthInBits += simpleTypeDescription.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DataTypeSchemaHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfNamespaces = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNamespaces", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List namespaces = FieldReaderFactory.readCountArrayField((String)"namespaces", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfNamespaces, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfStructureDataTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfStructureDataTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List structureDataTypes = FieldReaderFactory.readCountArrayField((String)"structureDataTypes", (DataReader)DataReaderFactory.readComplex(() -> (StructureDescription)ExtensionObjectDefinition.staticParse(readBuffer, 15489), (ReadBuffer)readBuffer), (long)noOfStructureDataTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfEnumDataTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEnumDataTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List enumDataTypes = FieldReaderFactory.readCountArrayField((String)"enumDataTypes", (DataReader)DataReaderFactory.readComplex(() -> (EnumDescription)ExtensionObjectDefinition.staticParse(readBuffer, 15490), (ReadBuffer)readBuffer), (long)noOfEnumDataTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSimpleDataTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSimpleDataTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List simpleDataTypes = FieldReaderFactory.readCountArrayField((String)"simpleDataTypes", (DataReader)DataReaderFactory.readComplex(() -> (SimpleTypeDescription)ExtensionObjectDefinition.staticParse(readBuffer, 15007), (ReadBuffer)readBuffer), (long)noOfSimpleDataTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DataTypeSchemaHeader", new WithReaderArgs[0]);
        return new DataTypeSchemaHeaderBuilderImpl(namespaces, structureDataTypes, enumDataTypes, simpleDataTypes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataTypeSchemaHeader)) {
            return false;
        }
        DataTypeSchemaHeader that = (DataTypeSchemaHeader)o;
        return this.getNamespaces() == that.getNamespaces() && this.getStructureDataTypes() == that.getStructureDataTypes() && this.getEnumDataTypes() == that.getEnumDataTypes() && this.getSimpleDataTypes() == that.getSimpleDataTypes() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DataTypeSchemaHeaderBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<PascalString> namespaces;
        private final List<StructureDescription> structureDataTypes;
        private final List<EnumDescription> enumDataTypes;
        private final List<SimpleTypeDescription> simpleDataTypes;

        public DataTypeSchemaHeaderBuilderImpl(List<PascalString> namespaces, List<StructureDescription> structureDataTypes, List<EnumDescription> enumDataTypes, List<SimpleTypeDescription> simpleDataTypes) {
            this.namespaces = namespaces;
            this.structureDataTypes = structureDataTypes;
            this.enumDataTypes = enumDataTypes;
            this.simpleDataTypes = simpleDataTypes;
        }

        @Override
        public DataTypeSchemaHeader build() {
            DataTypeSchemaHeader dataTypeSchemaHeader = new DataTypeSchemaHeader(this.namespaces, this.structureDataTypes, this.enumDataTypes, this.simpleDataTypes);
            return dataTypeSchemaHeader;
        }
    }
}

