/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DatagramConnectionTransport2DataType
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObject discoveryAddress;
    protected final long discoveryAnnounceRate;
    protected final long discoveryMaxMessageSize;
    protected final PascalString qosCategory;
    protected final List<ExtensionObject> datagramQos;

    @Override
    public Integer getExtensionId() {
        return 23614;
    }

    public DatagramConnectionTransport2DataType(ExtensionObject discoveryAddress, long discoveryAnnounceRate, long discoveryMaxMessageSize, PascalString qosCategory, List<ExtensionObject> datagramQos) {
        this.discoveryAddress = discoveryAddress;
        this.discoveryAnnounceRate = discoveryAnnounceRate;
        this.discoveryMaxMessageSize = discoveryMaxMessageSize;
        this.qosCategory = qosCategory;
        this.datagramQos = datagramQos;
    }

    public ExtensionObject getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    public long getDiscoveryAnnounceRate() {
        return this.discoveryAnnounceRate;
    }

    public long getDiscoveryMaxMessageSize() {
        return this.discoveryMaxMessageSize;
    }

    public PascalString getQosCategory() {
        return this.qosCategory;
    }

    public List<ExtensionObject> getDatagramQos() {
        return this.datagramQos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DatagramConnectionTransport2DataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"discoveryAddress", (Object)this.discoveryAddress, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"discoveryAnnounceRate", (Object)this.discoveryAnnounceRate, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"discoveryMaxMessageSize", (Object)this.discoveryMaxMessageSize, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"qosCategory", (Object)this.qosCategory, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDatagramQos = this.getDatagramQos() == null ? -1 : StaticHelper.COUNT(this.getDatagramQos());
        FieldWriterFactory.writeImplicitField((String)"noOfDatagramQos", (Object)noOfDatagramQos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"datagramQos", this.datagramQos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DatagramConnectionTransport2DataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DatagramConnectionTransport2DataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.discoveryAddress.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.qosCategory.getLengthInBits();
        lengthInBits += 32;
        if (this.datagramQos != null) {
            int i = 0;
            for (ExtensionObject element : this.datagramQos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.datagramQos.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DatagramConnectionTransport2DataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObject discoveryAddress = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"discoveryAddress", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long discoveryAnnounceRate = (Long)FieldReaderFactory.readSimpleField((String)"discoveryAnnounceRate", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long discoveryMaxMessageSize = (Long)FieldReaderFactory.readSimpleField((String)"discoveryMaxMessageSize", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString qosCategory = (PascalString)FieldReaderFactory.readSimpleField((String)"qosCategory", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDatagramQos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDatagramQos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List datagramQos = FieldReaderFactory.readCountArrayField((String)"datagramQos", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (long)noOfDatagramQos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DatagramConnectionTransport2DataType", new WithReaderArgs[0]);
        return new DatagramConnectionTransport2DataTypeBuilderImpl(discoveryAddress, discoveryAnnounceRate, discoveryMaxMessageSize, qosCategory, datagramQos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatagramConnectionTransport2DataType)) {
            return false;
        }
        DatagramConnectionTransport2DataType that = (DatagramConnectionTransport2DataType)o;
        return this.getDiscoveryAddress() == that.getDiscoveryAddress() && this.getDiscoveryAnnounceRate() == that.getDiscoveryAnnounceRate() && this.getDiscoveryMaxMessageSize() == that.getDiscoveryMaxMessageSize() && this.getQosCategory() == that.getQosCategory() && this.getDatagramQos() == that.getDatagramQos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDiscoveryAddress(), this.getDiscoveryAnnounceRate(), this.getDiscoveryMaxMessageSize(), this.getQosCategory(), this.getDatagramQos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DatagramConnectionTransport2DataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObject discoveryAddress;
        private final long discoveryAnnounceRate;
        private final long discoveryMaxMessageSize;
        private final PascalString qosCategory;
        private final List<ExtensionObject> datagramQos;

        public DatagramConnectionTransport2DataTypeBuilderImpl(ExtensionObject discoveryAddress, long discoveryAnnounceRate, long discoveryMaxMessageSize, PascalString qosCategory, List<ExtensionObject> datagramQos) {
            this.discoveryAddress = discoveryAddress;
            this.discoveryAnnounceRate = discoveryAnnounceRate;
            this.discoveryMaxMessageSize = discoveryMaxMessageSize;
            this.qosCategory = qosCategory;
            this.datagramQos = datagramQos;
        }

        @Override
        public DatagramConnectionTransport2DataType build() {
            DatagramConnectionTransport2DataType datagramConnectionTransport2DataType = new DatagramConnectionTransport2DataType(this.discoveryAddress, this.discoveryAnnounceRate, this.discoveryMaxMessageSize, this.qosCategory, this.datagramQos);
            return datagramConnectionTransport2DataType;
        }
    }
}

