/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DeleteMonitoredItemsRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final long subscriptionId;
    protected final List<Long> monitoredItemIds;

    @Override
    public Integer getExtensionId() {
        return 781;
    }

    public DeleteMonitoredItemsRequest(RequestHeader requestHeader, long subscriptionId, List<Long> monitoredItemIds) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.monitoredItemIds = monitoredItemIds;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public List<Long> getMonitoredItemIds() {
        return this.monitoredItemIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DeleteMonitoredItemsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"subscriptionId", (Object)this.subscriptionId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfMonitoredItemIds = this.getMonitoredItemIds() == null ? -1 : StaticHelper.COUNT(this.getMonitoredItemIds());
        FieldWriterFactory.writeImplicitField((String)"noOfMonitoredItemIds", (Object)noOfMonitoredItemIds, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"monitoredItemIds", this.monitoredItemIds, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DeleteMonitoredItemsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DeleteMonitoredItemsRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.monitoredItemIds != null) {
            lengthInBits += 32 * this.monitoredItemIds.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DeleteMonitoredItemsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long subscriptionId = (Long)FieldReaderFactory.readSimpleField((String)"subscriptionId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfMonitoredItemIds = (Integer)FieldReaderFactory.readImplicitField((String)"noOfMonitoredItemIds", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List monitoredItemIds = FieldReaderFactory.readCountArrayField((String)"monitoredItemIds", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (long)noOfMonitoredItemIds, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DeleteMonitoredItemsRequest", new WithReaderArgs[0]);
        return new DeleteMonitoredItemsRequestBuilderImpl(requestHeader, subscriptionId, monitoredItemIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteMonitoredItemsRequest)) {
            return false;
        }
        DeleteMonitoredItemsRequest that = (DeleteMonitoredItemsRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getSubscriptionId() == that.getSubscriptionId() && this.getMonitoredItemIds() == that.getMonitoredItemIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getSubscriptionId(), this.getMonitoredItemIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DeleteMonitoredItemsRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final long subscriptionId;
        private final List<Long> monitoredItemIds;

        public DeleteMonitoredItemsRequestBuilderImpl(RequestHeader requestHeader, long subscriptionId, List<Long> monitoredItemIds) {
            this.requestHeader = requestHeader;
            this.subscriptionId = subscriptionId;
            this.monitoredItemIds = monitoredItemIds;
        }

        @Override
        public DeleteMonitoredItemsRequest build() {
            DeleteMonitoredItemsRequest deleteMonitoredItemsRequest = new DeleteMonitoredItemsRequest(this.requestHeader, this.subscriptionId, this.monitoredItemIds);
            return deleteMonitoredItemsRequest;
        }
    }
}

