/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataSetFieldFlags;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.GuidValue;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class FieldMetaData
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final LocalizedText description;
    protected final DataSetFieldFlags fieldFlags;
    protected final short builtInType;
    protected final NodeId dataType;
    protected final int valueRank;
    protected final List<Long> arrayDimensions;
    protected final long maxStringLength;
    protected final GuidValue dataSetFieldId;
    protected final List<KeyValuePair> properties;

    @Override
    public Integer getExtensionId() {
        return 14526;
    }

    public FieldMetaData(PascalString name, LocalizedText description, DataSetFieldFlags fieldFlags, short builtInType, NodeId dataType, int valueRank, List<Long> arrayDimensions, long maxStringLength, GuidValue dataSetFieldId, List<KeyValuePair> properties) {
        this.name = name;
        this.description = description;
        this.fieldFlags = fieldFlags;
        this.builtInType = builtInType;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.maxStringLength = maxStringLength;
        this.dataSetFieldId = dataSetFieldId;
        this.properties = properties;
    }

    public PascalString getName() {
        return this.name;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public DataSetFieldFlags getFieldFlags() {
        return this.fieldFlags;
    }

    public short getBuiltInType() {
        return this.builtInType;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public int getValueRank() {
        return this.valueRank;
    }

    public List<Long> getArrayDimensions() {
        return this.arrayDimensions;
    }

    public long getMaxStringLength() {
        return this.maxStringLength;
    }

    public GuidValue getDataSetFieldId() {
        return this.dataSetFieldId;
    }

    public List<KeyValuePair> getProperties() {
        return this.properties;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("FieldMetaData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"description", (Object)this.description, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"fieldFlags", (String)"DataSetFieldFlags", (Object)((Object)this.fieldFlags), (DataWriter)DataWriterFactory.writeEnum(DataSetFieldFlags::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"builtInType", (Object)this.builtInType, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataType", (Object)this.dataType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"valueRank", (Object)this.valueRank, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfArrayDimensions = this.getArrayDimensions() == null ? -1 : StaticHelper.COUNT(this.getArrayDimensions());
        FieldWriterFactory.writeImplicitField((String)"noOfArrayDimensions", (Object)noOfArrayDimensions, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"arrayDimensions", this.arrayDimensions, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxStringLength", (Object)this.maxStringLength, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetFieldId", (Object)this.dataSetFieldId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfProperties = this.getProperties() == null ? -1 : StaticHelper.COUNT(this.getProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfProperties", (Object)noOfProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"properties", this.properties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("FieldMetaData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        FieldMetaData _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += this.description.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += this.dataType.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.arrayDimensions != null) {
            lengthInBits += 32 * this.arrayDimensions.size();
        }
        lengthInBits += 32;
        lengthInBits += this.dataSetFieldId.getLengthInBits();
        lengthInBits += 32;
        if (this.properties != null) {
            int i = 0;
            for (KeyValuePair element : this.properties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.properties.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("FieldMetaData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText description = (LocalizedText)FieldReaderFactory.readSimpleField((String)"description", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        DataSetFieldFlags fieldFlags = (DataSetFieldFlags)((Object)FieldReaderFactory.readEnumField((String)"fieldFlags", (String)"DataSetFieldFlags", (DataReader)DataReaderFactory.readEnum(DataSetFieldFlags::enumForValue, (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16)), (WithReaderArgs[])new WithReaderArgs[0]));
        short builtInType = (Short)FieldReaderFactory.readSimpleField((String)"builtInType", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId dataType = (NodeId)FieldReaderFactory.readSimpleField((String)"dataType", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int valueRank = (Integer)FieldReaderFactory.readSimpleField((String)"valueRank", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfArrayDimensions = (Integer)FieldReaderFactory.readImplicitField((String)"noOfArrayDimensions", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List arrayDimensions = FieldReaderFactory.readCountArrayField((String)"arrayDimensions", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (long)noOfArrayDimensions, (WithReaderArgs[])new WithReaderArgs[0]);
        long maxStringLength = (Long)FieldReaderFactory.readSimpleField((String)"maxStringLength", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        GuidValue dataSetFieldId = (GuidValue)FieldReaderFactory.readSimpleField((String)"dataSetFieldId", (DataReader)DataReaderFactory.readComplex(() -> GuidValue.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List properties = FieldReaderFactory.readCountArrayField((String)"properties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("FieldMetaData", new WithReaderArgs[0]);
        return new FieldMetaDataBuilderImpl(name, description, fieldFlags, builtInType, dataType, valueRank, arrayDimensions, maxStringLength, dataSetFieldId, properties);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldMetaData)) {
            return false;
        }
        FieldMetaData that = (FieldMetaData)o;
        return this.getName() == that.getName() && this.getDescription() == that.getDescription() && this.getFieldFlags() == that.getFieldFlags() && this.getBuiltInType() == that.getBuiltInType() && this.getDataType() == that.getDataType() && this.getValueRank() == that.getValueRank() && this.getArrayDimensions() == that.getArrayDimensions() && this.getMaxStringLength() == that.getMaxStringLength() && this.getDataSetFieldId() == that.getDataSetFieldId() && this.getProperties() == that.getProperties() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getName(), this.getDescription(), this.getFieldFlags(), this.getBuiltInType(), this.getDataType(), this.getValueRank(), this.getArrayDimensions(), this.getMaxStringLength(), this.getDataSetFieldId(), this.getProperties()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class FieldMetaDataBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final LocalizedText description;
        private final DataSetFieldFlags fieldFlags;
        private final short builtInType;
        private final NodeId dataType;
        private final int valueRank;
        private final List<Long> arrayDimensions;
        private final long maxStringLength;
        private final GuidValue dataSetFieldId;
        private final List<KeyValuePair> properties;

        public FieldMetaDataBuilderImpl(PascalString name, LocalizedText description, DataSetFieldFlags fieldFlags, short builtInType, NodeId dataType, int valueRank, List<Long> arrayDimensions, long maxStringLength, GuidValue dataSetFieldId, List<KeyValuePair> properties) {
            this.name = name;
            this.description = description;
            this.fieldFlags = fieldFlags;
            this.builtInType = builtInType;
            this.dataType = dataType;
            this.valueRank = valueRank;
            this.arrayDimensions = arrayDimensions;
            this.maxStringLength = maxStringLength;
            this.dataSetFieldId = dataSetFieldId;
            this.properties = properties;
        }

        @Override
        public FieldMetaData build() {
            FieldMetaData fieldMetaData = new FieldMetaData(this.name, this.description, this.fieldFlags, this.builtInType, this.dataType, this.valueRank, this.arrayDimensions, this.maxStringLength, this.dataSetFieldId, this.properties);
            return fieldMetaData;
        }
    }
}

