/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ModificationInfo;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryModifiedData
extends ExtensionObjectDefinition
implements Message {
    protected final List<DataValue> dataValues;
    protected final List<ModificationInfo> modificationInfos;

    @Override
    public Integer getExtensionId() {
        return 11219;
    }

    public HistoryModifiedData(List<DataValue> dataValues, List<ModificationInfo> modificationInfos) {
        this.dataValues = dataValues;
        this.modificationInfos = modificationInfos;
    }

    public List<DataValue> getDataValues() {
        return this.dataValues;
    }

    public List<ModificationInfo> getModificationInfos() {
        return this.modificationInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryModifiedData", new WithWriterArgs[0]);
        int noOfDataValues = this.getDataValues() == null ? -1 : StaticHelper.COUNT(this.getDataValues());
        FieldWriterFactory.writeImplicitField((String)"noOfDataValues", (Object)noOfDataValues, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataValues", this.dataValues, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfModificationInfos = this.getModificationInfos() == null ? -1 : StaticHelper.COUNT(this.getModificationInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfModificationInfos", (Object)noOfModificationInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"modificationInfos", this.modificationInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryModifiedData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        HistoryModifiedData _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.dataValues != null) {
            i = 0;
            for (DataValue dataValue : this.dataValues) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataValues.size());
                lengthInBits += dataValue.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.modificationInfos != null) {
            i = 0;
            for (ModificationInfo modificationInfo : this.modificationInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.modificationInfos.size());
                lengthInBits += modificationInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("HistoryModifiedData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfDataValues = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataValues", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataValues = FieldReaderFactory.readCountArrayField((String)"dataValues", (DataReader)DataReaderFactory.readComplex(() -> DataValue.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDataValues, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfModificationInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfModificationInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List modificationInfos = FieldReaderFactory.readCountArrayField((String)"modificationInfos", (DataReader)DataReaderFactory.readComplex(() -> (ModificationInfo)ExtensionObjectDefinition.staticParse(readBuffer, 11218), (ReadBuffer)readBuffer), (long)noOfModificationInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryModifiedData", new WithReaderArgs[0]);
        return new HistoryModifiedDataBuilderImpl(dataValues, modificationInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryModifiedData)) {
            return false;
        }
        HistoryModifiedData that = (HistoryModifiedData)o;
        return this.getDataValues() == that.getDataValues() && this.getModificationInfos() == that.getModificationInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDataValues(), this.getModificationInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryModifiedDataBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<DataValue> dataValues;
        private final List<ModificationInfo> modificationInfos;

        public HistoryModifiedDataBuilderImpl(List<DataValue> dataValues, List<ModificationInfo> modificationInfos) {
            this.dataValues = dataValues;
            this.modificationInfos = modificationInfos;
        }

        @Override
        public HistoryModifiedData build() {
            HistoryModifiedData historyModifiedData = new HistoryModifiedData(this.dataValues, this.modificationInfos);
            return historyModifiedData;
        }
    }
}

