/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class JsonNetworkMessage
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString messageId;
    protected final PascalString messageType;
    protected final PascalString publisherId;
    protected final PascalString writerGroupName;
    protected final PascalString dataSetClassId;
    protected final List<ExtensionObject> messages;

    @Override
    public Integer getExtensionId() {
        return 19313;
    }

    public JsonNetworkMessage(PascalString messageId, PascalString messageType, PascalString publisherId, PascalString writerGroupName, PascalString dataSetClassId, List<ExtensionObject> messages) {
        this.messageId = messageId;
        this.messageType = messageType;
        this.publisherId = publisherId;
        this.writerGroupName = writerGroupName;
        this.dataSetClassId = dataSetClassId;
        this.messages = messages;
    }

    public PascalString getMessageId() {
        return this.messageId;
    }

    public PascalString getMessageType() {
        return this.messageType;
    }

    public PascalString getPublisherId() {
        return this.publisherId;
    }

    public PascalString getWriterGroupName() {
        return this.writerGroupName;
    }

    public PascalString getDataSetClassId() {
        return this.dataSetClassId;
    }

    public List<ExtensionObject> getMessages() {
        return this.messages;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("JsonNetworkMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageId", (Object)this.messageId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageType", (Object)this.messageType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publisherId", (Object)this.publisherId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"writerGroupName", (Object)this.writerGroupName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetClassId", (Object)this.dataSetClassId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfMessages = this.getMessages() == null ? -1 : StaticHelper.COUNT(this.getMessages());
        FieldWriterFactory.writeImplicitField((String)"noOfMessages", (Object)noOfMessages, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"messages", this.messages, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("JsonNetworkMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        JsonNetworkMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.messageId.getLengthInBits();
        lengthInBits += this.messageType.getLengthInBits();
        lengthInBits += this.publisherId.getLengthInBits();
        lengthInBits += this.writerGroupName.getLengthInBits();
        lengthInBits += this.dataSetClassId.getLengthInBits();
        lengthInBits += 32;
        if (this.messages != null) {
            int i = 0;
            for (ExtensionObject element : this.messages) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.messages.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("JsonNetworkMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString messageId = (PascalString)FieldReaderFactory.readSimpleField((String)"messageId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString messageType = (PascalString)FieldReaderFactory.readSimpleField((String)"messageType", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString publisherId = (PascalString)FieldReaderFactory.readSimpleField((String)"publisherId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString writerGroupName = (PascalString)FieldReaderFactory.readSimpleField((String)"writerGroupName", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString dataSetClassId = (PascalString)FieldReaderFactory.readSimpleField((String)"dataSetClassId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfMessages = (Integer)FieldReaderFactory.readImplicitField((String)"noOfMessages", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List messages = FieldReaderFactory.readCountArrayField((String)"messages", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (long)noOfMessages, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("JsonNetworkMessage", new WithReaderArgs[0]);
        return new JsonNetworkMessageBuilderImpl(messageId, messageType, publisherId, writerGroupName, dataSetClassId, messages);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonNetworkMessage)) {
            return false;
        }
        JsonNetworkMessage that = (JsonNetworkMessage)o;
        return this.getMessageId() == that.getMessageId() && this.getMessageType() == that.getMessageType() && this.getPublisherId() == that.getPublisherId() && this.getWriterGroupName() == that.getWriterGroupName() && this.getDataSetClassId() == that.getDataSetClassId() && this.getMessages() == that.getMessages() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMessageId(), this.getMessageType(), this.getPublisherId(), this.getWriterGroupName(), this.getDataSetClassId(), this.getMessages());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class JsonNetworkMessageBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString messageId;
        private final PascalString messageType;
        private final PascalString publisherId;
        private final PascalString writerGroupName;
        private final PascalString dataSetClassId;
        private final List<ExtensionObject> messages;

        public JsonNetworkMessageBuilderImpl(PascalString messageId, PascalString messageType, PascalString publisherId, PascalString writerGroupName, PascalString dataSetClassId, List<ExtensionObject> messages) {
            this.messageId = messageId;
            this.messageType = messageType;
            this.publisherId = publisherId;
            this.writerGroupName = writerGroupName;
            this.dataSetClassId = dataSetClassId;
            this.messages = messages;
        }

        @Override
        public JsonNetworkMessage build() {
            JsonNetworkMessage jsonNetworkMessage = new JsonNetworkMessage(this.messageId, this.messageType, this.publisherId, this.writerGroupName, this.dataSetClassId, this.messages);
            return jsonNetworkMessage;
        }
    }
}

