/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class MdnsDiscoveryConfiguration
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString mdnsServerName;
    protected final List<PascalString> serverCapabilities;

    @Override
    public Integer getExtensionId() {
        return 12893;
    }

    public MdnsDiscoveryConfiguration(PascalString mdnsServerName, List<PascalString> serverCapabilities) {
        this.mdnsServerName = mdnsServerName;
        this.serverCapabilities = serverCapabilities;
    }

    public PascalString getMdnsServerName() {
        return this.mdnsServerName;
    }

    public List<PascalString> getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("MdnsDiscoveryConfiguration", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"mdnsServerName", (Object)this.mdnsServerName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfServerCapabilities = this.getServerCapabilities() == null ? -1 : StaticHelper.COUNT(this.getServerCapabilities());
        FieldWriterFactory.writeImplicitField((String)"noOfServerCapabilities", (Object)noOfServerCapabilities, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"serverCapabilities", this.serverCapabilities, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("MdnsDiscoveryConfiguration", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        MdnsDiscoveryConfiguration _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.mdnsServerName.getLengthInBits();
        lengthInBits += 32;
        if (this.serverCapabilities != null) {
            int i = 0;
            for (PascalString element : this.serverCapabilities) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.serverCapabilities.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("MdnsDiscoveryConfiguration", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString mdnsServerName = (PascalString)FieldReaderFactory.readSimpleField((String)"mdnsServerName", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfServerCapabilities = (Integer)FieldReaderFactory.readImplicitField((String)"noOfServerCapabilities", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List serverCapabilities = FieldReaderFactory.readCountArrayField((String)"serverCapabilities", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfServerCapabilities, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("MdnsDiscoveryConfiguration", new WithReaderArgs[0]);
        return new MdnsDiscoveryConfigurationBuilderImpl(mdnsServerName, serverCapabilities);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MdnsDiscoveryConfiguration)) {
            return false;
        }
        MdnsDiscoveryConfiguration that = (MdnsDiscoveryConfiguration)o;
        return this.getMdnsServerName() == that.getMdnsServerName() && this.getServerCapabilities() == that.getServerCapabilities() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMdnsServerName(), this.getServerCapabilities());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class MdnsDiscoveryConfigurationBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString mdnsServerName;
        private final List<PascalString> serverCapabilities;

        public MdnsDiscoveryConfigurationBuilderImpl(PascalString mdnsServerName, List<PascalString> serverCapabilities) {
            this.mdnsServerName = mdnsServerName;
            this.serverCapabilities = serverCapabilities;
        }

        @Override
        public MdnsDiscoveryConfiguration build() {
            MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration = new MdnsDiscoveryConfiguration(this.mdnsServerName, this.serverCapabilities);
            return mdnsDiscoveryConfiguration;
        }
    }
}

