/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NotificationMessage
extends ExtensionObjectDefinition
implements Message {
    protected final long sequenceNumber;
    protected final long publishTime;
    protected final List<ExtensionObject> notificationData;

    @Override
    public Integer getExtensionId() {
        return 805;
    }

    public NotificationMessage(long sequenceNumber, long publishTime, List<ExtensionObject> notificationData) {
        this.sequenceNumber = sequenceNumber;
        this.publishTime = publishTime;
        this.notificationData = notificationData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getPublishTime() {
        return this.publishTime;
    }

    public List<ExtensionObject> getNotificationData() {
        return this.notificationData;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NotificationMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publishTime", (Object)this.publishTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfNotificationData = this.getNotificationData() == null ? -1 : StaticHelper.COUNT(this.getNotificationData());
        FieldWriterFactory.writeImplicitField((String)"noOfNotificationData", (Object)noOfNotificationData, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"notificationData", this.notificationData, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NotificationMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NotificationMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.notificationData != null) {
            int i = 0;
            for (ExtensionObject element : this.notificationData) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.notificationData.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("NotificationMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long sequenceNumber = (Long)FieldReaderFactory.readSimpleField((String)"sequenceNumber", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long publishTime = (Long)FieldReaderFactory.readSimpleField((String)"publishTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNotificationData = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNotificationData", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List notificationData = FieldReaderFactory.readCountArrayField((String)"notificationData", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (long)noOfNotificationData, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NotificationMessage", new WithReaderArgs[0]);
        return new NotificationMessageBuilderImpl(sequenceNumber, publishTime, notificationData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationMessage)) {
            return false;
        }
        NotificationMessage that = (NotificationMessage)o;
        return this.getSequenceNumber() == that.getSequenceNumber() && this.getPublishTime() == that.getPublishTime() && this.getNotificationData() == that.getNotificationData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSequenceNumber(), this.getPublishTime(), this.getNotificationData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NotificationMessageBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long sequenceNumber;
        private final long publishTime;
        private final List<ExtensionObject> notificationData;

        public NotificationMessageBuilderImpl(long sequenceNumber, long publishTime, List<ExtensionObject> notificationData) {
            this.sequenceNumber = sequenceNumber;
            this.publishTime = publishTime;
            this.notificationData = notificationData;
        }

        @Override
        public NotificationMessage build() {
            NotificationMessage notificationMessage = new NotificationMessage(this.sequenceNumber, this.publishTime, this.notificationData);
            return notificationMessage;
        }
    }
}

