/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaProtocolLimits
implements Message {
    protected final long receiveBufferSize;
    protected final long sendBufferSize;
    protected final long maxMessageSize;
    protected final long maxChunkCount;

    public OpcuaProtocolLimits(long receiveBufferSize, long sendBufferSize, long maxMessageSize, long maxChunkCount) {
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.maxMessageSize = maxMessageSize;
        this.maxChunkCount = maxChunkCount;
    }

    public long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public long getSendBufferSize() {
        return this.sendBufferSize;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public long getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaProtocolLimits", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"receiveBufferSize", (Object)this.receiveBufferSize, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sendBufferSize", (Object)this.sendBufferSize, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxMessageSize", (Object)this.maxMessageSize, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxChunkCount", (Object)this.maxChunkCount, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaProtocolLimits", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        OpcuaProtocolLimits _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static OpcuaProtocolLimits staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("OpcuaProtocolLimits", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long receiveBufferSize = (Long)FieldReaderFactory.readSimpleField((String)"receiveBufferSize", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long sendBufferSize = (Long)FieldReaderFactory.readSimpleField((String)"sendBufferSize", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long maxMessageSize = (Long)FieldReaderFactory.readSimpleField((String)"maxMessageSize", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long maxChunkCount = (Long)FieldReaderFactory.readSimpleField((String)"maxChunkCount", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaProtocolLimits", new WithReaderArgs[0]);
        OpcuaProtocolLimits _opcuaProtocolLimits = new OpcuaProtocolLimits(receiveBufferSize, sendBufferSize, maxMessageSize, maxChunkCount);
        return _opcuaProtocolLimits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaProtocolLimits)) {
            return false;
        }
        OpcuaProtocolLimits that = (OpcuaProtocolLimits)o;
        return this.getReceiveBufferSize() == that.getReceiveBufferSize() && this.getSendBufferSize() == that.getSendBufferSize() && this.getMaxMessageSize() == that.getMaxMessageSize() && this.getMaxChunkCount() == that.getMaxChunkCount();
    }

    public int hashCode() {
        return Objects.hash(this.getReceiveBufferSize(), this.getSendBufferSize(), this.getMaxMessageSize(), this.getMaxChunkCount());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

