/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ParsingResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final List<StatusCode> dataStatusCodes;
    protected final List<DiagnosticInfo> dataDiagnosticInfos;

    @Override
    public Integer getExtensionId() {
        return 612;
    }

    public ParsingResult(StatusCode statusCode, List<StatusCode> dataStatusCodes, List<DiagnosticInfo> dataDiagnosticInfos) {
        this.statusCode = statusCode;
        this.dataStatusCodes = dataStatusCodes;
        this.dataDiagnosticInfos = dataDiagnosticInfos;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public List<StatusCode> getDataStatusCodes() {
        return this.dataStatusCodes;
    }

    public List<DiagnosticInfo> getDataDiagnosticInfos() {
        return this.dataDiagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ParsingResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDataStatusCodes = this.getDataStatusCodes() == null ? -1 : StaticHelper.COUNT(this.getDataStatusCodes());
        FieldWriterFactory.writeImplicitField((String)"noOfDataStatusCodes", (Object)noOfDataStatusCodes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataStatusCodes", this.dataStatusCodes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDataDiagnosticInfos = this.getDataDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getDataDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfDataDiagnosticInfos", (Object)noOfDataDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataDiagnosticInfos", this.dataDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ParsingResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ParsingResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.dataStatusCodes != null) {
            i = 0;
            for (StatusCode statusCode : this.dataStatusCodes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataStatusCodes.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.dataDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.dataDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ParsingResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataStatusCodes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataStatusCodes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataStatusCodes = FieldReaderFactory.readCountArrayField((String)"dataStatusCodes", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDataStatusCodes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"dataDiagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDataDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ParsingResult", new WithReaderArgs[0]);
        return new ParsingResultBuilderImpl(statusCode, dataStatusCodes, dataDiagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParsingResult)) {
            return false;
        }
        ParsingResult that = (ParsingResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getDataStatusCodes() == that.getDataStatusCodes() && this.getDataDiagnosticInfos() == that.getDataDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getDataStatusCodes(), this.getDataDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ParsingResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final List<StatusCode> dataStatusCodes;
        private final List<DiagnosticInfo> dataDiagnosticInfos;

        public ParsingResultBuilderImpl(StatusCode statusCode, List<StatusCode> dataStatusCodes, List<DiagnosticInfo> dataDiagnosticInfos) {
            this.statusCode = statusCode;
            this.dataStatusCodes = dataStatusCodes;
            this.dataDiagnosticInfos = dataDiagnosticInfos;
        }

        @Override
        public ParsingResult build() {
            ParsingResult parsingResult = new ParsingResult(this.statusCode, this.dataStatusCodes, this.dataDiagnosticInfos);
            return parsingResult;
        }
    }
}

