/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataSetMetaDataType;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.PubSubConnectionDataType;
import org.apache.plc4x.java.opcua.readwrite.PubSubKeyPushTargetDataType;
import org.apache.plc4x.java.opcua.readwrite.PublishedDataSetDataType;
import org.apache.plc4x.java.opcua.readwrite.SecurityGroupDataType;
import org.apache.plc4x.java.opcua.readwrite.StandaloneSubscribedDataSetDataType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PubSubConfiguration2DataType
extends ExtensionObjectDefinition
implements Message {
    protected final List<PublishedDataSetDataType> publishedDataSets;
    protected final List<PubSubConnectionDataType> connections;
    protected final boolean enabled;
    protected final List<StandaloneSubscribedDataSetDataType> subscribedDataSets;
    protected final List<DataSetMetaDataType> dataSetClasses;
    protected final List<EndpointDescription> defaultSecurityKeyServices;
    protected final List<SecurityGroupDataType> securityGroups;
    protected final List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets;
    protected final long configurationVersion;
    protected final List<KeyValuePair> configurationProperties;

    @Override
    public Integer getExtensionId() {
        return 23604;
    }

    public PubSubConfiguration2DataType(List<PublishedDataSetDataType> publishedDataSets, List<PubSubConnectionDataType> connections, boolean enabled, List<StandaloneSubscribedDataSetDataType> subscribedDataSets, List<DataSetMetaDataType> dataSetClasses, List<EndpointDescription> defaultSecurityKeyServices, List<SecurityGroupDataType> securityGroups, List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets, long configurationVersion, List<KeyValuePair> configurationProperties) {
        this.publishedDataSets = publishedDataSets;
        this.connections = connections;
        this.enabled = enabled;
        this.subscribedDataSets = subscribedDataSets;
        this.dataSetClasses = dataSetClasses;
        this.defaultSecurityKeyServices = defaultSecurityKeyServices;
        this.securityGroups = securityGroups;
        this.pubSubKeyPushTargets = pubSubKeyPushTargets;
        this.configurationVersion = configurationVersion;
        this.configurationProperties = configurationProperties;
    }

    public List<PublishedDataSetDataType> getPublishedDataSets() {
        return this.publishedDataSets;
    }

    public List<PubSubConnectionDataType> getConnections() {
        return this.connections;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public List<StandaloneSubscribedDataSetDataType> getSubscribedDataSets() {
        return this.subscribedDataSets;
    }

    public List<DataSetMetaDataType> getDataSetClasses() {
        return this.dataSetClasses;
    }

    public List<EndpointDescription> getDefaultSecurityKeyServices() {
        return this.defaultSecurityKeyServices;
    }

    public List<SecurityGroupDataType> getSecurityGroups() {
        return this.securityGroups;
    }

    public List<PubSubKeyPushTargetDataType> getPubSubKeyPushTargets() {
        return this.pubSubKeyPushTargets;
    }

    public long getConfigurationVersion() {
        return this.configurationVersion;
    }

    public List<KeyValuePair> getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PubSubConfiguration2DataType", new WithWriterArgs[0]);
        int noOfPublishedDataSets = this.getPublishedDataSets() == null ? -1 : StaticHelper.COUNT(this.getPublishedDataSets());
        FieldWriterFactory.writeImplicitField((String)"noOfPublishedDataSets", (Object)noOfPublishedDataSets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"publishedDataSets", this.publishedDataSets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfConnections = this.getConnections() == null ? -1 : StaticHelper.COUNT(this.getConnections());
        FieldWriterFactory.writeImplicitField((String)"noOfConnections", (Object)noOfConnections, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"connections", this.connections, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"enabled", (Object)this.enabled, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSubscribedDataSets = this.getSubscribedDataSets() == null ? -1 : StaticHelper.COUNT(this.getSubscribedDataSets());
        FieldWriterFactory.writeImplicitField((String)"noOfSubscribedDataSets", (Object)noOfSubscribedDataSets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"subscribedDataSets", this.subscribedDataSets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDataSetClasses = this.getDataSetClasses() == null ? -1 : StaticHelper.COUNT(this.getDataSetClasses());
        FieldWriterFactory.writeImplicitField((String)"noOfDataSetClasses", (Object)noOfDataSetClasses, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataSetClasses", this.dataSetClasses, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDefaultSecurityKeyServices = this.getDefaultSecurityKeyServices() == null ? -1 : StaticHelper.COUNT(this.getDefaultSecurityKeyServices());
        FieldWriterFactory.writeImplicitField((String)"noOfDefaultSecurityKeyServices", (Object)noOfDefaultSecurityKeyServices, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"defaultSecurityKeyServices", this.defaultSecurityKeyServices, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSecurityGroups = this.getSecurityGroups() == null ? -1 : StaticHelper.COUNT(this.getSecurityGroups());
        FieldWriterFactory.writeImplicitField((String)"noOfSecurityGroups", (Object)noOfSecurityGroups, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"securityGroups", this.securityGroups, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfPubSubKeyPushTargets = this.getPubSubKeyPushTargets() == null ? -1 : StaticHelper.COUNT(this.getPubSubKeyPushTargets());
        FieldWriterFactory.writeImplicitField((String)"noOfPubSubKeyPushTargets", (Object)noOfPubSubKeyPushTargets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"pubSubKeyPushTargets", this.pubSubKeyPushTargets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"configurationVersion", (Object)this.configurationVersion, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfConfigurationProperties = this.getConfigurationProperties() == null ? -1 : StaticHelper.COUNT(this.getConfigurationProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfConfigurationProperties", (Object)noOfConfigurationProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"configurationProperties", this.configurationProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PubSubConfiguration2DataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        PubSubConfiguration2DataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.publishedDataSets != null) {
            i = 0;
            for (PublishedDataSetDataType publishedDataSetDataType : this.publishedDataSets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.publishedDataSets.size());
                lengthInBits += publishedDataSetDataType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.connections != null) {
            i = 0;
            for (PubSubConnectionDataType pubSubConnectionDataType : this.connections) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.connections.size());
                lengthInBits += pubSubConnectionDataType.getLengthInBits();
            }
        }
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.subscribedDataSets != null) {
            i = 0;
            for (StandaloneSubscribedDataSetDataType standaloneSubscribedDataSetDataType : this.subscribedDataSets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.subscribedDataSets.size());
                lengthInBits += standaloneSubscribedDataSetDataType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.dataSetClasses != null) {
            i = 0;
            for (DataSetMetaDataType dataSetMetaDataType : this.dataSetClasses) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataSetClasses.size());
                lengthInBits += dataSetMetaDataType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.defaultSecurityKeyServices != null) {
            i = 0;
            for (EndpointDescription endpointDescription : this.defaultSecurityKeyServices) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.defaultSecurityKeyServices.size());
                lengthInBits += endpointDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.securityGroups != null) {
            i = 0;
            for (SecurityGroupDataType securityGroupDataType : this.securityGroups) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.securityGroups.size());
                lengthInBits += securityGroupDataType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.pubSubKeyPushTargets != null) {
            i = 0;
            for (PubSubKeyPushTargetDataType pubSubKeyPushTargetDataType : this.pubSubKeyPushTargets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.pubSubKeyPushTargets.size());
                lengthInBits += pubSubKeyPushTargetDataType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.configurationProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.configurationProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.configurationProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("PubSubConfiguration2DataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfPublishedDataSets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfPublishedDataSets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List publishedDataSets = FieldReaderFactory.readCountArrayField((String)"publishedDataSets", (DataReader)DataReaderFactory.readComplex(() -> (PublishedDataSetDataType)ExtensionObjectDefinition.staticParse(readBuffer, 15580), (ReadBuffer)readBuffer), (long)noOfPublishedDataSets, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfConnections = (Integer)FieldReaderFactory.readImplicitField((String)"noOfConnections", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List connections = FieldReaderFactory.readCountArrayField((String)"connections", (DataReader)DataReaderFactory.readComplex(() -> (PubSubConnectionDataType)ExtensionObjectDefinition.staticParse(readBuffer, 15619), (ReadBuffer)readBuffer), (long)noOfConnections, (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean enabled = (Boolean)FieldReaderFactory.readSimpleField((String)"enabled", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSubscribedDataSets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSubscribedDataSets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List subscribedDataSets = FieldReaderFactory.readCountArrayField((String)"subscribedDataSets", (DataReader)DataReaderFactory.readComplex(() -> (StandaloneSubscribedDataSetDataType)ExtensionObjectDefinition.staticParse(readBuffer, 23602), (ReadBuffer)readBuffer), (long)noOfSubscribedDataSets, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataSetClasses = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataSetClasses", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataSetClasses = FieldReaderFactory.readCountArrayField((String)"dataSetClasses", (DataReader)DataReaderFactory.readComplex(() -> (DataSetMetaDataType)ExtensionObjectDefinition.staticParse(readBuffer, 14525), (ReadBuffer)readBuffer), (long)noOfDataSetClasses, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDefaultSecurityKeyServices = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDefaultSecurityKeyServices", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List defaultSecurityKeyServices = FieldReaderFactory.readCountArrayField((String)"defaultSecurityKeyServices", (DataReader)DataReaderFactory.readComplex(() -> (EndpointDescription)ExtensionObjectDefinition.staticParse(readBuffer, 314), (ReadBuffer)readBuffer), (long)noOfDefaultSecurityKeyServices, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSecurityGroups = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSecurityGroups", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List securityGroups = FieldReaderFactory.readCountArrayField((String)"securityGroups", (DataReader)DataReaderFactory.readComplex(() -> (SecurityGroupDataType)ExtensionObjectDefinition.staticParse(readBuffer, 23603), (ReadBuffer)readBuffer), (long)noOfSecurityGroups, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfPubSubKeyPushTargets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfPubSubKeyPushTargets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List pubSubKeyPushTargets = FieldReaderFactory.readCountArrayField((String)"pubSubKeyPushTargets", (DataReader)DataReaderFactory.readComplex(() -> (PubSubKeyPushTargetDataType)ExtensionObjectDefinition.staticParse(readBuffer, 25272), (ReadBuffer)readBuffer), (long)noOfPubSubKeyPushTargets, (WithReaderArgs[])new WithReaderArgs[0]);
        long configurationVersion = (Long)FieldReaderFactory.readSimpleField((String)"configurationVersion", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfConfigurationProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfConfigurationProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List configurationProperties = FieldReaderFactory.readCountArrayField((String)"configurationProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfConfigurationProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PubSubConfiguration2DataType", new WithReaderArgs[0]);
        return new PubSubConfiguration2DataTypeBuilderImpl(publishedDataSets, connections, enabled, subscribedDataSets, dataSetClasses, defaultSecurityKeyServices, securityGroups, pubSubKeyPushTargets, configurationVersion, configurationProperties);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PubSubConfiguration2DataType)) {
            return false;
        }
        PubSubConfiguration2DataType that = (PubSubConfiguration2DataType)o;
        return this.getPublishedDataSets() == that.getPublishedDataSets() && this.getConnections() == that.getConnections() && this.getEnabled() == that.getEnabled() && this.getSubscribedDataSets() == that.getSubscribedDataSets() && this.getDataSetClasses() == that.getDataSetClasses() && this.getDefaultSecurityKeyServices() == that.getDefaultSecurityKeyServices() && this.getSecurityGroups() == that.getSecurityGroups() && this.getPubSubKeyPushTargets() == that.getPubSubKeyPushTargets() && this.getConfigurationVersion() == that.getConfigurationVersion() && this.getConfigurationProperties() == that.getConfigurationProperties() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPublishedDataSets(), this.getConnections(), this.getEnabled(), this.getSubscribedDataSets(), this.getDataSetClasses(), this.getDefaultSecurityKeyServices(), this.getSecurityGroups(), this.getPubSubKeyPushTargets(), this.getConfigurationVersion(), this.getConfigurationProperties());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PubSubConfiguration2DataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<PublishedDataSetDataType> publishedDataSets;
        private final List<PubSubConnectionDataType> connections;
        private final boolean enabled;
        private final List<StandaloneSubscribedDataSetDataType> subscribedDataSets;
        private final List<DataSetMetaDataType> dataSetClasses;
        private final List<EndpointDescription> defaultSecurityKeyServices;
        private final List<SecurityGroupDataType> securityGroups;
        private final List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets;
        private final long configurationVersion;
        private final List<KeyValuePair> configurationProperties;

        public PubSubConfiguration2DataTypeBuilderImpl(List<PublishedDataSetDataType> publishedDataSets, List<PubSubConnectionDataType> connections, boolean enabled, List<StandaloneSubscribedDataSetDataType> subscribedDataSets, List<DataSetMetaDataType> dataSetClasses, List<EndpointDescription> defaultSecurityKeyServices, List<SecurityGroupDataType> securityGroups, List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets, long configurationVersion, List<KeyValuePair> configurationProperties) {
            this.publishedDataSets = publishedDataSets;
            this.connections = connections;
            this.enabled = enabled;
            this.subscribedDataSets = subscribedDataSets;
            this.dataSetClasses = dataSetClasses;
            this.defaultSecurityKeyServices = defaultSecurityKeyServices;
            this.securityGroups = securityGroups;
            this.pubSubKeyPushTargets = pubSubKeyPushTargets;
            this.configurationVersion = configurationVersion;
            this.configurationProperties = configurationProperties;
        }

        @Override
        public PubSubConfiguration2DataType build() {
            PubSubConfiguration2DataType pubSubConfiguration2DataType = new PubSubConfiguration2DataType(this.publishedDataSets, this.connections, this.enabled, this.subscribedDataSets, this.dataSetClasses, this.defaultSecurityKeyServices, this.securityGroups, this.pubSubKeyPushTargets, this.configurationVersion, this.configurationProperties);
            return pubSubConfiguration2DataType;
        }
    }
}

