/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.SubscriptionAcknowledgement;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PublishRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final List<SubscriptionAcknowledgement> subscriptionAcknowledgements;

    @Override
    public Integer getExtensionId() {
        return 826;
    }

    public PublishRequest(RequestHeader requestHeader, List<SubscriptionAcknowledgement> subscriptionAcknowledgements) {
        this.requestHeader = requestHeader;
        this.subscriptionAcknowledgements = subscriptionAcknowledgements;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public List<SubscriptionAcknowledgement> getSubscriptionAcknowledgements() {
        return this.subscriptionAcknowledgements;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PublishRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSubscriptionAcknowledgements = this.getSubscriptionAcknowledgements() == null ? -1 : StaticHelper.COUNT(this.getSubscriptionAcknowledgements());
        FieldWriterFactory.writeImplicitField((String)"noOfSubscriptionAcknowledgements", (Object)noOfSubscriptionAcknowledgements, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"subscriptionAcknowledgements", this.subscriptionAcknowledgements, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PublishRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        PublishRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.subscriptionAcknowledgements != null) {
            int i = 0;
            for (SubscriptionAcknowledgement element : this.subscriptionAcknowledgements) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.subscriptionAcknowledgements.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("PublishRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSubscriptionAcknowledgements = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSubscriptionAcknowledgements", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List subscriptionAcknowledgements = FieldReaderFactory.readCountArrayField((String)"subscriptionAcknowledgements", (DataReader)DataReaderFactory.readComplex(() -> (SubscriptionAcknowledgement)ExtensionObjectDefinition.staticParse(readBuffer, 823), (ReadBuffer)readBuffer), (long)noOfSubscriptionAcknowledgements, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PublishRequest", new WithReaderArgs[0]);
        return new PublishRequestBuilderImpl(requestHeader, subscriptionAcknowledgements);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishRequest)) {
            return false;
        }
        PublishRequest that = (PublishRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getSubscriptionAcknowledgements() == that.getSubscriptionAcknowledgements() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getSubscriptionAcknowledgements());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PublishRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final List<SubscriptionAcknowledgement> subscriptionAcknowledgements;

        public PublishRequestBuilderImpl(RequestHeader requestHeader, List<SubscriptionAcknowledgement> subscriptionAcknowledgements) {
            this.requestHeader = requestHeader;
            this.subscriptionAcknowledgements = subscriptionAcknowledgements;
        }

        @Override
        public PublishRequest build() {
            PublishRequest publishRequest = new PublishRequest(this.requestHeader, this.subscriptionAcknowledgements);
            return publishRequest;
        }
    }
}

