/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.BrowsePathResult;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class TranslateBrowsePathsToNodeIdsResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ResponseHeader responseHeader;
    protected final List<BrowsePathResult> results;
    protected final List<DiagnosticInfo> diagnosticInfos;

    @Override
    public Integer getExtensionId() {
        return 557;
    }

    public TranslateBrowsePathsToNodeIdsResponse(ResponseHeader responseHeader, List<BrowsePathResult> results, List<DiagnosticInfo> diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public List<BrowsePathResult> getResults() {
        return this.results;
    }

    public List<DiagnosticInfo> getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TranslateBrowsePathsToNodeIdsResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseHeader", (Object)this.responseHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfResults = this.getResults() == null ? -1 : StaticHelper.COUNT(this.getResults());
        FieldWriterFactory.writeImplicitField((String)"noOfResults", (Object)noOfResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"results", this.results, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDiagnosticInfos = this.getDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfDiagnosticInfos", (Object)noOfDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"diagnosticInfos", this.diagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("TranslateBrowsePathsToNodeIdsResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        TranslateBrowsePathsToNodeIdsResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.results != null) {
            i = 0;
            for (BrowsePathResult browsePathResult : this.results) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.results.size());
                lengthInBits += browsePathResult.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.diagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.diagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.diagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("TranslateBrowsePathsToNodeIdsResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ResponseHeader responseHeader = (ResponseHeader)FieldReaderFactory.readSimpleField((String)"responseHeader", (DataReader)DataReaderFactory.readComplex(() -> (ResponseHeader)ExtensionObjectDefinition.staticParse(readBuffer, 394), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List results = FieldReaderFactory.readCountArrayField((String)"results", (DataReader)DataReaderFactory.readComplex(() -> (BrowsePathResult)ExtensionObjectDefinition.staticParse(readBuffer, 551), (ReadBuffer)readBuffer), (long)noOfResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List diagnosticInfos = FieldReaderFactory.readCountArrayField((String)"diagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("TranslateBrowsePathsToNodeIdsResponse", new WithReaderArgs[0]);
        return new TranslateBrowsePathsToNodeIdsResponseBuilderImpl(responseHeader, results, diagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslateBrowsePathsToNodeIdsResponse)) {
            return false;
        }
        TranslateBrowsePathsToNodeIdsResponse that = (TranslateBrowsePathsToNodeIdsResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getResults() == that.getResults() && this.getDiagnosticInfos() == that.getDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getResults(), this.getDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class TranslateBrowsePathsToNodeIdsResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ResponseHeader responseHeader;
        private final List<BrowsePathResult> results;
        private final List<DiagnosticInfo> diagnosticInfos;

        public TranslateBrowsePathsToNodeIdsResponseBuilderImpl(ResponseHeader responseHeader, List<BrowsePathResult> results, List<DiagnosticInfo> diagnosticInfos) {
            this.responseHeader = responseHeader;
            this.results = results;
            this.diagnosticInfos = diagnosticInfos;
        }

        @Override
        public TranslateBrowsePathsToNodeIdsResponse build() {
            TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse = new TranslateBrowsePathsToNodeIdsResponse(this.responseHeader, this.results, this.diagnosticInfos);
            return translateBrowsePathsToNodeIdsResponse;
        }
    }
}

