/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.EnumDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.SimpleTypeDescription;
import org.apache.plc4x.java.opcua.readwrite.StructureDescription;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class UABinaryFileDataType
extends ExtensionObjectDefinition
implements Message {
    protected final List<PascalString> namespaces;
    protected final List<StructureDescription> structureDataTypes;
    protected final List<EnumDescription> enumDataTypes;
    protected final List<SimpleTypeDescription> simpleDataTypes;
    protected final PascalString schemaLocation;
    protected final List<KeyValuePair> fileHeader;
    protected final Variant body;

    @Override
    public Integer getExtensionId() {
        return 15008;
    }

    public UABinaryFileDataType(List<PascalString> namespaces, List<StructureDescription> structureDataTypes, List<EnumDescription> enumDataTypes, List<SimpleTypeDescription> simpleDataTypes, PascalString schemaLocation, List<KeyValuePair> fileHeader, Variant body) {
        this.namespaces = namespaces;
        this.structureDataTypes = structureDataTypes;
        this.enumDataTypes = enumDataTypes;
        this.simpleDataTypes = simpleDataTypes;
        this.schemaLocation = schemaLocation;
        this.fileHeader = fileHeader;
        this.body = body;
    }

    public List<PascalString> getNamespaces() {
        return this.namespaces;
    }

    public List<StructureDescription> getStructureDataTypes() {
        return this.structureDataTypes;
    }

    public List<EnumDescription> getEnumDataTypes() {
        return this.enumDataTypes;
    }

    public List<SimpleTypeDescription> getSimpleDataTypes() {
        return this.simpleDataTypes;
    }

    public PascalString getSchemaLocation() {
        return this.schemaLocation;
    }

    public List<KeyValuePair> getFileHeader() {
        return this.fileHeader;
    }

    public Variant getBody() {
        return this.body;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("UABinaryFileDataType", new WithWriterArgs[0]);
        int noOfNamespaces = this.getNamespaces() == null ? -1 : StaticHelper.COUNT(this.getNamespaces());
        FieldWriterFactory.writeImplicitField((String)"noOfNamespaces", (Object)noOfNamespaces, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"namespaces", this.namespaces, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfStructureDataTypes = this.getStructureDataTypes() == null ? -1 : StaticHelper.COUNT(this.getStructureDataTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfStructureDataTypes", (Object)noOfStructureDataTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"structureDataTypes", this.structureDataTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfEnumDataTypes = this.getEnumDataTypes() == null ? -1 : StaticHelper.COUNT(this.getEnumDataTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfEnumDataTypes", (Object)noOfEnumDataTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"enumDataTypes", this.enumDataTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSimpleDataTypes = this.getSimpleDataTypes() == null ? -1 : StaticHelper.COUNT(this.getSimpleDataTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfSimpleDataTypes", (Object)noOfSimpleDataTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"simpleDataTypes", this.simpleDataTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"schemaLocation", (Object)this.schemaLocation, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfFileHeader = this.getFileHeader() == null ? -1 : StaticHelper.COUNT(this.getFileHeader());
        FieldWriterFactory.writeImplicitField((String)"noOfFileHeader", (Object)noOfFileHeader, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"fileHeader", this.fileHeader, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"body", (Object)this.body, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("UABinaryFileDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        UABinaryFileDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.namespaces != null) {
            i = 0;
            for (PascalString pascalString : this.namespaces) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.namespaces.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.structureDataTypes != null) {
            i = 0;
            for (StructureDescription structureDescription : this.structureDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.structureDataTypes.size());
                lengthInBits += structureDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.enumDataTypes != null) {
            i = 0;
            for (EnumDescription enumDescription : this.enumDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.enumDataTypes.size());
                lengthInBits += enumDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.simpleDataTypes != null) {
            i = 0;
            for (SimpleTypeDescription simpleTypeDescription : this.simpleDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.simpleDataTypes.size());
                lengthInBits += simpleTypeDescription.getLengthInBits();
            }
        }
        lengthInBits += this.schemaLocation.getLengthInBits();
        lengthInBits += 32;
        if (this.fileHeader != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.fileHeader) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.fileHeader.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        return lengthInBits += this.body.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("UABinaryFileDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfNamespaces = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNamespaces", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List namespaces = FieldReaderFactory.readCountArrayField((String)"namespaces", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfNamespaces, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfStructureDataTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfStructureDataTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List structureDataTypes = FieldReaderFactory.readCountArrayField((String)"structureDataTypes", (DataReader)DataReaderFactory.readComplex(() -> (StructureDescription)ExtensionObjectDefinition.staticParse(readBuffer, 15489), (ReadBuffer)readBuffer), (long)noOfStructureDataTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfEnumDataTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEnumDataTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List enumDataTypes = FieldReaderFactory.readCountArrayField((String)"enumDataTypes", (DataReader)DataReaderFactory.readComplex(() -> (EnumDescription)ExtensionObjectDefinition.staticParse(readBuffer, 15490), (ReadBuffer)readBuffer), (long)noOfEnumDataTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSimpleDataTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSimpleDataTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List simpleDataTypes = FieldReaderFactory.readCountArrayField((String)"simpleDataTypes", (DataReader)DataReaderFactory.readComplex(() -> (SimpleTypeDescription)ExtensionObjectDefinition.staticParse(readBuffer, 15007), (ReadBuffer)readBuffer), (long)noOfSimpleDataTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString schemaLocation = (PascalString)FieldReaderFactory.readSimpleField((String)"schemaLocation", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfFileHeader = (Integer)FieldReaderFactory.readImplicitField((String)"noOfFileHeader", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List fileHeader = FieldReaderFactory.readCountArrayField((String)"fileHeader", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfFileHeader, (WithReaderArgs[])new WithReaderArgs[0]);
        Variant body = (Variant)FieldReaderFactory.readSimpleField((String)"body", (DataReader)DataReaderFactory.readComplex(() -> Variant.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("UABinaryFileDataType", new WithReaderArgs[0]);
        return new UABinaryFileDataTypeBuilderImpl(namespaces, structureDataTypes, enumDataTypes, simpleDataTypes, schemaLocation, fileHeader, body);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UABinaryFileDataType)) {
            return false;
        }
        UABinaryFileDataType that = (UABinaryFileDataType)o;
        return this.getNamespaces() == that.getNamespaces() && this.getStructureDataTypes() == that.getStructureDataTypes() && this.getEnumDataTypes() == that.getEnumDataTypes() && this.getSimpleDataTypes() == that.getSimpleDataTypes() && this.getSchemaLocation() == that.getSchemaLocation() && this.getFileHeader() == that.getFileHeader() && this.getBody() == that.getBody() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes(), this.getSchemaLocation(), this.getFileHeader(), this.getBody());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class UABinaryFileDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<PascalString> namespaces;
        private final List<StructureDescription> structureDataTypes;
        private final List<EnumDescription> enumDataTypes;
        private final List<SimpleTypeDescription> simpleDataTypes;
        private final PascalString schemaLocation;
        private final List<KeyValuePair> fileHeader;
        private final Variant body;

        public UABinaryFileDataTypeBuilderImpl(List<PascalString> namespaces, List<StructureDescription> structureDataTypes, List<EnumDescription> enumDataTypes, List<SimpleTypeDescription> simpleDataTypes, PascalString schemaLocation, List<KeyValuePair> fileHeader, Variant body) {
            this.namespaces = namespaces;
            this.structureDataTypes = structureDataTypes;
            this.enumDataTypes = enumDataTypes;
            this.simpleDataTypes = simpleDataTypes;
            this.schemaLocation = schemaLocation;
            this.fileHeader = fileHeader;
            this.body = body;
        }

        @Override
        public UABinaryFileDataType build() {
            UABinaryFileDataType uABinaryFileDataType = new UABinaryFileDataType(this.namespaces, this.structureDataTypes, this.enumDataTypes, this.simpleDataTypes, this.schemaLocation, this.fileHeader, this.body);
            return uABinaryFileDataType;
        }
    }
}

