/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.tag;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.EnumUtils;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedDataTypeException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.opcua.readwrite.AttributeId;
import org.apache.plc4x.java.opcua.readwrite.OpcuaDataType;
import org.apache.plc4x.java.opcua.readwrite.OpcuaIdentifierType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.tag.TagConfigParser;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaTag
implements PlcSubscriptionTag,
Serializable {
    private static final String OPC_UTA_TAG_ADDRESS = "^ns=(?<namespace>\\d+);(?<identifierType>[isgb])=(?<identifier>[^;]+)?(;a=(?<attributeId>[^;]+))?(;(?<datatype>[a-zA-Z_]+))?";
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("^ns=(?<namespace>\\d+);(?<identifierType>[isgb])=(?<identifier>[^;]+)?(;a=(?<attributeId>[^;]+))?(;(?<datatype>[a-zA-Z_]+))?" + TagConfigParser.TAG_CONFIG_PATTERN + "$");
    private final OpcuaIdentifierType identifierType;
    private final int namespace;
    private final String identifier;
    private final AttributeId attributeId;
    private final OpcuaDataType dataType;
    private final Map<String, String> config;

    private OpcuaTag(Integer namespace, String identifier, OpcuaIdentifierType identifierType, AttributeId attributeId, OpcuaDataType dataType, Map<String, String> config) {
        this.identifier = Objects.requireNonNull(identifier);
        this.identifierType = Objects.requireNonNull(identifierType);
        int n = this.namespace = namespace != null ? namespace : 0;
        if (this.namespace < 0) {
            throw new IllegalArgumentException("namespace must be greater then zero. Was " + this.namespace);
        }
        this.attributeId = attributeId;
        this.dataType = dataType;
        this.config = config;
    }

    public static OpcuaTag of(String address) {
        String dataTypeString;
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidTagException(address, ADDRESS_PATTERN, "{address}");
        }
        String identifier = matcher.group("identifier");
        String identifierTypeString = matcher.group("identifierType");
        OpcuaIdentifierType identifierType = OpcuaIdentifierType.enumForValue(identifierTypeString);
        String namespaceString = matcher.group("namespace");
        Integer namespace = namespaceString != null ? Integer.parseInt(namespaceString) : 0;
        String string = dataTypeString = matcher.group("datatype") != null ? matcher.group("datatype").toUpperCase() : "NULL";
        if (!EnumUtils.isValidEnum(OpcuaDataType.class, (String)dataTypeString)) {
            throw new PlcUnsupportedDataTypeException("Datatype " + dataTypeString + " is unsupported by this protocol");
        }
        OpcuaDataType dataType = OpcuaDataType.valueOf(dataTypeString);
        String attributeElement = matcher.group("attributeId");
        AttributeId attributeId = AttributeId.Value;
        if (attributeElement != null) {
            attributeId = attributeElement.matches("\\d+") ? AttributeId.enumForValue(Long.parseLong(attributeElement)) : AttributeId.valueOf(attributeElement);
        }
        return new OpcuaTag(namespace, identifier, identifierType, attributeId, dataType, TagConfigParser.parse((String)address));
    }

    public PlcTag getTag() {
        return new OpcuaTag(this.namespace, this.identifier, this.identifierType, this.attributeId, this.dataType, this.config);
    }

    public static boolean matches(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public int getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public OpcuaIdentifierType getIdentifierType() {
        return this.identifierType;
    }

    public OpcuaDataType getDataType() {
        return this.dataType;
    }

    public AttributeId getAttributeId() {
        return this.attributeId;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public String getAddressString() {
        String address = String.format("ns=%d;%s=%s", this.namespace, this.identifierType.getValue(), this.identifier);
        if (this.attributeId != AttributeId.Value) {
            address = String.valueOf(address) + ";a=" + this.attributeId.name();
        }
        if (this.dataType != null) {
            address = String.valueOf(address) + ";" + this.dataType.name();
        }
        return address;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.valueOf((String)this.dataType.name());
    }

    public List<ArrayInfo> getArrayInfo() {
        return super.getArrayInfo();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaTag)) {
            return false;
        }
        OpcuaTag that = (OpcuaTag)o;
        return this.namespace == that.namespace && this.identifier.equals(that.identifier) && this.identifierType == that.identifierType && this.attributeId == that.attributeId && this.config.equals(that.config);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespace, this.identifier, this.identifierType, this.attributeId, this.config});
    }

    public String toString() {
        return "OpcuaTag{ namespace=" + this.namespace + " identifierType=" + this.identifierType.getValue() + " identifier=" + this.identifier + " attributeId=" + this.attributeId.name() + " config=" + this.config + '}';
    }

    public PlcSubscriptionType getPlcSubscriptionType() {
        return null;
    }

    public Optional<Duration> getDuration() {
        return Optional.empty();
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String nodeId = String.format("ns=%d;%s=%s", this.namespace, this.identifierType.getValue(), this.identifier);
        writeBuffer.writeString("nodeId", nodeId.length() * 8, nodeId, new WithWriterArgs[0]);
        writeBuffer.writeString("attributeId", this.attributeId.name().length() * 8, this.attributeId.name(), new WithWriterArgs[0]);
        if (this.dataType != null) {
            String dataType = this.getDataType().name();
            writeBuffer.writeString("dataType", dataType.length() * 8, dataType, new WithWriterArgs[0]);
        }
        if (!this.config.isEmpty()) {
            writeBuffer.pushContext("config", new WithWriterArgs[0]);
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                writeBuffer.pushContext("entry", new WithWriterArgs[0]);
                writeBuffer.writeString("key", entry.getKey().length() * 8, entry.getKey(), new WithWriterArgs[0]);
                writeBuffer.writeString("value", entry.getValue().length() * 8, entry.getValue(), new WithWriterArgs[0]);
                writeBuffer.popContext("entry", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("config", new WithWriterArgs[0]);
        }
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

