/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class S7PayloadUserDataItem implements Message {

  // Abstract accessors for discriminator values.
  public abstract Byte getCpuFunctionType();

  public abstract Short getCpuSubfunction();

  public abstract Integer getDataLength();

  // Properties.
  protected final DataTransportErrorCode returnCode;
  protected final DataTransportSize transportSize;

  public S7PayloadUserDataItem(DataTransportErrorCode returnCode, DataTransportSize transportSize) {
    super();
    this.returnCode = returnCode;
    this.transportSize = transportSize;
  }

  public DataTransportErrorCode getReturnCode() {
    return returnCode;
  }

  public DataTransportSize getTransportSize() {
    return transportSize;
  }

  protected abstract void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("S7PayloadUserDataItem");

    // Simple Field (returnCode)
    writeSimpleEnumField(
        "returnCode",
        "DataTransportErrorCode",
        returnCode,
        new DataWriterEnumDefault<>(
            DataTransportErrorCode::getValue,
            DataTransportErrorCode::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (transportSize)
    writeSimpleEnumField(
        "transportSize",
        "DataTransportSize",
        transportSize,
        new DataWriterEnumDefault<>(
            DataTransportSize::getValue,
            DataTransportSize::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Implicit Field (dataLength) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int dataLength = (int) ((getLengthInBytes()) - (4));
    writeImplicitField("dataLength", dataLength, writeUnsignedInt(writeBuffer, 16));

    // Switch field (Serialize the sub-type)
    serializeS7PayloadUserDataItemChild(writeBuffer);

    writeBuffer.popContext("S7PayloadUserDataItem");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    S7PayloadUserDataItem _value = this;

    // Simple field (returnCode)
    lengthInBits += 8;

    // Simple field (transportSize)
    lengthInBits += 8;

    // Implicit Field (dataLength)
    lengthInBits += 16;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static S7PayloadUserDataItem staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 2)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 2, but got " + args.length);
    }
    Byte cpuFunctionType;
    if (args[0] instanceof Byte) {
      cpuFunctionType = (Byte) args[0];
    } else if (args[0] instanceof String) {
      cpuFunctionType = Byte.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Byte or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    Short cpuSubfunction;
    if (args[1] instanceof Short) {
      cpuSubfunction = (Short) args[1];
    } else if (args[1] instanceof String) {
      cpuSubfunction = Short.valueOf((String) args[1]);
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type Short or a string which is parseable but was "
              + args[1].getClass().getName());
    }
    return staticParse(readBuffer, cpuFunctionType, cpuSubfunction);
  }

  public static S7PayloadUserDataItem staticParse(
      ReadBuffer readBuffer, Byte cpuFunctionType, Short cpuSubfunction) throws ParseException {
    readBuffer.pullContext("S7PayloadUserDataItem");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    DataTransportErrorCode returnCode =
        readEnumField(
            "returnCode",
            "DataTransportErrorCode",
            new DataReaderEnumDefault<>(
                DataTransportErrorCode::enumForValue, readUnsignedShort(readBuffer, 8)));

    DataTransportSize transportSize =
        readEnumField(
            "transportSize",
            "DataTransportSize",
            new DataReaderEnumDefault<>(
                DataTransportSize::enumForValue, readUnsignedShort(readBuffer, 8)));

    int dataLength = readImplicitField("dataLength", readUnsignedInt(readBuffer, 16));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    S7PayloadUserDataItemBuilder builder = null;
    if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x03)) {
      builder =
          S7PayloadDiagnosticMessage.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x05)) {
      builder = S7PayloadAlarm8.staticParseBuilder(readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x06)) {
      builder = S7PayloadNotify.staticParseBuilder(readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x0c)) {
      builder =
          S7PayloadAlarmAckInd.staticParseBuilder(readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x11)) {
      builder = S7PayloadAlarmSQ.staticParseBuilder(readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x12)) {
      builder = S7PayloadAlarmS.staticParseBuilder(readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x13)) {
      builder = S7PayloadAlarmSC.staticParseBuilder(readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x00)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x16)) {
      builder = S7PayloadNotify8.staticParseBuilder(readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x04)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x01)) {
      builder =
          S7PayloadUserDataItemCpuFunctionReadSzlRequest.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x08)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x01)) {
      builder =
          S7PayloadUserDataItemCpuFunctionReadSzlResponse.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x04)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x02)) {
      builder =
          S7PayloadUserDataItemCpuFunctionMsgSubscription.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x08)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x02)
        && EvaluationHelper.equals(dataLength, (int) 0x00)) {
      builder =
          S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x08)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x02)
        && EvaluationHelper.equals(dataLength, (int) 0x02)) {
      builder =
          S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x08)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x02)
        && EvaluationHelper.equals(dataLength, (int) 0x05)) {
      builder =
          S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x04)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x0b)) {
      builder =
          S7PayloadUserDataItemCpuFunctionAlarmAck.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x08)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x0b)) {
      builder =
          S7PayloadUserDataItemCpuFunctionAlarmAckResponse.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x04)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x13)) {
      builder =
          S7PayloadUserDataItemCpuFunctionAlarmQuery.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    } else if (EvaluationHelper.equals(cpuFunctionType, (byte) 0x08)
        && EvaluationHelper.equals(cpuSubfunction, (short) 0x13)) {
      builder =
          S7PayloadUserDataItemCpuFunctionAlarmQueryResponse.staticParseBuilder(
              readBuffer, cpuFunctionType, cpuSubfunction);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "cpuFunctionType="
              + cpuFunctionType
              + " "
              + "cpuSubfunction="
              + cpuSubfunction
              + " "
              + "dataLength="
              + dataLength
              + "]");
    }

    readBuffer.closeContext("S7PayloadUserDataItem");
    // Create the instance
    S7PayloadUserDataItem _s7PayloadUserDataItem = builder.build(returnCode, transportSize);
    return _s7PayloadUserDataItem;
  }

  public static interface S7PayloadUserDataItemBuilder {
    S7PayloadUserDataItem build(DataTransportErrorCode returnCode, DataTransportSize transportSize);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7PayloadUserDataItem)) {
      return false;
    }
    S7PayloadUserDataItem that = (S7PayloadUserDataItem) o;
    return (getReturnCode() == that.getReturnCode())
        && (getTransportSize() == that.getTransportSize())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getReturnCode(), getTransportSize());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
