/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DataTransportSize {
    NULL(0, false),
    BIT(3, true),
    BYTE_WORD_DWORD(4, true),
    INTEGER(5, true),
    DINTEGER(6, false),
    REAL(7, false),
    OCTET_STRING(9, false);

    private static final Map<Short, DataTransportSize> map;
    private short value;
    private boolean sizeInBits;

    private DataTransportSize(short value, boolean sizeInBits) {
        this.value = value;
        this.sizeInBits = sizeInBits;
    }

    public short getValue() {
        return this.value;
    }

    public boolean getSizeInBits() {
        return this.sizeInBits;
    }

    public static DataTransportSize firstEnumForFieldSizeInBits(boolean fieldValue) {
        for (DataTransportSize _val : DataTransportSize.values()) {
            if (_val.getSizeInBits() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<DataTransportSize> enumsForFieldSizeInBits(boolean fieldValue) {
        ArrayList<DataTransportSize> _values = new ArrayList<DataTransportSize>();
        for (DataTransportSize _val : DataTransportSize.values()) {
            if (_val.getSizeInBits() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static DataTransportSize enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Short, DataTransportSize>();
        for (DataTransportSize value : DataTransportSize.values()) {
            map.put(value.getValue(), value);
        }
    }
}

