/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponse;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7MessageUserData;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7Payload;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class S7Message
implements Message {
    public static final Short PROTOCOLID = 50;
    protected final int tpduReference;
    protected final S7Parameter parameter;
    protected final S7Payload payload;
    private Integer reservedField0;

    public abstract Short getMessageType();

    public S7Message(int tpduReference, S7Parameter parameter, S7Payload payload) {
        this.tpduReference = tpduReference;
        this.parameter = parameter;
        this.payload = payload;
    }

    public int getTpduReference() {
        return this.tpduReference;
    }

    public S7Parameter getParameter() {
        return this.parameter;
    }

    public S7Payload getPayload() {
        return this.payload;
    }

    public short getProtocolId() {
        return PROTOCOLID;
    }

    protected abstract void serializeS7MessageChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("S7Message", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"protocolId", (Object)PROTOCOLID, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"messageType", (Object)this.getMessageType(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : 0), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"tpduReference", (Object)this.tpduReference, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int parameterLength = this.getParameter() != null ? this.getParameter().getLengthInBytes() : 0;
        FieldWriterFactory.writeImplicitField((String)"parameterLength", (Object)parameterLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int payloadLength = this.getPayload() != null ? this.getPayload().getLengthInBytes() : 0;
        FieldWriterFactory.writeImplicitField((String)"payloadLength", (Object)payloadLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeS7MessageChild(writeBuffer);
        FieldWriterFactory.writeOptionalField((String)"parameter", (Object)this.parameter, (DataWriter)new DataWriterComplexDefault(writeBuffer), ((this.getParameter() != null ? this.getParameter().getLengthInBytes() : 0) > 0 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"payload", (Object)this.payload, (DataWriter)new DataWriterComplexDefault(writeBuffer), ((this.getPayload() != null ? this.getPayload().getLengthInBytes() : 0) > 0 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("S7Message", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        S7Message _value = this;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        if (this.parameter != null) {
            lengthInBits += this.parameter.getLengthInBits();
        }
        if (this.payload != null) {
            lengthInBits += this.payload.getLengthInBits();
        }
        return lengthInBits;
    }

    public static S7Message staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return S7Message.staticParse(readBuffer);
    }

    public static S7Message staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("S7Message", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short protocolId = (Short)FieldReaderFactory.readConstField((String)"protocolId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)PROTOCOLID, (WithReaderArgs[])new WithReaderArgs[0]);
        short messageType = (Short)FieldReaderFactory.readDiscriminatorField((String)"messageType", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        Integer reservedField0 = (Integer)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        int tpduReference = (Integer)FieldReaderFactory.readSimpleField((String)"tpduReference", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int parameterLength = (Integer)FieldReaderFactory.readImplicitField((String)"parameterLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int payloadLength = (Integer)FieldReaderFactory.readImplicitField((String)"payloadLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        S7MessageBuilder builder = null;
        if (EvaluationHelper.equals((Object)messageType, (Object)1)) {
            builder = S7MessageRequest.staticParseBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)2)) {
            builder = S7MessageResponse.staticParseBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)3)) {
            builder = S7MessageResponseData.staticParseBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)7)) {
            builder = S7MessageUserData.staticParseBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [messageType=" + messageType + "]");
        }
        S7Parameter parameter = (S7Parameter)FieldReaderFactory.readOptionalField((String)"parameter", (DataReader)new DataReaderComplexDefault(() -> S7Parameter.staticParse(readBuffer, messageType), readBuffer), (parameterLength > 0 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        S7Payload payload = (S7Payload)FieldReaderFactory.readOptionalField((String)"payload", (DataReader)new DataReaderComplexDefault(() -> S7Payload.staticParse(readBuffer, messageType, parameter), readBuffer), (payloadLength > 0 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("S7Message", new WithReaderArgs[0]);
        S7Message _s7Message = builder.build(tpduReference, parameter, payload);
        _s7Message.reservedField0 = reservedField0;
        return _s7Message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7Message)) {
            return false;
        }
        S7Message that = (S7Message)o;
        return this.getTpduReference() == that.getTpduReference() && this.getParameter() == that.getParameter() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getTpduReference(), this.getParameter(), this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface S7MessageBuilder {
        public S7Message build(int var1, S7Parameter var2, S7Payload var3);
    }
}

