/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.context;

import org.apache.plc4x.java.s7.readwrite.COTPTpduSize;
import org.apache.plc4x.java.s7.readwrite.DeviceGroup;
import org.apache.plc4x.java.s7.readwrite.configuration.S7Configuration;
import org.apache.plc4x.java.s7.readwrite.types.S7ControllerType;
import org.apache.plc4x.java.s7.readwrite.utils.S7TsapIdEncoder;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;

public class S7DriverContext
implements DriverContext,
HasConfiguration<S7Configuration> {
    private boolean passiveMode = false;
    private int callingTsapId;
    private int calledTsapId;
    private COTPTpduSize cotpTpduSize;
    private int pduSize;
    private int maxAmqCaller;
    private int maxAmqCallee;
    private S7ControllerType controllerType;

    public void setConfiguration(S7Configuration configuration) {
        this.callingTsapId = S7TsapIdEncoder.encodeS7TsapId(DeviceGroup.OTHERS, configuration.localRack, configuration.localSlot);
        this.calledTsapId = S7TsapIdEncoder.encodeS7TsapId(DeviceGroup.PG_OR_PC, configuration.remoteRack, configuration.remoteSlot);
        if (configuration.localTsap > 0) {
            this.callingTsapId = configuration.localTsap;
        }
        if (configuration.remoteTsap > 0) {
            this.calledTsapId = configuration.remoteTsap;
        }
        this.controllerType = configuration.controllerType == null ? S7ControllerType.ANY : S7ControllerType.valueOf(configuration.controllerType);
        this.cotpTpduSize = this.getNearestMatchingTpduSize((short)configuration.getPduSize());
        if (this.controllerType == S7ControllerType.LOGO && configuration.pduSize == 1024) {
            configuration.pduSize = 480;
            this.pduSize = 480;
        } else {
            this.pduSize = this.cotpTpduSize.getSizeInBytes() - 16;
        }
        this.maxAmqCaller = configuration.maxAmqCaller;
        this.maxAmqCallee = configuration.maxAmqCallee;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public int getCallingTsapId() {
        return this.callingTsapId;
    }

    public void setCallingTsapId(int callingTsapId) {
        this.callingTsapId = callingTsapId;
    }

    public int getCalledTsapId() {
        return this.calledTsapId;
    }

    public void setCalledTsapId(int calledTsapId) {
        this.calledTsapId = calledTsapId;
    }

    public COTPTpduSize getCotpTpduSize() {
        return this.cotpTpduSize;
    }

    public void setCotpTpduSize(COTPTpduSize cotpTpduSize) {
        this.cotpTpduSize = cotpTpduSize;
    }

    public int getPduSize() {
        return this.pduSize;
    }

    public void setPduSize(int pduSize) {
        this.pduSize = pduSize;
    }

    public int getMaxAmqCaller() {
        return this.maxAmqCaller;
    }

    public void setMaxAmqCaller(int maxAmqCaller) {
        this.maxAmqCaller = maxAmqCaller;
    }

    public int getMaxAmqCallee() {
        return this.maxAmqCallee;
    }

    public void setMaxAmqCallee(int maxAmqCallee) {
        this.maxAmqCallee = maxAmqCallee;
    }

    public S7ControllerType getControllerType() {
        return this.controllerType;
    }

    public void setControllerType(S7ControllerType controllerType) {
        this.controllerType = controllerType;
    }

    protected COTPTpduSize getNearestMatchingTpduSize(short tpduSizeParameter) {
        for (COTPTpduSize value : COTPTpduSize.values()) {
            if (value.getSizeInBytes() < tpduSizeParameter) continue;
            return value;
        }
        return null;
    }
}

