/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, String dataProtocolId, Integer stringLength) throws ParseException {
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BOOL")) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BYTE")) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WORD")) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DWORD")) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LWORD")) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_SINT")) {
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_USINT")) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_INT")) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UINT")) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DINT")) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UDINT")) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LINT")) {
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_ULINT")) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_REAL")) {
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LREAL")) {
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_CHAR")) {
            String value = readBuffer.readString("", 8, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-8")});
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WCHAR")) {
            String value = readBuffer.readString("", 16, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-16")});
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_STRING")) {
            String value = StaticHelper.parseS7String(readBuffer, stringLength, "UTF-8");
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WSTRING")) {
            String value = StaticHelper.parseS7String(readBuffer, stringLength, "UTF-16");
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME")) {
            Long milliseconds = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcTIME.ofMilliseconds((long)milliseconds);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME")) {
            BigInteger nanoseconds = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return PlcLTIME.ofNanoseconds((BigInteger)nanoseconds);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE")) {
            Integer daysSinceSiemensEpoch = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return PlcDATE.ofDaysSinceSiemensEpoch((int)daysSinceSiemensEpoch);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME_OF_DAY")) {
            Long millisecondsSinceMidnight = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight((long)millisecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME_OF_DAY")) {
            BigInteger nanosecondsSinceMidnight = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return PlcLTIME_OF_DAY.ofNanosecondsSinceMidnight((BigInteger)nanosecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_TIME")) {
            Integer year = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short month = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short day = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short dayOfWeek = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short hour = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short minutes = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short seconds = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Long nanoseconds = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcDATE_AND_TIME.ofSegments((int)year, (int)(month == 0 ? 1 : month.intValue()), (int)(day == 0 ? 1 : day.intValue()), (int)hour.intValue(), (int)minutes.intValue(), (int)seconds.intValue(), (int)nanoseconds.intValue());
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataProtocolId, Integer stringLength) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataProtocolId, stringLength, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataProtocolId, Integer stringLength, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BOOL")) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BYTE")) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WORD")) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DWORD")) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LWORD")) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_SINT")) {
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_USINT")) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_INT")) {
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UINT")) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DINT")) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UDINT")) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LINT")) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_ULINT")) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_REAL")) {
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LREAL")) {
            double value = _value.getDouble();
            writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_CHAR")) {
            String value = _value.getString();
            writeBuffer.writeString("", 8, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-8")});
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WCHAR")) {
            String value = _value.getString();
            writeBuffer.writeString("", 16, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-16")});
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_STRING")) {
            StaticHelper.serializeS7String(writeBuffer, _value, stringLength, "UTF-8");
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WSTRING")) {
            StaticHelper.serializeS7String(writeBuffer, _value, stringLength, "UTF-16");
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME")) {
            long milliseconds = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)milliseconds).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME")) {
            BigInteger nanoseconds = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, nanoseconds, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE")) {
            int daysSinceSiemensEpoch = ((PlcDATE)_value).getDaysSinceSiemensEpoch();
            writeBuffer.writeUnsignedInt("", 16, ((Number)daysSinceSiemensEpoch).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME_OF_DAY")) {
            long millisecondsSinceMidnight = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)millisecondsSinceMidnight).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME_OF_DAY")) {
            BigInteger nanosecondsSinceMidnight = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, nanosecondsSinceMidnight, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_TIME")) {
            int year = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)year).intValue(), new WithWriterArgs[0]);
            short month = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)month).shortValue(), new WithWriterArgs[0]);
            short day = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)day).shortValue(), new WithWriterArgs[0]);
            short dayOfWeek = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)dayOfWeek).shortValue(), new WithWriterArgs[0]);
            short hour = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)hour).shortValue(), new WithWriterArgs[0]);
            short minutes = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)minutes).shortValue(), new WithWriterArgs[0]);
            short seconds = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)seconds).shortValue(), new WithWriterArgs[0]);
            long nanoseconds = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)nanoseconds).longValue(), new WithWriterArgs[0]);
        }
    }

    public static int getLengthInBytes(PlcValue _value, String dataProtocolId, Integer stringLength) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataProtocolId, stringLength) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, String dataProtocolId, Integer stringLength) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BOOL")) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BYTE")) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WORD")) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DWORD")) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LWORD")) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_SINT")) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_USINT")) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_INT")) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UINT")) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DINT")) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UDINT")) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LINT")) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_ULINT")) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_REAL")) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LREAL")) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_CHAR")) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WCHAR")) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_STRING")) {
            sizeInBits += stringLength * 8 + 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WSTRING")) {
            sizeInBits += stringLength * 16 + 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME")) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME")) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE")) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME_OF_DAY")) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME_OF_DAY")) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_TIME")) {
            sizeInBits += 16;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 32;
        }
        return sizeInBits;
    }
}

