/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.connection.S7HMux;
import org.apache.plc4x.java.s7.readwrite.connection.S7HMuxImpl;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.DefaultNettyPlcConnection;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.events.CloseConnectionEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7HDefaultNettyPlcConnection
extends DefaultNettyPlcConnection
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(S7HDefaultNettyPlcConnection.class);
    private static final String MULTIPLEXOR = "MULTIPLEXOR";
    private Boolean closed = false;
    private ScheduledFuture<?> scf = null;
    protected final ChannelFactory secondaryChannelFactory;
    protected Channel primary_channel = null;
    protected Channel secondary_channel = null;
    protected final MessageToMessageCodec<ByteBuf, ByteBuf> s7hmux;
    protected int slice_ping = 0;
    protected int slice_retry_time = 0;

    public S7HDefaultNettyPlcConnection(boolean canPing, boolean canRead, boolean canWrite, boolean canSubscribe, boolean canBrowse, PlcTagHandler tagHandler, PlcValueHandler valueHandler, Configuration configuration, ChannelFactory channelFactory, ChannelFactory secondaryChannelFactory, boolean fireDiscoverEvent, boolean awaitSessionSetupComplete, boolean awaitSessionDisconnectComplete, boolean awaitSessionDiscoverComplete, ProtocolStackConfigurer<TPKTPacket> stackConfigurer, BaseOptimizer optimizer, PlcAuthentication authentication) {
        super(canPing, canRead, canWrite, canSubscribe, canBrowse, tagHandler, valueHandler, configuration, channelFactory, fireDiscoverEvent, awaitSessionSetupComplete, awaitSessionDisconnectComplete, awaitSessionDiscoverComplete, stackConfigurer, optimizer, authentication);
        this.secondaryChannelFactory = secondaryChannelFactory;
        this.s7hmux = new S7HMuxImpl();
    }

    public void connect() throws PlcConnectionException {
        try {
            CompletableFuture sessionSetupCompleteFuture = new CompletableFuture();
            CompletableFuture sessionDiscoveredCompleteFuture = new CompletableFuture();
            if (this.channelFactory == null) {
                throw new PlcConnectionException("No primary channel factory provided");
            }
            ConfigurationFactory.configure((Configuration)this.configuration, (Object)this.channelFactory);
            if (this.secondaryChannelFactory != null) {
                ConfigurationFactory.configure((Configuration)this.configuration, (Object)this.secondaryChannelFactory);
            }
            this.channel = new EmbeddedChannel(new ChannelHandler[]{this.getChannelHandler(sessionSetupCompleteFuture, this.sessionDisconnectCompleteFuture, sessionDiscoveredCompleteFuture)});
            this.channel.pipeline().addFirst(new ChannelHandler[]{this.s7hmux});
            ((S7HMux)this.s7hmux).setEmbeddedChannel(this.channel);
            this.doPrimaryTcpConnections();
            if (this.secondaryChannelFactory != null) {
                this.doSecondaryTcpConnections();
            }
            if (this.primary_channel == null && this.secondary_channel == null) {
                this.sendChannelDisconnectEvent();
                throw new PlcConnectionException("Connection is not possible.");
            }
            this.scf = this.channel.eventLoop().scheduleWithFixedDelay((Runnable)this, 1L, 1L, TimeUnit.SECONDS);
            this.sendChannelCreatedEvent();
            if (this.awaitSessionSetupComplete) {
                sessionSetupCompleteFuture.get();
            }
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PlcConnectionException((Throwable)e);
        }
    }

    public void close() throws PlcConnectionException {
        if (this.closed.booleanValue()) {
            return;
        }
        try {
            this.scf.cancel(true);
        }
        catch (Exception e) {
            logger.info("uh", (Throwable)e);
        }
        if (this.primary_channel != null && this.primary_channel.isActive()) {
            try {
                this.primary_channel.pipeline().remove(MULTIPLEXOR);
                this.primary_channel.pipeline().fireUserEventTriggered((Object)new CloseConnectionEvent());
                this.primary_channel.eventLoop().shutdownGracefully();
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
        }
        if (this.secondary_channel != null && this.secondary_channel.isActive()) {
            this.secondary_channel.pipeline().remove(MULTIPLEXOR);
            this.secondary_channel.pipeline().fireUserEventTriggered((Object)new CloseConnectionEvent());
            this.secondary_channel.eventLoop().shutdownGracefully();
        }
        this.channel.pipeline().fireUserEventTriggered((Object)new DisconnectEvent());
        this.closed = true;
    }

    public void doPrimaryTcpConnections() {
        try {
            this.primary_channel = this.channelFactory.createChannel((ChannelHandler)new LoggingHandler(LogLevel.TRACE));
        }
        catch (Exception ex) {
            logger.info(ex.toString());
        }
        if (this.primary_channel != null && this.primary_channel.isActive()) {
            this.primary_channel.pipeline().addFirst(MULTIPLEXOR, this.s7hmux);
        }
        ((S7HMux)this.s7hmux).setPrimaryChannel(this.primary_channel);
    }

    public void doSecondaryTcpConnections() {
        try {
            this.secondary_channel = this.secondaryChannelFactory.createChannel((ChannelHandler)new LoggingHandler(LogLevel.TRACE));
        }
        catch (Exception ex) {
            logger.info(ex.toString());
        }
        if (this.secondary_channel != null && this.secondary_channel.isActive()) {
            this.secondary_channel.pipeline().addFirst(MULTIPLEXOR, this.s7hmux);
        }
        ((S7HMux)this.s7hmux).setSecondaryChannel(this.secondary_channel);
    }

    protected void sendChannelDisconnectEvent() {
        logger.trace("Channels was not created, firing DisconnectEvent Event");
        this.channel.pipeline().fireUserEventTriggered((Object)new DisconnectEvent());
    }

    @Override
    public void run() {
        if (this.slice_retry_time >= (Integer)this.channel.attr(S7HMuxImpl.RETRY_TIME).get()) {
            if (this.primary_channel != null) {
                if (!this.primary_channel.isActive()) {
                    logger.info("Creating primary connection.");
                    this.primary_channel.eventLoop().shutdownGracefully();
                    this.doPrimaryTcpConnections();
                }
            } else {
                logger.info("Creating first primary connection.");
                this.doPrimaryTcpConnections();
            }
            if (this.secondary_channel != null) {
                if (!this.secondary_channel.isActive()) {
                    logger.info("Creating secondary connection.");
                    this.secondary_channel.eventLoop().shutdownGracefully();
                    this.doSecondaryTcpConnections();
                }
            } else if (this.secondaryChannelFactory != null) {
                logger.info("Creating first secondary connection.");
                this.doSecondaryTcpConnections();
            }
            this.slice_retry_time = 0;
        }
        if (((Boolean)this.channel.attr(S7HMuxImpl.IS_PING_ACTIVE).get()).booleanValue()) {
            if (this.slice_ping >= (Integer)this.channel.attr(S7HMuxImpl.PING_TIME).get()) {
                this.ping();
                this.slice_ping = 0;
            }
        } else {
            this.slice_ping = 0;
        }
        ++this.slice_retry_time;
        ++this.slice_ping;
    }

    public CompletableFuture<? extends PlcPingResponse> ping() {
        if (((Boolean)this.channel.attr(S7HMuxImpl.IS_CONNECTED).get()).booleanValue()) {
            this.channel.eventLoop().execute(() -> {
                PlcReadRequest.Builder builder = this.readRequestBuilder();
                builder.addTagAddress("value", "%MX1.0:BOOL");
                PlcReadRequest readRequest = builder.build();
                try {
                    PlcReadResponse readResponse = (PlcReadResponse)readRequest.execute().get(2L, TimeUnit.SECONDS);
                    logger.info("PING: {}", (Object)readResponse.getResponseCode("value"));
                }
                catch (Exception e) {
                    logger.info("PING: {}", (Object)e.getMessage(), (Object)e);
                }
            });
        }
        return null;
    }
}

