/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.events.S7CyclicEvent;
import org.apache.plc4x.java.s7.readwrite.AlarmMessageObjectAckType;
import org.apache.plc4x.java.s7.readwrite.AlarmStateType;
import org.apache.plc4x.java.s7.readwrite.AlarmType;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketData;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCalledTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCallingTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterTpduSize;
import org.apache.plc4x.java.s7.readwrite.COTPProtocolClass;
import org.apache.plc4x.java.s7.readwrite.COTPTpduSize;
import org.apache.plc4x.java.s7.readwrite.CycServiceItemAnyType;
import org.apache.plc4x.java.s7.readwrite.CycServiceItemDbReadType;
import org.apache.plc4x.java.s7.readwrite.CycServiceItemType;
import org.apache.plc4x.java.s7.readwrite.DataItem;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.s7.readwrite.EventType;
import org.apache.plc4x.java.s7.readwrite.QueryType;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponse;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7MessageUserData;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7ParameterModeTransition;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterSetupCommunication;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItemCPUFunctions;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7Payload;
import org.apache.plc4x.java.s7.readwrite.S7PayloadDiagnosticMessage;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserData;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmAckRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmAckResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmQueryRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionAlarmQueryResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesErrorResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesSubscribeRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesUnsubscribeRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesUnsubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadDataItem;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadStatusItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItemAddress;
import org.apache.plc4x.java.s7.readwrite.State;
import org.apache.plc4x.java.s7.readwrite.SubItem;
import org.apache.plc4x.java.s7.readwrite.SyntaxIdType;
import org.apache.plc4x.java.s7.readwrite.SzlId;
import org.apache.plc4x.java.s7.readwrite.SzlModuleTypeClass;
import org.apache.plc4x.java.s7.readwrite.SzlSublist;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.connection.S7HMuxImpl;
import org.apache.plc4x.java.s7.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7.readwrite.protocol.S7ProtocolEventLogic;
import org.apache.plc4x.java.s7.readwrite.tag.S7AckTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7SubscriptionTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7SzlTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7.readwrite.types.S7ControllerType;
import org.apache.plc4x.java.s7.readwrite.types.S7SubscriptionType;
import org.apache.plc4x.java.s7.readwrite.utils.S7PlcSubscriptionHandle;
import org.apache.plc4x.java.s7.utils.S7ParamErrorCode;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7ProtocolLogic
extends Plc4xProtocolBase<TPKTPacket> {
    private final Logger logger = LoggerFactory.getLogger(S7ProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private final AtomicInteger tpduGenerator = new AtomicInteger(10);
    private final ExecutorService clientExecutorService = Executors.newFixedThreadPool(4, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("plc4x-app-thread-%d").daemon(true).priority(10).build());
    private final BlockingQueue<Object> eventQueue = new ArrayBlockingQueue<Object>(1024);
    private final S7ProtocolEventLogic EventLogic = new S7ProtocolEventLogic(this.eventQueue);
    private final S7PlcSubscriptionHandle modeHandle = new S7PlcSubscriptionHandle(EventType.MODE, this.EventLogic);
    private final S7PlcSubscriptionHandle sysHandle = new S7PlcSubscriptionHandle(EventType.SYS, this.EventLogic);
    private final S7PlcSubscriptionHandle usrHandle = new S7PlcSubscriptionHandle(EventType.USR, this.EventLogic);
    private final S7PlcSubscriptionHandle almHandle = new S7PlcSubscriptionHandle(EventType.ALM, this.EventLogic);
    private final S7PlcSubscriptionHandle cycHandle = new S7PlcSubscriptionHandle(EventType.CYC, this.EventLogic);
    private final HashMap<Object, MutablePair<RequestTransactionManager.RequestTransaction, Object>> activeRequests = new HashMap();
    private S7DriverContext s7DriverContext;
    private RequestTransactionManager tm;

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.s7DriverContext = (S7DriverContext)driverContext;
        this.tm = new RequestTransactionManager(1);
        this.EventLogic.start();
    }

    public void onConnect(ConversationContext<TPKTPacket> context) {
        if (context.isPassive()) {
            this.logger.info("S7 Driver running in PASSIVE mode.");
            this.s7DriverContext.setPassiveMode(true);
            context.fireConnected();
            return;
        }
        this.setChannelFeatures();
        this.logger.info("S7 Driver running in ACTIVE mode.");
        this.logger.debug("Sending COTP Connection Request");
        TPKTPacket packet = new TPKTPacket(this.createCOTPConnectionRequest(this.s7DriverContext.getCalledTsapId(), this.s7DriverContext.getCallingTsapId(), this.s7DriverContext.getCotpTpduSize()));
        context.sendRequest((Object)packet).onTimeout(e -> {
            this.logger.warn("Timeout during Connection establishing, closing channel...");
            context.getChannel().close();
        }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketConnectionResponse).unwrap(p -> (COTPPacketConnectionResponse)p.getPayload()).handle(cotpPacketConnectionResponse -> {
            this.logger.debug("Got COTP Connection Response");
            this.logger.debug("Sending S7 Connection Request");
            context.sendRequest((Object)this.createS7ConnectionRequest((COTPPacketConnectionResponse)cotpPacketConnectionResponse)).onTimeout(e -> {
                this.logger.warn("Timeout during Connection establishing, closing channel...");
                context.getChannel().close();
            }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageResponseData.class).unwrap(S7Message::getParameter).only(S7ParameterSetupCommunication.class).handle(setupCommunication -> {
                this.logger.debug("Got S7 Connection Response");
                this.s7DriverContext.setMaxAmqCaller(setupCommunication.getMaxAmqCaller());
                this.s7DriverContext.setMaxAmqCallee(setupCommunication.getMaxAmqCallee());
                this.s7DriverContext.setPduSize(setupCommunication.getPduLength());
                this.tm.setNumberOfConcurrentRequests(this.s7DriverContext.getMaxAmqCallee());
                if (this.s7DriverContext.getControllerType() != S7ControllerType.ANY) {
                    context.fireConnected();
                    return;
                }
                this.logger.debug("Sending S7 Identification Request");
                TPKTPacket tpktPacket = this.createIdentifyRemoteMessage();
                context.sendRequest((Object)tpktPacket).onTimeout(e -> {
                    this.logger.warn("Timeout during Connection establishing, closing channel...");
                    context.getChannel().close();
                }).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).check(p -> p.getPayload() instanceof S7MessageUserData).unwrap(p -> (S7MessageUserData)p.getPayload()).check(p -> p.getPayload() instanceof S7PayloadUserData).handle(messageUserData -> {
                    this.logger.debug("Got S7 Identification Response");
                    S7PayloadUserData payloadUserData = (S7PayloadUserData)messageUserData.getPayload();
                    this.extractControllerTypeAndFireConnected(context, payloadUserData);
                    this.cleanFutures();
                });
            });
        });
    }

    public void onDisconnect(ConversationContext<TPKTPacket> context) {
        this.cleanFutures();
        this.clientExecutorService.shutdown();
        this.tm.shutdown();
        this.EventLogic.stop();
        context.getChannel().close();
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        if (!this.isConnected()) {
            CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
            return future;
        }
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        ArrayList<S7VarRequestParameterItem> requestItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfTags());
        if (request.getTags().get(0) instanceof S7SzlTag) {
            S7SzlTag szltag = (S7SzlTag)request.getTags().get(0);
            S7MessageUserData s7SzlMessageRequest = new S7MessageUserData(1, new S7ParameterUserData(List.of(new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 1, 0, null, null, null))), new S7PayloadUserData(List.of(new S7PayloadUserDataItemCpuFunctionReadSzlRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 4, new SzlId(SzlModuleTypeClass.enumForValue((byte)((szltag.getSzlId() & 0xF000) >> 12)), (byte)((szltag.getSzlId() & 0xF00) >> 8), SzlSublist.enumForValue((short)(szltag.getSzlId() & 0xFF))), szltag.getIndex()))));
            return this.toPlcReadResponse(readRequest, this.readInternal(s7SzlMessageRequest));
        }
        if (request.getTags().get(0) instanceof S7AckTag) {
            ArrayList<S7ParameterUserDataItem> parameterItems = new ArrayList<S7ParameterUserDataItem>(request.getNumberOfTags());
            ArrayList<S7PayloadUserDataItem> payloadItems = new ArrayList<S7PayloadUserDataItem>(request.getNumberOfTags());
            this.encodeAlarmAckRequest(request, parameterItems, payloadItems);
            S7MessageUserData s7MessageRequest = new S7MessageUserData(-1, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems));
            return this.toPlcReadResponse(readRequest, this.readInternal(s7MessageRequest));
        }
        for (PlcTag tag : request.getTags()) {
            requestItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(tag)));
        }
        S7MessageRequest s7MessageRequest = new S7MessageRequest(-1, new S7ParameterReadVarRequest(requestItems), null);
        return this.toPlcReadResponse(readRequest, this.readInternal(s7MessageRequest));
    }

    private CompletableFuture<PlcReadResponse> toPlcReadResponse(PlcReadRequest readRequest, CompletableFuture<S7Message> response) {
        CompletableFuture<PlcReadResponse> clientFuture = new CompletableFuture<PlcReadResponse>();
        this.activeRequests.get(response).setRight(clientFuture);
        try {
            this.clientExecutorService.execute(() -> {
                try {
                    PlcReadResponse plcItems = (PlcReadResponse)this.decodeReadResponse((S7Message)response.get(), readRequest);
                    clientFuture.complete(plcItems);
                }
                catch (Exception e) {
                    this.logger.info("uh", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            this.logger.info("uh", (Throwable)e);
        }
        return clientFuture;
    }

    private CompletableFuture<S7Message> readInternal(S7Message request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        int tpduId = this.tpduGenerator.getAndIncrement();
        this.tpduGenerator.compareAndExchange(65535, 1);
        S7Message message = request instanceof S7MessageUserData ? new S7MessageUserData(tpduId, request.getParameter(), request.getPayload()) : new S7MessageRequest(tpduId, request.getParameter(), request.getPayload());
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, message, true, (byte)tpduId));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).check(p -> p.getPayload() != null).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
                this.activeRequests.remove(future);
                future.complete((S7Message)p);
                transaction.endRequest();
            });
        });
        this.activeRequests.put(future, (MutablePair<RequestTransactionManager.RequestTransaction, Object>)new MutablePair((Object)transaction, null));
        return future;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        ArrayList<S7VarRequestParameterItem> parameterItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfTags());
        ArrayList<S7VarPayloadDataItem> payloadItems = new ArrayList<S7VarPayloadDataItem>(request.getNumberOfTags());
        Iterator iter = request.getTagNames().iterator();
        String tagName = null;
        while (iter.hasNext()) {
            tagName = (String)iter.next();
            S7Tag tag = (S7Tag)request.getTag(tagName);
            PlcValue plcValue = request.getPlcValue(tagName);
            parameterItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(tag)));
            payloadItems.add(this.serializePlcValue(tag, plcValue, iter.hasNext()));
        }
        int tpduId = this.tpduGenerator.getAndIncrement();
        this.tpduGenerator.compareAndExchange(65535, 1);
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, new S7MessageRequest(tpduId, new S7ParameterWriteVarRequest(parameterItems), new S7PayloadWriteVarRequest(payloadItems)), true, (byte)tpduId));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
                try {
                    future.complete((PlcWriteResponse)this.decodeWriteResponse((S7Message)p, writeRequest));
                }
                catch (PlcProtocolException e) {
                    this.logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
                }
                transaction.endRequest();
            });
        });
        return future;
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        if (!this.isConnected()) {
            CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
            return future;
        }
        if (!this.isSubscriptionSupported()) {
            CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Not Supported"));
            return future;
        }
        CompletableFuture future = new CompletableFuture();
        HashMap valuesResponse = new HashMap();
        HashMap futures = new HashMap();
        CompletableFuture<PlcSubscriptionResponse> response = new CompletableFuture<PlcSubscriptionResponse>();
        subscriptionRequest.getTagNames().forEach(fieldname -> {
            CompletableFuture completableFuture = futures.put(fieldname, new CompletableFuture());
        });
        DefaultPlcSubscriptionRequest request = (DefaultPlcSubscriptionRequest)subscriptionRequest;
        ArrayList parameterItems = new ArrayList(request.getNumberOfTags());
        ArrayList payloadItems = new ArrayList(request.getNumberOfTags());
        CompletableFuture<Void> mainTask = CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0]));
        Thread t1 = new Thread(() -> {
            for (String tagName : request.getTagNames()) {
                DefaultPlcSubscriptionTag sf = (DefaultPlcSubscriptionTag)request.getTag(tagName);
                S7SubscriptionTag tag = (S7SubscriptionTag)sf.getTag();
                switch (tag.getTagType()) {
                    case EVENT_SUBSCRIPTION: {
                        this.encodeEventSubscriptionRequest(request, parameterItems, payloadItems);
                        break;
                    }
                    case EVENT_UNSUBSCRIPTION: {
                        break;
                    }
                    case ALARM_ACK: {
                        break;
                    }
                    case ALARM_QUERY: {
                        this.encodeAlarmQueryRequest(request, parameterItems, payloadItems);
                        break;
                    }
                    case CYCLIC_SUBSCRIPTION: {
                        this.encodeCycledS7ANYSubscriptionRequest(request.getTag(tagName), parameterItems, payloadItems);
                        break;
                    }
                    case CYCLIC_DB_SUBSCRIPTION: {
                        this.encodeCycledDBREADSubscriptionRequest(request.getTag(tagName), parameterItems, payloadItems);
                        break;
                    }
                }
                int tpduId = this.tpduGenerator.getAndIncrement();
                this.tpduGenerator.compareAndExchange(65535, 1);
                TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, new S7MessageUserData(tpduId, new S7ParameterUserData(parameterItems), new S7PayloadUserData(payloadItems)), true, (byte)tpduId));
                RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
                transaction.submit(() -> {
                    ConversationContext.ContextHandler contextHandler = this.context.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, REQUEST_TIMEOUT).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
                        try {
                            ((CompletableFuture)futures.get(tagName)).complete(p);
                        }
                        catch (Exception e) {
                            this.logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
                        }
                        transaction.endRequest();
                    });
                });
                try {
                    valuesResponse.put(tagName, this.decodeEventSubscriptionRequest(tagName, subscriptionRequest, (S7Message)((CompletableFuture)futures.get(tagName)).get()));
                }
                catch (Exception ex) {
                    this.logger.warn(ex.toString());
                }
            }
            try {
                mainTask.get();
                HashMap values = new HashMap();
                valuesResponse.forEach((s, p) -> {
                    if (p != null) {
                        values.putAll(((DefaultPlcSubscriptionResponse)p).getValues());
                    }
                });
                response.complete((PlcSubscriptionResponse)new DefaultPlcSubscriptionResponse(subscriptionRequest, values));
            }
            catch (Exception e) {
                this.logger.warn("uh", (Throwable)e);
            }
        });
        t1.start();
        return response;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        if (!this.isConnected()) {
            CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
            return future;
        }
        if (!this.isSubscriptionSupported()) {
            CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
            future.completeExceptionally((Throwable)new PlcRuntimeException("Not Supported"));
            return future;
        }
        return new CompletableFuture<PlcUnsubscriptionResponse>();
    }

    private void encodeEventSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest payload;
        short subsevent = 0;
        for (String tagName : request.getTagNames()) {
            PlcTag event;
            if (!(request.getTag(tagName) instanceof DefaultPlcSubscriptionTag) || !((event = ((DefaultPlcSubscriptionTag)request.getTag(tagName)).getTag()) instanceof S7SubscriptionTag) || ((S7SubscriptionTag)event).getTagType() != S7SubscriptionType.EVENT_SUBSCRIPTION) continue;
            subsevent = (byte)(subsevent | ((S7SubscriptionTag)event).getEventType().getValue());
        }
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 2, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        if (subsevent > 0) {
            payload = new S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 10, subsevent, "HmiRtm  ", null, null);
        } else {
            AlarmStateType alarmtype = this.s7DriverContext.getControllerType() == S7ControllerType.S7_400 ? AlarmStateType.ALARM_INITIATE : AlarmStateType.ALARM_S_INITIATE;
            short auxSubsEvent = (short)(subsevent & 0xFF);
            payload = new S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, auxSubsEvent, "HmiRtm  ", alarmtype, (short)0);
        }
        payloadItems.clear();
        payloadItems.add(payload);
    }

    private PlcSubscriptionResponse decodeEventSubscriptionRequest(String strTagName, PlcSubscriptionRequest plcSubscriptionRequest, S7Message responseMessage) throws PlcProtocolException {
        S7PayloadUserDataItem item;
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        short errorClass = 0;
        short errorCode = 0;
        if (!(responseMessage instanceof S7MessageResponse)) {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        S7MessageResponse messageResponse = (S7MessageResponse)responseMessage;
        errorClass = messageResponse.getErrorClass();
        errorCode = messageResponse.getErrorCode();
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                this.logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcSubscriptionRequest.getTagNames()) {
                    values.put(tagName, null);
                }
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            this.logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcSubscriptionRequest.getTagNames()) {
                values.put(tagName, null);
            }
            return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
        }
        S7ParameterUserData parameter = (S7ParameterUserData)responseMessage.getParameter();
        List<S7ParameterUserDataItem> parameters = parameter.getItems();
        S7ParameterUserDataItemCPUFunctions itemparameter = (S7ParameterUserDataItemCPUFunctions)parameters.get(0);
        errorCode = itemparameter.getErrorCode().shortValue();
        S7PayloadUserData payload = (S7PayloadUserData)responseMessage.getPayload();
        List<S7PayloadUserDataItem> payloadItems = payload.getItems();
        if (payloadItems.size() == 0) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        boolean responseOk = false;
        if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse) {
            item = (S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse)payloadItems.get(0);
            if (item.getReturnCode() == DataTransportErrorCode.OK && item.getTransportSize() == DataTransportSize.OCTET_STRING) {
                responseOk = true;
            }
        } else {
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionAlarmAckResponse) {
                S7PayloadUserDataItemCpuFunctionAlarmAckResponse items = (S7PayloadUserDataItemCpuFunctionAlarmAckResponse)payloadItems.get(0);
                this.logger.info("strTagName: {}", (Object)strTagName);
                values.put(strTagName, new ResponseItem(PlcResponseCode.OK, null));
                for (short s : items.getMessageObjects()) {
                    if (s == 0) {
                        values.put(Integer.toHexString(s), new ResponseItem(PlcResponseCode.OK, null));
                        continue;
                    }
                    if (s != 10) continue;
                    values.put(Integer.toHexString(s), new ResponseItem(PlcResponseCode.NOT_FOUND, null));
                }
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse) {
                this.logger.warn("Request field: {}: {} {}", new Object[]{strTagName, S7ParamErrorCode.valueOf(errorCode), S7ParamErrorCode.valueOf(errorCode).getEvent()});
                values.put(strTagName, new ResponseItem(PlcResponseCode.NOT_FOUND, null));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCpuFunctionAlarmQueryResponse) {
                S7PayloadUserDataItemCpuFunctionAlarmQueryResponse items = (S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)payloadItems.get(0);
                ByteBuf buffer = Unpooled.directBuffer((int)(items.getItems().length * 2));
                ByteBuf rxBuffer = Unpooled.directBuffer((int)(items.getItems().length * 2));
                buffer.writeBytes(items.getItems());
                if (itemparameter.getLastDataUnit() == 1) {
                    int loop = 255;
                    S7PayloadUserDataItem looppayload = null;
                    do {
                        CompletableFuture<S7MessageUserData> loopfuture = this.reassembledAlarmEvents(itemparameter.getSequenceNumber());
                        try {
                            S7MessageUserData msg = loopfuture.get();
                            if (msg != null) {
                                S7ParameterUserDataItemCPUFunctions loopparameter = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)msg.getParameter()).getItems().get(0);
                                looppayload = (S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)((S7PayloadUserData)msg.getPayload()).getItems().get(0);
                                buffer.writeBytes(((S7PayloadUserDataItemCpuFunctionAlarmQueryResponse)looppayload).getItems());
                                loop = loopparameter.getLastDataUnit().shortValue();
                                continue;
                            }
                            loop = 0;
                        }
                        catch (Exception ex) {
                            this.logger.warn(ex.toString());
                        }
                    } while (loop > 0);
                    rxBuffer.writeByte((int)looppayload.getReturnCode().getValue());
                    rxBuffer.writeByte((int)looppayload.getTransportSize().getValue());
                    rxBuffer.writeShort(looppayload.getDataLength());
                    rxBuffer.writeBytes(buffer);
                } else {
                    rxBuffer.writeByte((int)payloadItems.get(0).getReturnCode().getValue());
                    rxBuffer.writeByte((int)payloadItems.get(0).getTransportSize().getValue());
                    rxBuffer.writeShort(payloadItems.get(0).getDataLength());
                    rxBuffer.writeBytes(buffer);
                }
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(ByteBufUtil.getBytes((ByteBuf)rxBuffer));
                try {
                    short cpuSubfunction = 0;
                    cpuSubfunction = this.s7DriverContext.getControllerType() == S7ControllerType.S7_300 ? (short)19 : 240;
                    S7PayloadUserDataItem payloadItem = S7PayloadUserDataItem.staticParse((ReadBuffer)readBuffer, (byte)4, (byte)0, cpuSubfunction);
                    this.eventQueue.add(payloadItem);
                }
                catch (Exception ex) {
                    this.logger.info(ex.toString());
                }
                PlcResponseCode resCode = items.getReturnCode() == DataTransportErrorCode.OK ? PlcResponseCode.OK : PlcResponseCode.INTERNAL_ERROR;
                values.put(strTagName, new ResponseItem(resCode, null));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesSubscribeResponse) {
                S7ParameterUserDataItemCPUFunctions msgParameter = (S7ParameterUserDataItemCPUFunctions)parameter.getItems().get(0);
                S7CyclicEvent cycevent = new S7CyclicEvent(plcSubscriptionRequest, msgParameter.getSequenceNumber(), (S7PayloadUserDataItemCyclicServicesSubscribeResponse)payloadItems.get(0));
                this.eventQueue.add(cycevent);
                values.put(strTagName, new ResponseItem(PlcResponseCode.OK, (Object)this.cycHandle));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse) {
                S7ParameterUserDataItemCPUFunctions msgParameter = (S7ParameterUserDataItemCPUFunctions)parameter.getItems().get(0);
                S7CyclicEvent cycEvent = new S7CyclicEvent(plcSubscriptionRequest, msgParameter.getSequenceNumber(), (S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse)payloadItems.get(0));
                this.eventQueue.add(cycEvent);
                values.put(strTagName, new ResponseItem(PlcResponseCode.OK, (Object)this.cycHandle));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesErrorResponse) {
                this.logger.warn("Request field: " + strTagName + ": " + (Object)((Object)S7ParamErrorCode.valueOf(errorCode)) + " " + S7ParamErrorCode.valueOf(errorCode).getEvent());
                if (errorCode == 33028) {
                    values.put(strTagName, new ResponseItem(PlcResponseCode.UNSUPPORTED, null));
                } else {
                    values.put(strTagName, new ResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
                }
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
            if (payloadItems.get(0) instanceof S7PayloadUserDataItemCyclicServicesUnsubscribeResponse) {
                values.put(strTagName, new ResponseItem(PlcResponseCode.OK, null));
                return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
            }
        }
        if (responseOk) {
            for (String tagName : plcSubscriptionRequest.getTagNames()) {
                DefaultPlcSubscriptionTag dTag = (DefaultPlcSubscriptionTag)plcSubscriptionRequest.getTag(tagName);
                S7SubscriptionTag tag = (S7SubscriptionTag)dTag.getTag();
                switch (tag.getEventType()) {
                    case MODE: {
                        values.put(tagName, new ResponseItem(PlcResponseCode.OK, (Object)this.modeHandle));
                        break;
                    }
                    case SYS: {
                        values.put(tagName, new ResponseItem(PlcResponseCode.OK, (Object)this.sysHandle));
                        break;
                    }
                    case USR: {
                        values.put(tagName, new ResponseItem(PlcResponseCode.OK, (Object)this.usrHandle));
                        break;
                    }
                    case ALM: {
                        values.put(tagName, new ResponseItem(PlcResponseCode.OK, (Object)this.almHandle));
                    }
                }
            }
            return new DefaultPlcSubscriptionResponse(plcSubscriptionRequest, values);
        }
        return null;
    }

    private void encodeEventUnSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7VarRequestParameterItem> parameterItems, List<S7VarPayloadDataItem> payloadItems) {
    }

    private void encodeAlarmAckRequest(DefaultPlcReadRequest request, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 11, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        ArrayList<AlarmMessageObjectAckType> messageObjects = null;
        for (String fieldName : request.getTagNames()) {
            PlcTag field;
            if (!(request.getTag(fieldName) instanceof S7AckTag) || !((field = request.getTag(fieldName)) instanceof S7AckTag)) continue;
            ArrayList<Integer> arrAlarmIds = ((S7AckTag)field).getAlarmIds();
            ArrayList<Integer> arrAlarmSigs = ((S7AckTag)field).getAlarmSigs();
            messageObjects = new ArrayList<AlarmMessageObjectAckType>();
            boolean j = false;
            int i = 0;
            while (i < arrAlarmIds.size()) {
                BitSet bs = BitSet.valueOf(new byte[]{arrAlarmSigs.get(i).byteValue()});
                AlarmMessageObjectAckType messageObject = new AlarmMessageObjectAckType(SyntaxIdType.ALARM_ACKSET, 0, arrAlarmIds.get(i).intValue(), new State(bs.get(7), bs.get(6), bs.get(5), bs.get(4), bs.get(3), bs.get(2), bs.get(1), bs.get(0)), new State(bs.get(7), bs.get(6), bs.get(5), bs.get(4), bs.get(3), bs.get(2), bs.get(1), bs.get(0)));
                messageObjects.add(messageObject);
                ++i;
            }
        }
        S7PayloadUserDataItemCpuFunctionAlarmAckRequest payload = new S7PayloadUserDataItemCpuFunctionAlarmAckRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, messageObjects);
        payloadItems.clear();
        payloadItems.add(payload);
    }

    private void encodeAlarmQueryRequest(DefaultPlcSubscriptionRequest request, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 19, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        S7PayloadUserDataItemCpuFunctionAlarmQueryRequest payload = new S7PayloadUserDataItemCpuFunctionAlarmQueryRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, SyntaxIdType.ALARM_QUERYREQSET, QueryType.ALARM_8P, AlarmType.ALARM_8);
        payloadItems.clear();
        payloadItems.add(payload);
    }

    private void encodeCycledSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItem) {
    }

    private void encodeCycledS7ANYSubscriptionRequest(PlcSubscriptionTag plctag, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 2, 1, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        PlcTag tag = ((DefaultPlcSubscriptionTag)plctag).getTag();
        S7SubscriptionTag s7tag = (S7SubscriptionTag)tag;
        ArrayList<CycServiceItemType> items = new ArrayList<CycServiceItemType>();
        int i = 0;
        S7Tag[] s7TagArray = s7tag.getS7Tags();
        int n = s7TagArray.length;
        int n2 = 0;
        while (n2 < n) {
            S7Tag userfield = s7TagArray[n2];
            items.add(new CycServiceItemAnyType(10, 16, userfield.getDataType(), userfield.getNumberOfElements(), userfield.getBlockNumber(), userfield.getMemoryArea(), userfield.getByteOffset() << 3 | userfield.getBitOffset() & 7));
            ++i;
            ++n2;
        }
        int lengthInBytes = 4 + items.size() * 12;
        S7PayloadUserDataItemCyclicServicesSubscribeRequest payload = new S7PayloadUserDataItemCyclicServicesSubscribeRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, lengthInBytes, items.size(), s7tag.getTimeBase(), s7tag.getMultiplier(), items);
        payloadItems.clear();
        payloadItems.add(payload);
    }

    private void encodeCycledDBREADSubscriptionRequest(PlcSubscriptionTag plctag, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 2, 1, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        PlcTag tag = ((DefaultPlcSubscriptionTag)plctag).getTag();
        S7SubscriptionTag s7tag = (S7SubscriptionTag)tag;
        double cycitemcount = Math.ceil((double)s7tag.getS7Tags().length / 50.0);
        ArrayList<CycServiceItemType> cycitems = new ArrayList<CycServiceItemType>();
        ArrayList<SubItem> subitems = new ArrayList<SubItem>();
        S7Tag[] s7TagArray = s7tag.getS7Tags();
        int n = s7TagArray.length;
        int n2 = 0;
        while (n2 < n) {
            S7Tag userfield = s7TagArray[n2];
            subitems.add(new SubItem((short)userfield.getNumberOfElements(), userfield.getBlockNumber(), userfield.getByteOffset()));
            ++n2;
        }
        int initpos = 0;
        int endpos = subitems.size() < 50 ? subitems.size() : 49;
        int j = 0;
        int lengthInBytes = 4;
        do {
            List<SubItem> arraysubitems = subitems.subList(initpos, endpos);
            cycitems.add(j, new CycServiceItemDbReadType((short)(arraysubitems.size() * 5 + 2), 176, (short)arraysubitems.size(), arraysubitems));
            lengthInBytes += 4 + arraysubitems.size() * 5;
            initpos = endpos++;
            int n3 = endpos = initpos + 49 < subitems.size() ? initpos + 49 : subitems.size();
        } while (++j < cycitems.size());
        S7PayloadUserDataItemCyclicServicesSubscribeRequest payload = new S7PayloadUserDataItemCyclicServicesSubscribeRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, lengthInBytes, cycitems.size(), s7tag.getTimeBase(), s7tag.getMultiplier(), cycitems);
        payloadItems.clear();
        payloadItems.add(payload);
    }

    private void encodeCycledUnSubscriptionRequest(DefaultPlcSubscriptionRequest request, List<S7ParameterUserDataItem> parameterItems, List<S7PayloadUserDataItem> payloadItems) {
        S7ParameterUserDataItemCPUFunctions parameter = new S7ParameterUserDataItemCPUFunctions(17, 4, 2, 4, 0, null, null, null);
        parameterItems.clear();
        parameterItems.add(parameter);
        PlcSubscriptionTag tag = (PlcSubscriptionTag)request.getTags().get(0);
        S7SubscriptionTag s7tag = (S7SubscriptionTag)tag;
        S7PayloadUserDataItemCyclicServicesUnsubscribeRequest payload = new S7PayloadUserDataItemCyclicServicesUnsubscribeRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 2, 5, s7tag.getAckAlarms().get(0).byteValue());
        payloadItems.clear();
        payloadItems.add(payload);
    }

    protected void decode(ConversationContext<TPKTPacket> context, TPKTPacket msg) throws Exception {
        S7Message s7msg = msg.getPayload().getPayload();
        S7Parameter parameter = s7msg.getParameter();
        if (parameter instanceof S7ParameterModeTransition) {
            this.eventQueue.add(parameter);
        } else if (parameter instanceof S7ParameterUserData) {
            S7ParameterUserData parameterud = (S7ParameterUserData)parameter;
            List<S7ParameterUserDataItem> parameterudis = parameterud.getItems();
            for (S7ParameterUserDataItem parameterudi : parameterudis) {
                S7PayloadUserData payload;
                List<S7PayloadUserDataItem> items;
                S7PayloadUserData payload2;
                if (!(parameterudi instanceof S7ParameterUserDataItemCPUFunctions)) continue;
                S7ParameterUserDataItemCPUFunctions myparameter = (S7ParameterUserDataItemCPUFunctions)parameterudi;
                if (myparameter.getCpuFunctionType() == 0 && myparameter.getCpuSubfunction() == 3) {
                    payload2 = (S7PayloadUserData)s7msg.getPayload();
                    items = payload2.getItems();
                    for (S7PayloadUserDataItem item : items) {
                        if (!(item instanceof S7PayloadDiagnosticMessage)) continue;
                        this.eventQueue.add(item);
                    }
                    continue;
                }
                if (myparameter.getCpuFunctionType() == 0 && (myparameter.getCpuSubfunction() == 5 || myparameter.getCpuSubfunction() == 6 || myparameter.getCpuSubfunction() == 12 || myparameter.getCpuSubfunction() == 17 || myparameter.getCpuSubfunction() == 18 || myparameter.getCpuSubfunction() == 19 || myparameter.getCpuSubfunction() == 22)) {
                    payload2 = (S7PayloadUserData)s7msg.getPayload();
                    items = payload2.getItems();
                    this.eventQueue.addAll(items);
                    continue;
                }
                if (myparameter.getCpuFunctionType() == 0 && myparameter.getCpuSubfunction() == 19) continue;
                if (myparameter.getCpuFunctionGroup() == 2 && myparameter.getCpuFunctionType() == 0 && myparameter.getCpuSubfunction() == 1) {
                    S7ParameterUserDataItemCPUFunctions parameteritem = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)parameter).getItems().get(0);
                    payload = (S7PayloadUserData)s7msg.getPayload();
                    S7PayloadUserDataItemCyclicServicesPush payloaditem = (S7PayloadUserDataItemCyclicServicesPush)payload.getItems().get(0);
                    S7CyclicEvent cycevent = new S7CyclicEvent(null, parameteritem.getSequenceNumber(), payloaditem);
                    this.eventQueue.add(cycevent);
                    continue;
                }
                if (myparameter.getCpuFunctionGroup() == 2 && myparameter.getCpuFunctionType() == 0 && myparameter.getCpuSubfunction() == 5) {
                    S7ParameterUserDataItemCPUFunctions parameterItem = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)parameter).getItems().get(0);
                    payload = (S7PayloadUserData)s7msg.getPayload();
                    S7PayloadUserDataItemCyclicServicesChangeDrivenPush payloadItem = (S7PayloadUserDataItemCyclicServicesChangeDrivenPush)payload.getItems().get(0);
                    S7CyclicEvent cycEvent = new S7CyclicEvent(null, parameterItem.getSequenceNumber(), payloadItem);
                    this.eventQueue.add(cycEvent);
                    continue;
                }
                if (myparameter.getCpuFunctionType() == 8 && myparameter.getCpuSubfunction() == 1 || myparameter.getCpuFunctionType() != 8) continue;
                myparameter.getCpuSubfunction();
            }
        }
    }

    public void close(ConversationContext<TPKTPacket> context) {
        this.EventLogic.stop();
    }

    private void extractControllerTypeAndFireConnected(ConversationContext<TPKTPacket> context, S7PayloadUserData payloadUserData) {
        for (S7PayloadUserDataItem item : payloadUserData.getItems()) {
            if (!(item instanceof S7PayloadUserDataItemCpuFunctionReadSzlResponse)) continue;
            S7PayloadUserDataItemCpuFunctionReadSzlResponse readSzlResponseItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)item;
            ByteBuf szlitem = Unpooled.wrappedBuffer((byte[])readSzlResponseItem.getItems());
            String articleNumber = szlitem.toString(2, 20, Charset.defaultCharset());
            this.s7DriverContext.setControllerType(this.decodeControllerType(articleNumber));
            context.fireConnected();
        }
    }

    private TPKTPacket createIdentifyRemoteMessage() {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(1, new S7ParameterUserData(Collections.singletonList(new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 1, 0, null, null, null))), new S7PayloadUserData(Collections.singletonList(new S7PayloadUserDataItemCpuFunctionReadSzlRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, new SzlId(SzlModuleTypeClass.CPU, 0, SzlSublist.MODULE_IDENTIFICATION), 0))));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2);
        return new TPKTPacket(cotpPacketData);
    }

    private TPKTPacket createS7ConnectionRequest(COTPPacketConnectionResponse cotpPacketConnectionResponse) {
        for (COTPParameter parameter : cotpPacketConnectionResponse.getParameters()) {
            if (parameter instanceof COTPParameterCalledTsap) {
                COTPParameterCalledTsap cotpParameterCalledTsap = (COTPParameterCalledTsap)parameter;
                this.s7DriverContext.setCalledTsapId(cotpParameterCalledTsap.getTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterCallingTsap) {
                COTPParameterCallingTsap cotpParameterCallingTsap = (COTPParameterCallingTsap)parameter;
                if (cotpParameterCallingTsap.getTsapId() == this.s7DriverContext.getCallingTsapId()) continue;
                this.s7DriverContext.setCallingTsapId(cotpParameterCallingTsap.getTsapId());
                this.logger.warn("Switching calling TSAP id to '{}'", (Object)this.s7DriverContext.getCallingTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterTpduSize) {
                COTPParameterTpduSize cotpParameterTpduSize = (COTPParameterTpduSize)parameter;
                this.s7DriverContext.setCotpTpduSize(cotpParameterTpduSize.getTpduSize());
                continue;
            }
            this.logger.warn("Got unknown parameter type '{}'", (Object)parameter.getClass().getName());
        }
        S7ParameterSetupCommunication s7ParameterSetupCommunication = new S7ParameterSetupCommunication(this.s7DriverContext.getMaxAmqCaller(), this.s7DriverContext.getMaxAmqCallee(), this.s7DriverContext.getPduSize());
        S7MessageRequest s7Message = new S7MessageRequest(0, s7ParameterSetupCommunication, null);
        COTPPacketData cotpPacketData = new COTPPacketData(null, s7Message, true, 1);
        return new TPKTPacket(cotpPacketData);
    }

    private COTPPacketConnectionRequest createCOTPConnectionRequest(int calledTsapId, int callingTsapId, COTPTpduSize cotpTpduSize) {
        return new COTPPacketConnectionRequest(Arrays.asList(new COTPParameterCallingTsap(callingTsapId), new COTPParameterCalledTsap(calledTsapId), new COTPParameterTpduSize(cotpTpduSize)), null, 0, 15, COTPProtocolClass.CLASS_0);
    }

    private PlcResponse decodeReadResponse(S7Message responseMessage, PlcReadRequest plcReadRequest) throws PlcProtocolException {
        List<Object> payloadItems;
        S7Payload payload;
        S7Message messageResponse;
        short errorCode;
        short errorClass;
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        S7ParameterUserDataItemCPUFunctions parameteritem = null;
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            messageResponse = (S7MessageResponse)responseMessage;
            errorClass = ((S7MessageResponse)messageResponse).getErrorClass();
            errorCode = ((S7MessageResponse)messageResponse).getErrorCode();
        } else if (responseMessage instanceof S7MessageUserData) {
            messageResponse = (S7MessageUserData)responseMessage;
            Iterator parameters = (S7ParameterUserData)messageResponse.getParameter();
            parameteritem = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)((Object)parameters)).getItems().get(0);
            errorClass = 0;
            errorCode = parameteritem.getErrorCode().shortValue();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                this.logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcReadRequest.getTagNames()) {
                    ResponseItem result = new ResponseItem(PlcResponseCode.ACCESS_DENIED, (Object)new PlcNull());
                    values.put(tagName, result);
                }
                return new DefaultPlcReadResponse(plcReadRequest, values);
            }
            this.logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcReadRequest.getTagNames()) {
                ResponseItem result = new ResponseItem(PlcResponseCode.INTERNAL_ERROR, (Object)new PlcNull());
                values.put(tagName, result);
            }
            return new DefaultPlcReadResponse(plcReadRequest, values);
        }
        if (responseMessage instanceof S7MessageUserData) {
            payload = (S7PayloadUserData)responseMessage.getPayload();
            if (plcReadRequest.getNumberOfTags() != ((S7PayloadUserData)payload).getItems().size()) {
                throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
            }
            payloadItems = ((S7PayloadUserData)payload).getItems();
            PlcResponseCode responseCode = PlcResponseCode.INTERNAL_ERROR;
            PlcList plcValue = null;
            int index = 0;
            for (String tagName : plcReadRequest.getTagNames()) {
                Object data;
                S7PayloadUserDataItemCpuFunctionReadSzlResponse payloadItem;
                if (plcReadRequest.getTag(tagName) instanceof S7SzlTag && (responseCode = this.decodeResponseCode((payloadItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)payloadItems.get(index)).getReturnCode())) == PlcResponseCode.OK) {
                    try {
                        LinkedList<PlcSINT> plcvalues = new LinkedList<PlcSINT>();
                        data = payloadItem.getItems();
                        byte[] byArray = data;
                        int n = ((byte[])data).length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            plcvalues.add(new PlcSINT(b));
                            ++n2;
                        }
                        if (parameteritem.getLastDataUnit() == 1) {
                            while (parameteritem.getLastDataUnit() == 1) {
                                CompletableFuture<S7MessageUserData> nextFuture = this.reassembledMessage(parameteritem.getSequenceNumber());
                                S7MessageUserData msg = nextFuture.get();
                                if (msg != null) {
                                    S7ParameterUserData next_parameter = (S7ParameterUserData)msg.getParameter();
                                    parameteritem = (S7ParameterUserDataItemCPUFunctions)next_parameter.getItems().get(0);
                                    S7PayloadUserData next_payload = (S7PayloadUserData)msg.getPayload();
                                    S7PayloadUserDataItemCpuFunctionReadSzlResponse next_payloadItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)next_payload.getItems().get(0);
                                    byte[] byArray2 = next_payloadItem.getItems();
                                    int n3 = byArray2.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        byte b = byArray2[n4];
                                        plcvalues.add(new PlcSINT(b));
                                        ++n4;
                                    }
                                }
                                plcValue = new PlcList(plcvalues);
                            }
                        } else {
                            plcValue = new PlcList(plcvalues);
                        }
                    }
                    catch (Exception e) {
                        throw new PlcProtocolException("Error decoding PlcValue", (Throwable)e);
                    }
                }
                if (plcReadRequest.getTag(tagName) instanceof S7AckTag) {
                    S7AckTag field = (S7AckTag)plcReadRequest.getTag(tagName);
                    S7PayloadUserDataItemCpuFunctionAlarmAckResponse payloadItem2 = (S7PayloadUserDataItemCpuFunctionAlarmAckResponse)payloadItems.get(index);
                    responseCode = this.decodeResponseCode(payloadItem2.getReturnCode());
                    data = payloadItem2.getMessageObjects();
                    LinkedList<PlcSINT> plcValues = new LinkedList<PlcSINT>();
                    Iterator iterator = data.iterator();
                    while (iterator.hasNext()) {
                        short b = (Short)iterator.next();
                        plcValues.add(new PlcSINT((byte)b));
                    }
                    plcValue = new PlcList(plcValues);
                }
                ResponseItem result = new ResponseItem(responseCode, plcValue);
                values.put(tagName, result);
                ++index;
            }
            return new DefaultPlcReadResponse(plcReadRequest, values);
        }
        payload = (S7PayloadReadVarResponse)responseMessage.getPayload();
        if (plcReadRequest.getNumberOfTags() != ((S7PayloadReadVarResponse)payload).getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        payloadItems = ((S7PayloadReadVarResponse)payload).getItems();
        int index = 0;
        for (String tagName : plcReadRequest.getTagNames()) {
            S7Tag tag = (S7Tag)plcReadRequest.getTag(tagName);
            S7VarPayloadDataItem payloadItem = (S7VarPayloadDataItem)payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            PlcValue plcValue = null;
            ByteBuf data = Unpooled.wrappedBuffer((byte[])payloadItem.getData());
            if (responseCode == PlcResponseCode.OK) {
                try {
                    plcValue = this.parsePlcValue(tag, data);
                }
                catch (Exception e) {
                    throw new PlcProtocolException("Error decoding PlcValue", (Throwable)e);
                }
            }
            ResponseItem result = new ResponseItem(responseCode, plcValue);
            values.put(tagName, result);
            ++index;
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    private PlcResponse decodeWriteResponse(S7Message responseMessage, PlcWriteRequest plcWriteRequest) throws PlcProtocolException {
        short errorCode;
        short errorClass;
        HashMap<String, PlcResponseCode> responses = new HashMap<String, PlcResponseCode>();
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            S7MessageResponse messageResponse = (S7MessageResponse)responseMessage;
            errorClass = messageResponse.getErrorClass();
            errorCode = messageResponse.getErrorCode();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                this.logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcWriteRequest.getTagNames()) {
                    responses.put(tagName, PlcResponseCode.ACCESS_DENIED);
                }
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            this.logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcWriteRequest.getTagNames()) {
                responses.put(tagName, PlcResponseCode.INTERNAL_ERROR);
            }
            return new DefaultPlcWriteResponse(plcWriteRequest, responses);
        }
        S7PayloadWriteVarResponse payload = (S7PayloadWriteVarResponse)responseMessage.getPayload();
        if (plcWriteRequest.getNumberOfTags() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        List<S7VarPayloadStatusItem> payloadItems = payload.getItems();
        int index = 0;
        for (String tagName : plcWriteRequest.getTagNames()) {
            S7VarPayloadStatusItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            responses.put(tagName, responseCode);
            ++index;
        }
        return new DefaultPlcWriteResponse(plcWriteRequest, responses);
    }

    private S7VarPayloadDataItem serializePlcValue(S7Tag tag, PlcValue plcValue, Boolean hasNext) {
        try {
            DataTransportSize transportSize = tag.getDataType().getDataTransportSize();
            int stringLength = tag instanceof S7StringTag ? ((S7StringTag)tag).getStringLength() : 254;
            ByteBuffer byteBuffer = null;
            int i = 0;
            while (i < tag.getNumberOfElements()) {
                int lengthInBits = DataItem.getLengthInBits(plcValue.getIndex(i), tag.getDataType().getDataProtocolId(), stringLength);
                WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil((float)lengthInBits / 8.0f));
                DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue.getIndex(i), tag.getDataType().getDataProtocolId(), stringLength);
                if (byteBuffer == null) {
                    byteBuffer = ByteBuffer.allocate(writeBuffer.getBytes().length * tag.getNumberOfElements());
                }
                byteBuffer.put(writeBuffer.getBytes());
                ++i;
            }
            if (byteBuffer != null) {
                byte[] data = byteBuffer.array();
                return new S7VarPayloadDataItem(DataTransportErrorCode.OK, transportSize, data);
            }
        }
        catch (SerializationException e) {
            this.logger.warn("Error serializing tag item of type: '{}'", (Object)tag.getDataType().name(), (Object)e);
        }
        return null;
    }

    private PlcValue parsePlcValue(S7Tag tag, ByteBuf data) {
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data.array());
        try {
            int stringLength;
            int n = stringLength = tag instanceof S7StringTag ? ((S7StringTag)tag).getStringLength() : 254;
            if (tag.getNumberOfElements() == 1) {
                return DataItem.staticParse((ReadBuffer)readBuffer, tag.getDataType().getDataProtocolId(), stringLength);
            }
            Object[] resultItems = (PlcValue[])IntStream.range(0, tag.getNumberOfElements()).mapToObj(arg_0 -> this.lambda$39((ReadBuffer)readBuffer, tag, stringLength, arg_0)).toArray(PlcValue[]::new);
            return PlcValueHandler.of((Object[])resultItems);
        }
        catch (ParseException e) {
            this.logger.warn("Error parsing tag item of type: '{}'", (Object)tag.getDataType().name(), (Object)e);
            return null;
        }
    }

    private PlcResponseCode decodeResponseCode(DataTransportErrorCode dataTransportErrorCode) {
        if (dataTransportErrorCode == null) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        switch (dataTransportErrorCode) {
            case OK: {
                return PlcResponseCode.OK;
            }
            case NOT_FOUND: {
                return PlcResponseCode.NOT_FOUND;
            }
            case INVALID_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case DATA_TYPE_NOT_SUPPORTED: {
                return PlcResponseCode.INVALID_DATATYPE;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private S7ControllerType decodeControllerType(String articleNumber) {
        String model;
        if (!articleNumber.startsWith("6ES7 ")) {
            return S7ControllerType.ANY;
        }
        switch (model = articleNumber.substring(articleNumber.indexOf(32) + 1, articleNumber.indexOf(32) + 2)) {
            case "2": {
                return S7ControllerType.S7_1200;
            }
            case "5": {
                return S7ControllerType.S7_1500;
            }
            case "3": {
                return S7ControllerType.S7_300;
            }
            case "4": {
                return S7ControllerType.S7_400;
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Looking up unknown article number {}", (Object)articleNumber);
        }
        return S7ControllerType.ANY;
    }

    protected S7Address encodeS7Address(PlcTag tag) {
        if (!(tag instanceof S7Tag)) {
            throw new PlcRuntimeException("Unsupported address type " + tag.getClass().getName());
        }
        S7Tag s7Tag = (S7Tag)tag;
        TransportSize transportSize = s7Tag.getDataType();
        int numElements = s7Tag.getNumberOfElements();
        if (transportSize == TransportSize.TIME || transportSize == TransportSize.LTIME || transportSize == TransportSize.DATE || transportSize == TransportSize.TIME_OF_DAY || transportSize == TransportSize.DATE_AND_TIME) {
            numElements *= transportSize.getSizeInBytes();
            transportSize = TransportSize.BYTE;
        }
        if (transportSize == TransportSize.STRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Tag instanceof S7StringTag ? ((S7StringTag)s7Tag).getStringLength() : 254;
            numElements *= stringLength + 2;
        } else if (transportSize == TransportSize.WSTRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Tag instanceof S7StringTag ? ((S7StringTag)s7Tag).getStringLength() : 254;
            numElements = numElements * (stringLength + 2) * 2;
        }
        return new S7AddressAny(transportSize, numElements, s7Tag.getBlockNumber(), s7Tag.getMemoryArea(), s7Tag.getByteOffset(), s7Tag.getBitOffset());
    }

    private void cleanFutures() {
        this.activeRequests.forEach((f, p) -> {
            CompletableFuture cf = (CompletableFuture)f;
            try {
                if (!cf.isDone()) {
                    this.logger.info("CF");
                    cf.cancel(true);
                    this.logger.info("ClientCF");
                    ((CompletableFuture)p.getRight()).completeExceptionally((Throwable)new PlcRuntimeException("Disconnected"));
                    this.logger.info("TM");
                    ((RequestTransactionManager.RequestTransaction)p.getLeft()).endRequest();
                }
            }
            catch (Exception ex) {
                this.logger.info(ex.toString());
            }
        });
        this.activeRequests.clear();
    }

    private boolean isConnected() {
        return (Boolean)this.context.getChannel().attr(S7HMuxImpl.IS_CONNECTED).get();
    }

    private boolean isPrimaryChannel() {
        return this.context.getChannel().attr(S7HMuxImpl.IS_PRIMARY).get() == null || (Boolean)this.context.getChannel().attr(S7HMuxImpl.IS_PRIMARY).get() != false;
    }

    private void setChannelFeatures() {
        this.context.getChannel().attr(S7HMuxImpl.READ_TIME_OUT).set((Object)this.s7DriverContext.getReadTimeout());
        this.context.getChannel().attr(S7HMuxImpl.IS_PING_ACTIVE).set((Object)this.s7DriverContext.getPing());
        this.context.getChannel().attr(S7HMuxImpl.PING_TIME).set((Object)this.s7DriverContext.getPingTime());
        this.context.getChannel().attr(S7HMuxImpl.RETRY_TIME).set((Object)this.s7DriverContext.getRetryTime());
    }

    private boolean isSubscriptionSupported() {
        return this.s7DriverContext.getControllerType() == S7ControllerType.S7_300 || this.s7DriverContext.getControllerType() == S7ControllerType.S7_400;
    }

    private CompletableFuture<S7MessageUserData> reassembledMessage(short sequenceNumber) {
        CompletableFuture<S7MessageUserData> future = new CompletableFuture<S7MessageUserData>();
        int tpduId = this.tpduGenerator.getAndIncrement();
        this.tpduGenerator.compareAndExchange(65535, 1);
        TPKTPacket request = this.createSzlReassembledRequest(tpduId, sequenceNumber);
        this.context.sendRequest((Object)request).onTimeout(e -> this.logger.warn("Timeout during Connection establishing, closing channel...")).expectResponse(TPKTPacket.class, Duration.ofMillis(1000L)).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).check(p -> p.getPayload() instanceof S7MessageUserData).unwrap(p -> (S7MessageUserData)p.getPayload()).check(p -> p.getPayload() instanceof S7PayloadUserData).handle(future::complete);
        return future;
    }

    private TPKTPacket createSzlReassembledRequest(int tpduId, short sequenceNumber) {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(tpduId, new S7ParameterUserData(Arrays.asList(new S7ParameterUserDataItemCPUFunctions(18, 4, 4, 1, sequenceNumber, (short)0, (short)0, 0))), new S7PayloadUserData(Arrays.asList(new S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest(DataTransportErrorCode.NOT_FOUND, DataTransportSize.NULL, 0))));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2);
        return new TPKTPacket(cotpPacketData);
    }

    private CompletableFuture<S7MessageUserData> reassembledAlarmEvents(short sequenceNumber) {
        CompletableFuture<S7MessageUserData> future = new CompletableFuture<S7MessageUserData>();
        int tpduId = this.tpduGenerator.getAndIncrement();
        this.tpduGenerator.compareAndExchange(65535, 1);
        TPKTPacket request = this.createAlarmQueryReassembledRequest(tpduId, sequenceNumber);
        this.context.sendRequest((Object)request).onTimeout(e -> this.logger.warn("Timeout during Connection establishing, closing channel...")).expectResponse(TPKTPacket.class, Duration.ofMillis(1000L)).check(p -> p.getPayload() instanceof COTPPacketData).unwrap(p -> (COTPPacketData)p.getPayload()).check(p -> p.getPayload() instanceof S7MessageUserData).unwrap(p -> (S7MessageUserData)p.getPayload()).check(p -> p.getPayload() instanceof S7PayloadUserData).handle(future::complete);
        return future;
    }

    private TPKTPacket createAlarmQueryReassembledRequest(int tpduId, short sequenceNumber) {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(tpduId, new S7ParameterUserData(Arrays.asList(new S7ParameterUserDataItemCPUFunctions(18, 4, 4, 19, sequenceNumber, (short)0, (short)0, 0))), new S7PayloadUserData(Arrays.asList(new S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest(DataTransportErrorCode.NOT_FOUND, DataTransportSize.NULL, 0))));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2);
        return new TPKTPacket(cotpPacketData);
    }

    private /* synthetic */ PlcValue lambda$39(ReadBuffer readBuffer, S7Tag s7Tag, int n, int i) {
        try {
            return DataItem.staticParse(readBuffer, s7Tag.getDataType().getDataProtocolId(), n);
        }
        catch (ParseException e) {
            this.logger.warn("Error parsing tag item of type: '{}' (at position {}})", new Object[]{s7Tag.getDataType().name(), i, e});
            return null;
        }
    }

    static class TransactionErrorCallback<T, E extends Throwable>
    implements Consumer<TimeoutException>,
    BiConsumer<TPKTPacket, E> {
        private final CompletableFuture<T> future;
        private final RequestTransactionManager.RequestTransaction transaction;

        TransactionErrorCallback(CompletableFuture<T> future, RequestTransactionManager.RequestTransaction transaction) {
            this.future = future;
            this.transaction = transaction;
        }

        @Override
        public void accept(TimeoutException e) {
            this.transaction.endRequest();
            this.future.completeExceptionally(e);
        }

        @Override
        public void accept(TPKTPacket tpktPacket, E e) {
            this.transaction.endRequest();
            this.future.completeExceptionally((Throwable)e);
        }
    }
}

