/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.tag;

import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class S7StringTag
extends S7Tag {
    private final int stringLength;

    protected S7StringTag(TransportSize dataType, MemoryArea memoryArea, int blockNumber, int byteOffset, byte bitOffset, int numElements, int stringLength) {
        super(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        this.stringLength = stringLength;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String memoryArea = this.getMemoryArea().name();
        writeBuffer.writeString("memoryArea", memoryArea.getBytes(StandardCharsets.UTF_8).length * 8, memoryArea, new WithWriterArgs[]{WithOption.WithEncoding((String)StandardCharsets.UTF_8.name())});
        writeBuffer.writeUnsignedInt("blockNumber", 16, this.getBlockNumber(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("byteOffset", 16, this.getByteOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("bitOffset", 8, (int)this.getBitOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("numElements", 16, this.getNumberOfElements(), new WithWriterArgs[0]);
        writeBuffer.writeInt("stringLength", 64, this.getStringLength(), new WithWriterArgs[0]);
        String dataType = this.getDataType().name();
        writeBuffer.writeString("dataType", dataType.getBytes(StandardCharsets.UTF_8).length * 8, dataType, new WithWriterArgs[]{WithOption.WithEncoding((String)StandardCharsets.UTF_8.name())});
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

