/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.tag;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringTag;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;
import org.apache.plc4x.java.spi.utils.Serializable;

public class S7Tag
implements PlcTag,
Serializable {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^%(?<memoryArea>.)(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_ADDRESS_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}).DB(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_SHORT_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}):(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_STRING_ADDRESS_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}).DB(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>STRING|WSTRING)\\((?<stringLength>\\d{1,3})\\)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_STRING_SHORT_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}):(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>STRING|WSTRING)\\((?<stringLength>\\d{1,3})\\)(\\[(?<numElements>\\d+)])?");
    private static final Pattern PLC_PROXY_ADDRESS_PATTERN = Pattern.compile("[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}");
    private static final String DATA_TYPE = "dataType";
    private static final String STRING_LENGTH = "stringLength";
    private static final String TRANSFER_SIZE_CODE = "transferSizeCode";
    private static final String BLOCK_NUMBER = "blockNumber";
    private static final String BYTE_OFFSET = "byteOffset";
    private static final String BIT_OFFSET = "bitOffset";
    private static final String NUM_ELEMENTS = "numElements";
    private static final String MEMORY_AREA = "memoryArea";
    private final TransportSize dataType;
    private final MemoryArea memoryArea;
    private final int blockNumber;
    private final int byteOffset;
    private final byte bitOffset;
    private final int numElements;

    protected S7Tag(TransportSize dataType, MemoryArea memoryArea, int blockNumber, int byteOffset, byte bitOffset, int numElements) {
        this.dataType = dataType;
        this.memoryArea = memoryArea;
        this.blockNumber = blockNumber;
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.numElements = numElements;
    }

    public String getAddressString() {
        return null;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.valueOf((String)this.dataType.name());
    }

    public List<ArrayInfo> getArrayInfo() {
        if (this.numElements != 1) {
            return Collections.singletonList(new DefaultArrayInfo(0, this.numElements));
        }
        return Collections.emptyList();
    }

    public TransportSize getDataType() {
        return this.dataType;
    }

    public String getPlcDataType() {
        return this.dataType.toString();
    }

    public MemoryArea getMemoryArea() {
        return this.memoryArea;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public byte getBitOffset() {
        return this.bitOffset;
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public static boolean matches(String tagString) {
        return DATA_BLOCK_STRING_ADDRESS_PATTERN.matcher(tagString).matches() || DATA_BLOCK_STRING_SHORT_PATTERN.matcher(tagString).matches() || DATA_BLOCK_ADDRESS_PATTERN.matcher(tagString).matches() || DATA_BLOCK_SHORT_PATTERN.matcher(tagString).matches() || PLC_PROXY_ADDRESS_PATTERN.matcher(tagString).matches() || ADDRESS_PATTERN.matcher(tagString).matches();
    }

    public static S7Tag of(String tagString) {
        Matcher matcher = DATA_BLOCK_STRING_ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            int stringLength = Integer.parseInt(matcher.group(STRING_LENGTH));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7Tag.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            Short transferSizeCode = S7Tag.getSizeCode(matcher.group(TRANSFER_SIZE_CODE));
            int byteOffset = S7Tag.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidTagException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            if (transferSizeCode != null && dataType.getShortName() != transferSizeCode.shortValue()) {
                throw new PlcInvalidTagException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            return new S7StringTag(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements, stringLength);
        }
        matcher = DATA_BLOCK_STRING_SHORT_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            int stringLength = Integer.parseInt(matcher.group(STRING_LENGTH));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7Tag.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            int byteOffset = S7Tag.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            return new S7StringTag(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements, stringLength);
        }
        matcher = DATA_BLOCK_ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            Short transferSizeCode = S7Tag.getSizeCode(matcher.group(TRANSFER_SIZE_CODE));
            int blockNumber = S7Tag.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            int byteOffset = S7Tag.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidTagException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            if (transferSizeCode != null && dataType.getShortName() != transferSizeCode.shortValue()) {
                throw new PlcInvalidTagException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            return new S7Tag(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        }
        matcher = DATA_BLOCK_SHORT_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7Tag.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            int byteOffset = S7Tag.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidTagException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            return new S7Tag(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        }
        if (PLC_PROXY_ADDRESS_PATTERN.matcher(tagString).matches()) {
            try {
                byte[] addressData = Hex.decodeHex((String)tagString.replaceAll("[-]", ""));
                ReadBufferByteBased rb = new ReadBufferByteBased(addressData);
                S7Address s7Address = S7Address.staticParse((ReadBuffer)rb);
                if (s7Address instanceof S7AddressAny) {
                    S7AddressAny s7AddressAny = (S7AddressAny)s7Address;
                    if (s7AddressAny.getTransportSize() != TransportSize.BOOL && s7AddressAny.getBitAddress() != 0) {
                        throw new PlcInvalidTagException("A bit offset other than 0 is only supported for type BOOL");
                    }
                    return new S7Tag(s7AddressAny.getTransportSize(), s7AddressAny.getArea(), s7AddressAny.getDbNumber(), s7AddressAny.getByteAddress(), s7AddressAny.getBitAddress(), s7AddressAny.getNumberOfElements());
                }
                throw new PlcInvalidTagException("Unsupported address type.");
            }
            catch (DecoderException | ParseException e) {
                throw new PlcInvalidTagException("Unable to parse address: " + tagString);
            }
        }
        matcher = ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = S7Tag.getMemoryAreaForShortName(matcher.group(MEMORY_AREA));
            Short transferSizeCode = S7Tag.getSizeCode(matcher.group(TRANSFER_SIZE_CODE));
            int byteOffset = S7Tag.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidTagException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            if (transferSizeCode != null && dataType.getShortName() != transferSizeCode.shortValue()) {
                throw new PlcInvalidTagException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            if (dataType != TransportSize.BOOL && bitOffset != 0) {
                throw new PlcInvalidTagException("A bit offset other than 0 is only supported for type BOOL");
            }
            return new S7Tag(dataType, memoryArea, 0, byteOffset, bitOffset, numElements);
        }
        throw new PlcInvalidTagException("Unable to parse address: " + tagString);
    }

    private static int checkDatablockNumber(int blockNumber) {
        if (blockNumber > 64000 || blockNumber < 1) {
            throw new PlcInvalidTagException("Datablock numbers larger than 64000 or smaller than 1 are not supported.");
        }
        return blockNumber;
    }

    private static int checkByteOffset(int byteOffset) {
        if (byteOffset > 0x1FFFFF || byteOffset < 0) {
            throw new PlcInvalidTagException("ByteOffset must be smaller than 2097151 and positive.");
        }
        return byteOffset;
    }

    protected static Short getSizeCode(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.length() > 1) {
            return null;
        }
        return value.getBytes()[0];
    }

    protected static MemoryArea getMemoryAreaForShortName(String shortName) {
        MemoryArea[] memoryAreaArray = MemoryArea.values();
        int n = memoryAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryArea memoryArea = memoryAreaArray[n2];
            if (memoryArea.getShortName().equals(shortName)) {
                return memoryArea;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return "S7Tag{dataType=" + (Object)((Object)this.dataType) + ", memoryArea=" + (Object)((Object)this.memoryArea) + ", blockNumber=" + this.blockNumber + ", byteOffset=" + this.byteOffset + ", bitOffset=" + this.bitOffset + ", numElements=" + this.numElements + '}';
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String memoryArea = this.getMemoryArea().name();
        writeBuffer.writeString(MEMORY_AREA, memoryArea.getBytes(StandardCharsets.UTF_8).length * 8, memoryArea, new WithWriterArgs[]{WithOption.WithEncoding((String)StandardCharsets.UTF_8.name())});
        writeBuffer.writeUnsignedInt(BLOCK_NUMBER, 16, this.getBlockNumber(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt(BYTE_OFFSET, 16, this.getByteOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt(BIT_OFFSET, 8, (int)this.getBitOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt(NUM_ELEMENTS, 16, this.getNumberOfElements(), new WithWriterArgs[0]);
        String dataType = this.getDataType().name();
        writeBuffer.writeString(DATA_TYPE, dataType.getBytes(StandardCharsets.UTF_8).length * 8, dataType, new WithWriterArgs[]{WithOption.WithEncoding((String)StandardCharsets.UTF_8.name())});
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

