/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class State implements Message {

  // Properties.
  protected final boolean SIG_8;
  protected final boolean SIG_7;
  protected final boolean SIG_6;
  protected final boolean SIG_5;
  protected final boolean SIG_4;
  protected final boolean SIG_3;
  protected final boolean SIG_2;
  protected final boolean SIG_1;

  public State(
      boolean SIG_8,
      boolean SIG_7,
      boolean SIG_6,
      boolean SIG_5,
      boolean SIG_4,
      boolean SIG_3,
      boolean SIG_2,
      boolean SIG_1) {
    super();
    this.SIG_8 = SIG_8;
    this.SIG_7 = SIG_7;
    this.SIG_6 = SIG_6;
    this.SIG_5 = SIG_5;
    this.SIG_4 = SIG_4;
    this.SIG_3 = SIG_3;
    this.SIG_2 = SIG_2;
    this.SIG_1 = SIG_1;
  }

  public boolean getSIG_8() {
    return SIG_8;
  }

  public boolean getSIG_7() {
    return SIG_7;
  }

  public boolean getSIG_6() {
    return SIG_6;
  }

  public boolean getSIG_5() {
    return SIG_5;
  }

  public boolean getSIG_4() {
    return SIG_4;
  }

  public boolean getSIG_3() {
    return SIG_3;
  }

  public boolean getSIG_2() {
    return SIG_2;
  }

  public boolean getSIG_1() {
    return SIG_1;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("State");

    // Simple Field (SIG_8)
    writeSimpleField("SIG_8", SIG_8, writeBoolean(writeBuffer));

    // Simple Field (SIG_7)
    writeSimpleField("SIG_7", SIG_7, writeBoolean(writeBuffer));

    // Simple Field (SIG_6)
    writeSimpleField("SIG_6", SIG_6, writeBoolean(writeBuffer));

    // Simple Field (SIG_5)
    writeSimpleField("SIG_5", SIG_5, writeBoolean(writeBuffer));

    // Simple Field (SIG_4)
    writeSimpleField("SIG_4", SIG_4, writeBoolean(writeBuffer));

    // Simple Field (SIG_3)
    writeSimpleField("SIG_3", SIG_3, writeBoolean(writeBuffer));

    // Simple Field (SIG_2)
    writeSimpleField("SIG_2", SIG_2, writeBoolean(writeBuffer));

    // Simple Field (SIG_1)
    writeSimpleField("SIG_1", SIG_1, writeBoolean(writeBuffer));

    writeBuffer.popContext("State");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    State _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (SIG_8)
    lengthInBits += 1;

    // Simple field (SIG_7)
    lengthInBits += 1;

    // Simple field (SIG_6)
    lengthInBits += 1;

    // Simple field (SIG_5)
    lengthInBits += 1;

    // Simple field (SIG_4)
    lengthInBits += 1;

    // Simple field (SIG_3)
    lengthInBits += 1;

    // Simple field (SIG_2)
    lengthInBits += 1;

    // Simple field (SIG_1)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static State staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static State staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("State");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean SIG_8 = readSimpleField("SIG_8", readBoolean(readBuffer));

    boolean SIG_7 = readSimpleField("SIG_7", readBoolean(readBuffer));

    boolean SIG_6 = readSimpleField("SIG_6", readBoolean(readBuffer));

    boolean SIG_5 = readSimpleField("SIG_5", readBoolean(readBuffer));

    boolean SIG_4 = readSimpleField("SIG_4", readBoolean(readBuffer));

    boolean SIG_3 = readSimpleField("SIG_3", readBoolean(readBuffer));

    boolean SIG_2 = readSimpleField("SIG_2", readBoolean(readBuffer));

    boolean SIG_1 = readSimpleField("SIG_1", readBoolean(readBuffer));

    readBuffer.closeContext("State");
    // Create the instance
    State _state;
    _state = new State(SIG_8, SIG_7, SIG_6, SIG_5, SIG_4, SIG_3, SIG_2, SIG_1);
    return _state;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof State)) {
      return false;
    }
    State that = (State) o;
    return (getSIG_8() == that.getSIG_8())
        && (getSIG_7() == that.getSIG_7())
        && (getSIG_6() == that.getSIG_6())
        && (getSIG_5() == that.getSIG_5())
        && (getSIG_4() == that.getSIG_4())
        && (getSIG_3() == that.getSIG_3())
        && (getSIG_2() == that.getSIG_2())
        && (getSIG_1() == that.getSIG_1())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getSIG_8(),
        getSIG_7(),
        getSIG_6(),
        getSIG_5(),
        getSIG_4(),
        getSIG_3(),
        getSIG_2(),
        getSIG_1());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
