/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.configuration.S7Configuration;
import org.apache.plc4x.java.s7.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7.readwrite.discovery.ProfinetChannel;
import org.apache.plc4x.java.s7.readwrite.discovery.S7PlcDiscoverer;
import org.apache.plc4x.java.s7.readwrite.optimizer.S7Optimizer;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HGeneratedDriverBase;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HSingleProtocolStackConfigurer;
import org.apache.plc4x.java.s7.readwrite.protocol.S7ProtocolLogic;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryRequest;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.Pcaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7Driver
extends S7HGeneratedDriverBase {
    public static final int ISO_ON_TCP_PORT = 102;
    private static final Logger log = LoggerFactory.getLogger(S7Driver.class);

    @Override
    public String getProtocolCode() {
        return "s7";
    }

    @Override
    public String getProtocolName() {
        return "Siemens S7 (Basic)";
    }

    @Override
    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return S7Configuration.class;
    }

    @Override
    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    @Override
    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    protected boolean canDiscover() {
        return true;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new S7Optimizer();
    }

    public PlcDiscoveryRequest.Builder discoveryRequestBuilder() {
        try {
            ProfinetChannel channel = new ProfinetChannel(Pcaps.findAllDevs());
            S7PlcDiscoverer discoverer = new S7PlcDiscoverer(channel);
            return new DefaultPlcDiscoveryRequest.Builder((PlcDiscoverer)discoverer);
        }
        catch (PcapNativeException e) {
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            if ("Could not initialize class com.sun.jna.Native".equals(e.getMessage()) && e.getCause() instanceof UnsatisfiedLinkError) {
                log.error("Could not discover devices as there were issues loading the pcap wrapper. Please make sure you have set the \"-Djna.library.path\" VM option correctly.");
            }
            throw new RuntimeException(e);
        }
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    @Override
    protected ProtocolStackConfigurer<TPKTPacket> getStackConfigurer() {
        return S7HSingleProtocolStackConfigurer.builder(TPKTPacket.class, TPKTPacket::staticParse).withProtocol(S7ProtocolLogic.class).withDriverContext(S7DriverContext.class).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).build();
    }

    public S7Tag prepareTag(String tagAddress) {
        return S7Tag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 2);
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != TPKTPacket.PROTOCOLID.shortValue()) {
                byteBuf.readByte();
            }
        }
    }
}

