/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItem;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class S7ParameterUserData
extends S7Parameter
implements Message {
    protected final List<S7ParameterUserDataItem> items;

    @Override
    public Short getParameterType() {
        return (short)0;
    }

    @Override
    public Short getMessageType() {
        return (short)7;
    }

    public S7ParameterUserData(List<S7ParameterUserDataItem> items) {
        this.items = items;
    }

    public List<S7ParameterUserDataItem> getItems() {
        return this.items;
    }

    @Override
    protected void serializeS7ParameterChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7ParameterUserData", new WithWriterArgs[0]);
        short numItems = (short)StaticHelper.COUNT(this.getItems());
        FieldWriterFactory.writeImplicitField((String)"numItems", (Object)numItems, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"items", this.items, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("S7ParameterUserData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        S7ParameterUserData _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.items != null) {
            int i = 0;
            for (S7ParameterUserDataItem element : this.items) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.items.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static S7Parameter.S7ParameterBuilder staticParseS7ParameterBuilder(ReadBuffer readBuffer, Short messageType) throws ParseException {
        readBuffer.pullContext("S7ParameterUserData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short numItems = (Short)FieldReaderFactory.readImplicitField((String)"numItems", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        List items = FieldReaderFactory.readCountArrayField((String)"items", (DataReader)DataReaderFactory.readComplex(() -> S7ParameterUserDataItem.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)numItems, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("S7ParameterUserData", new WithReaderArgs[0]);
        return new S7ParameterUserDataBuilderImpl(items);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7ParameterUserData)) {
            return false;
        }
        S7ParameterUserData that = (S7ParameterUserData)o;
        return this.getItems() == that.getItems() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getItems());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class S7ParameterUserDataBuilderImpl
    implements S7Parameter.S7ParameterBuilder {
        private final List<S7ParameterUserDataItem> items;

        public S7ParameterUserDataBuilderImpl(List<S7ParameterUserDataItem> items) {
            this.items = items;
        }

        @Override
        public S7ParameterUserData build() {
            S7ParameterUserData s7ParameterUserData = new S7ParameterUserData(this.items);
            return s7ParameterUserData;
        }
    }
}

