/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.discovery;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.plc4x.java.s7discovery.readwrite.Ethernet_Frame;
import org.apache.plc4x.java.s7discovery.readwrite.Ethernet_FramePayload;
import org.apache.plc4x.java.s7discovery.readwrite.Ethernet_FramePayload_VirtualLan;
import org.apache.plc4x.java.s7discovery.readwrite.MacAddress;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Dot1qVlanTagPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.LinkLayerAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfinetChannel {
    private final Logger logger = LoggerFactory.getLogger(ProfinetChannel.class);
    private static final EtherType PN_EtherType = EtherType.getInstance((Short)-30574);
    private static final EtherType LLDP_EtherType = EtherType.getInstance((Short)-30516);
    private static final EtherType IPv4_EtherType = EtherType.getInstance((Short)2048);
    private final Map<MacAddress, PcapHandle> openHandles;
    private final Set<BiConsumer<Ethernet_FramePayload, EthernetPacket>> packetListeners;

    public ProfinetChannel(List<PcapNetworkInterface> devs) {
        this.openHandles = this.getInterfaceHandles(devs);
        this.packetListeners = new HashSet<BiConsumer<Ethernet_FramePayload, EthernetPacket>>();
        this.startListener();
    }

    public void addPacketListener(BiConsumer<Ethernet_FramePayload, EthernetPacket> packetListener) {
        this.packetListeners.add(packetListener);
    }

    public void send(Ethernet_Frame ethFrame) {
        for (Map.Entry<MacAddress, PcapHandle> entry : this.openHandles.entrySet()) {
            PcapHandle handle = entry.getValue();
            WriteBufferByteBased buffer = new WriteBufferByteBased(ethFrame.getLengthInBytes());
            try {
                ethFrame.serialize((WriteBuffer)buffer);
                EthernetPacket packet = EthernetPacket.newPacket((byte[])buffer.getBytes(), (int)0, (int)ethFrame.getLengthInBytes());
                handle.sendPacket((Packet)packet);
            }
            catch (SerializationException | NotOpenException | PcapNativeException | IllegalRawDataException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void startListener() {
        for (PcapHandle handle : this.openHandles.values()) {
            PacketListener listener = this.createListener();
            Thread thread = new Thread(() -> {
                try {
                    handle.loop(-1, listener);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (NotOpenException | PcapNativeException e) {
                    this.logger.error("Got error handling raw socket", e);
                }
            });
            thread.setDaemon(true);
            thread.setName("RawSocket handler " + handle.getFilteringExpression());
            thread.start();
        }
    }

    public PacketListener createListener() {
        return packet -> {
            if (packet instanceof EthernetPacket) {
                UdpPacket payload;
                EthernetPacket ethernetPacket = (EthernetPacket)packet;
                boolean isPnPacket = false;
                if (ethernetPacket.getPayload() instanceof Dot1qVlanTagPacket) {
                    Dot1qVlanTagPacket vlanPacket = (Dot1qVlanTagPacket)ethernetPacket.getPayload();
                    if (PN_EtherType.equals((Object)vlanPacket.getHeader().getType()) || LLDP_EtherType.equals((Object)vlanPacket.getHeader().getType())) {
                        isPnPacket = true;
                    }
                } else if (PN_EtherType.equals((Object)ethernetPacket.getHeader().getType()) || LLDP_EtherType.equals((Object)ethernetPacket.getHeader().getType())) {
                    isPnPacket = true;
                } else if (ethernetPacket.getHeader().getType() == EtherType.IPV4 && ethernetPacket.getPayload().getPayload() instanceof UdpPacket && ((Short)(payload = (UdpPacket)ethernetPacket.getPayload().getPayload()).getHeader().getDstPort().value() == -30572 || (Short)payload.getHeader().getDstPort().value() == -15536 || (Short)payload.getHeader().getDstPort().value() == -15535)) {
                    isPnPacket = true;
                }
                if (isPnPacket) {
                    ReadBufferByteBased reader = new ReadBufferByteBased(ethernetPacket.getRawData());
                    try {
                        Ethernet_Frame ethernetFrame = Ethernet_Frame.staticParse((ReadBuffer)reader);
                        Ethernet_FramePayload payload2 = ethernetFrame.getPayload();
                        if (payload2 instanceof Ethernet_FramePayload_VirtualLan) {
                            payload2 = ((Ethernet_FramePayload_VirtualLan)payload2).getPayload();
                        }
                        for (BiConsumer<Ethernet_FramePayload, EthernetPacket> packetListener : this.packetListeners) {
                            packetListener.accept(payload2, ethernetPacket);
                        }
                    }
                    catch (ParseException e) {
                        this.logger.error("Got error decoding packet", (Throwable)e);
                    }
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public Map<MacAddress, PcapHandle> getInterfaceHandles(List<PcapNetworkInterface> devs) {
        block7: {
            openHandles = new HashMap<MacAddress, PcapHandle>();
            try {
                for (PcapNetworkInterface dev : devs) {
                    if (dev.getAddresses().isEmpty() || dev.isLoopBack()) continue;
                    for (LinkLayerAddress linkLayerAddress : dev.getLinkLayerAddresses()) {
                        macAddress = (org.pcap4j.util.MacAddress)linkLayerAddress;
                        handle = dev.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
                        openHandles.put(ProfinetChannel.toPlc4xMacAddress(macAddress), handle);
                        handle.setFilter("((ether proto 0x8100) or (ether proto 0x8892)) and (ether dst " + Pcaps.toBpfString((org.pcap4j.util.MacAddress)macAddress) + ")", BpfProgram.BpfCompileMode.OPTIMIZE);
                    }
                }
                break block7;
            }
            catch (NotOpenException | PcapNativeException e) {
                this.logger.error("Got an exception while processing raw socket data", e);
                ** for (entry : openHandles.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                openHandle = (PcapHandle)entry.getValue();
                try {
                    openHandle.breakLoop();
                    openHandle.close();
                }
                catch (NotOpenException error) {
                    this.logger.info("Handle already closed.");
                }
                continue;
            }
        }
        return openHandles;
    }

    public Map<MacAddress, PcapHandle> getOpenHandles() {
        return this.openHandles;
    }

    private static MacAddress toPlc4xMacAddress(org.pcap4j.util.MacAddress pcap4jMacAddress) {
        byte[] address = pcap4jMacAddress.getAddress();
        return new MacAddress(new byte[]{address[0], address[1], address[2], address[3], address[4], address[5]});
    }
}

