/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.tag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.s7.readwrite.AlarmType;
import org.apache.plc4x.java.s7.readwrite.EventType;
import org.apache.plc4x.java.s7.readwrite.TimeBase;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7.readwrite.types.S7SubscriptionType;

public class S7SubscriptionTag
implements PlcTag {
    private static final Pattern EVENT_SUBSCRIPTION_TYPE_PATTERN = Pattern.compile("(^MODE)|(^SYS)|(^USR)|(^ALM)");
    private static final Pattern EVENT_ALARM_ACK_PATTERN = Pattern.compile("(^ACK:)(((?:,{0,1})(16#[0-9a-fA-F]{8}))+)");
    private static final Pattern EVENT_ALARM_QUERY_PATTERN = Pattern.compile("(^QUERY:)((ALARM_S)|(ALARM_8))");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("%(?<memoryArea>.)(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_ADDRESS_PATTERN = Pattern.compile("%DB(?<blockNumber>\\d{1,5}).DB(?<transferDBSizeCode>[XBWD]?)(?<byteDBOffset>\\d{1,7})(.(?<bitDBOffset>[0-7]))?:(?<dataDBType>[a-zA-Z_]+)(\\[(?<numDBElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_SHORT_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}):(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>(S5)?[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern EVENT_SUBSCRIPTION_S7ANY_QUERY_PATTERN = Pattern.compile("(^CYC(\\((?<timeBase>((B01SEC)|(B1SEC)|(B10SEC))):(?<multiplier>[1-99])\\)):)(((?:,{0,1})((" + ADDRESS_PATTERN + ")|(" + DATA_BLOCK_ADDRESS_PATTERN + ")))+)");
    private static final Pattern EVENT_SUBSCRIPTION_S7ANY_QUERY_PATTERN_SHORT = Pattern.compile("(^CYC(\\((?<timeBase>((B01SEC)|(B1SEC)|(B10SEC))):(?<multiplier>[1-99])\\)):)(((?:,{0,1})((" + DATA_BLOCK_SHORT_PATTERN + ")))+)");
    private static final Pattern EVENT_SUBSCRIPTION_DB_QUERY_PATTERN = Pattern.compile("(^CYC(\\((?<timeBase>((B01SEC)|(B1SEC)|(B10SEC))):(?<multiplier>[1-99])\\)):)(((?:,{0,1})(%DB(?<blockNumber>\\d{1,5}).DB(?<transferDBSizeCode>[B]?)(?<byteDBOffset>\\d{1,7})(\\[(?<numDBElements>\\d+)]))?)+)");
    private static final Pattern EVENT_CANCEL_JOB_QUERY_PATTERN = Pattern.compile("(^CANCEL:)((((?:,{0,1})(\\d{1,3}+)))+)");
    private static final String MEMORY_AREA = "memoryArea";
    private static final String TRANSFER_SIZE_CODE = "transferSizeCode";
    private static final String BYTE_OFFSET = "byteOffset";
    private static final String BIT_OFFSET = "bitOffset";
    private static final String DATA_TYPE = "dataType";
    private static final String NUM_ELEMENTS = "numElements";
    private static final String BLOCK_NUMBER = "blockNumber";
    private static final String TRANSFER_DB_SIZE_CODE = "transferSizeCode";
    private static final String BYTE_DB_OFFSET = "byteOffset";
    private static final String BIT_DB_OFFSET = "bitOffset";
    private static final String DATA_DB_TYPE = "dataType";
    private static final String NUM_DB_ELEMENTS = "numElements";
    private static final String STRING_LENGTH = "stringLength";
    private static final String TIME_BASE = "timeBase";
    private static final String TIME_BASE_MULTIPLIER = "multiplier";
    private final S7SubscriptionType subscriptionType;
    private final EventType eventType;
    private final S7Tag[] s7tags;
    private final ArrayList<Integer> ackAlarms;
    private final AlarmType alarmQueryType;
    private final TimeBase timeBase;
    private final short multiplier;

    public S7SubscriptionTag(S7SubscriptionType subscriptionType, EventType eventType) {
        this.subscriptionType = subscriptionType;
        this.eventType = eventType;
        this.s7tags = null;
        this.ackAlarms = null;
        this.alarmQueryType = null;
        this.timeBase = null;
        this.multiplier = 0;
    }

    public S7SubscriptionTag(S7SubscriptionType subscriptionType, ArrayList<Integer> ackAlarms) {
        this.subscriptionType = subscriptionType;
        this.eventType = null;
        this.s7tags = null;
        this.ackAlarms = ackAlarms;
        this.alarmQueryType = null;
        this.timeBase = null;
        this.multiplier = 0;
    }

    public S7SubscriptionTag(S7SubscriptionType subscriptionType, AlarmType alarmQueryType) {
        this.subscriptionType = subscriptionType;
        this.eventType = null;
        this.s7tags = null;
        this.ackAlarms = null;
        this.alarmQueryType = alarmQueryType;
        this.timeBase = null;
        this.multiplier = 0;
    }

    public S7SubscriptionTag(S7SubscriptionType subscriptionType, S7Tag[] s7tags, TimeBase timeBase, short multiplier) {
        this.subscriptionType = subscriptionType;
        this.eventType = null;
        this.s7tags = s7tags;
        this.ackAlarms = null;
        this.alarmQueryType = null;
        this.timeBase = timeBase;
        this.multiplier = multiplier;
    }

    public String getAddressString() {
        return null;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.RAW_BYTE_ARRAY;
    }

    public List<ArrayInfo> getArrayInfo() {
        return Collections.emptyList();
    }

    public S7SubscriptionType getTagType() {
        return this.subscriptionType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public S7Tag[] getS7Tags() {
        return this.s7tags;
    }

    public ArrayList<Integer> getAckAlarms() {
        return this.ackAlarms;
    }

    public AlarmType getAlarmQueryType() {
        return this.alarmQueryType;
    }

    public TimeBase getTimeBase() {
        return this.timeBase;
    }

    public short getMultiplier() {
        return this.multiplier;
    }

    public static boolean matches(String tagString) {
        return EVENT_SUBSCRIPTION_TYPE_PATTERN.matcher(tagString).matches() || EVENT_ALARM_ACK_PATTERN.matcher(tagString).matches() || EVENT_ALARM_QUERY_PATTERN.matcher(tagString).matches() || EVENT_SUBSCRIPTION_S7ANY_QUERY_PATTERN.matcher(tagString).matches() || EVENT_SUBSCRIPTION_DB_QUERY_PATTERN.matcher(tagString).matches() || EVENT_CANCEL_JOB_QUERY_PATTERN.matcher(tagString).matches() || EVENT_SUBSCRIPTION_S7ANY_QUERY_PATTERN_SHORT.matcher(tagString).matches();
    }

    public static S7SubscriptionTag of(String tagString) {
        Matcher matcher = EVENT_SUBSCRIPTION_TYPE_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            return new S7SubscriptionTag(S7SubscriptionType.EVENT_SUBSCRIPTION, EventType.valueOf(tagString));
        }
        matcher = EVENT_ALARM_ACK_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            String EventIds = matcher.group(2);
            String[] arrStrEventId = EventIds.split(",");
            ArrayList<Integer> arrEventId = new ArrayList<Integer>();
            String[] stringArray = arrStrEventId;
            int n = arrStrEventId.length;
            int n2 = 0;
            while (n2 < n) {
                String EventId = stringArray[n2];
                EventId = EventId.replaceAll("16#", "");
                String[] arrIdAndSig = EventId.split(";");
                arrEventId.add(Integer.parseInt(arrIdAndSig[0], 16));
                arrEventId.add(Integer.parseInt(arrIdAndSig[1], 16));
                ++n2;
            }
            return new S7SubscriptionTag(S7SubscriptionType.ALARM_ACK, arrEventId);
        }
        matcher = EVENT_ALARM_QUERY_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            return new S7SubscriptionTag(S7SubscriptionType.ALARM_QUERY, AlarmType.ALARM_S);
        }
        matcher = EVENT_SUBSCRIPTION_DB_QUERY_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            TimeBase tb = TimeBase.valueOf(matcher.group(TIME_BASE));
            short multi = Short.parseShort(matcher.group(TIME_BASE_MULTIPLIER));
            String strAddress = matcher.group(9);
            strAddress = strAddress.replaceAll("\\[", ".0:BYTE[");
            String[] dbAddress = strAddress.split(",");
            S7Tag[] s7tags = new S7Tag[dbAddress.length];
            int i = 0;
            String[] stringArray = dbAddress;
            int n = dbAddress.length;
            int n3 = 0;
            while (n3 < n) {
                String address = stringArray[n3];
                s7tags[i] = S7Tag.of(address);
                ++i;
                ++n3;
            }
            return new S7SubscriptionTag(S7SubscriptionType.CYCLIC_DB_SUBSCRIPTION, s7tags, tb, multi);
        }
        matcher = EVENT_SUBSCRIPTION_S7ANY_QUERY_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            TimeBase tb = TimeBase.valueOf(matcher.group(TIME_BASE));
            short multi = Short.parseShort(matcher.group(TIME_BASE_MULTIPLIER));
            String strAddress = matcher.group(9);
            String[] fieldAddress = strAddress.split(",");
            S7Tag[] myTags = new S7Tag[fieldAddress.length];
            int i = 0;
            String[] stringArray = fieldAddress;
            int n = fieldAddress.length;
            int n4 = 0;
            while (n4 < n) {
                String address = stringArray[n4];
                myTags[i] = S7Tag.of(address);
                ++i;
                ++n4;
            }
            return new S7SubscriptionTag(S7SubscriptionType.CYCLIC_SUBSCRIPTION, myTags, tb, multi);
        }
        matcher = EVENT_SUBSCRIPTION_S7ANY_QUERY_PATTERN_SHORT.matcher(tagString);
        if (matcher.matches()) {
            TimeBase tb = TimeBase.valueOf(matcher.group(TIME_BASE));
            short multi = Short.parseShort(matcher.group(TIME_BASE_MULTIPLIER));
            String strAddress = matcher.group(9);
            String[] fieldAddress = strAddress.split(",");
            S7Tag[] myTags = new S7Tag[fieldAddress.length];
            int i = 0;
            String[] stringArray = fieldAddress;
            int n = fieldAddress.length;
            int n5 = 0;
            while (n5 < n) {
                String address = stringArray[n5];
                myTags[i] = S7Tag.of(address);
                ++i;
                ++n5;
            }
            return new S7SubscriptionTag(S7SubscriptionType.CYCLIC_SUBSCRIPTION, myTags, tb, multi);
        }
        matcher = EVENT_CANCEL_JOB_QUERY_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            String strJobIds = matcher.group(2);
            String[] arrStrEventId = strJobIds.split(",");
            ArrayList<Integer> arrJobId = new ArrayList<Integer>();
            String[] stringArray = arrStrEventId;
            int n = arrStrEventId.length;
            int n6 = 0;
            while (n6 < n) {
                String jobId = stringArray[n6];
                arrJobId.add(Integer.parseInt(jobId));
                ++n6;
            }
            return new S7SubscriptionTag(S7SubscriptionType.CYCLIC_UNSUBSCRIPTION, arrJobId);
        }
        throw new PlcInvalidTagException("Unable to parse address: " + tagString);
    }
}

