/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.utils;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.s7.readwrite.TimeBase;
import org.apache.plc4x.java.s7.readwrite.tag.S7SubscriptionTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7.readwrite.types.S7SubscriptionType;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;

public class S7PlcSubscriptionRequest
extends DefaultPlcSubscriptionRequest {
    private static final String CONST_DUPLICATE_TAG = "Duplicate tag definition";
    private static final String CONST_INVALID_TYPE = "Tag is not of type S7SubscriptionTag";
    private static final String CONST_TIME_CANNOT_BE_ZERO = "Subscription time cannot be zero.";

    public S7PlcSubscriptionRequest(PlcSubscriber subscriber, LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>> tags, Consumer<PlcSubscriptionEvent> consumer, Map<String, Consumer<PlcSubscriptionEvent>> tagConsumers) {
        super(subscriber, tags, consumer, tagConsumers);
    }

    public String toString() {
        return "DefaultPlcSubscriptionRequest{}";
    }

    public static class Builder
    implements PlcSubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private final PlcTagHandler tagHandler;
        private final Map<String, BuilderItem> tags;
        private Consumer<PlcSubscriptionEvent> consumer;

        public Builder(PlcSubscriber subscriber, PlcTagHandler tagHandler) {
            this.subscriber = subscriber;
            this.tagHandler = tagHandler;
            this.tags = new TreeMap<String, BuilderItem>();
        }

        public PlcSubscriptionRequest.Builder setConsumer(Consumer<PlcSubscriptionEvent> consumer) {
            this.consumer = Objects.requireNonNull(consumer);
            return this;
        }

        public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval) {
            return this.addCyclicTagAddress(name, tagAddress, pollingInterval, null);
        }

        public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            TimeBase tb = this.getTimeBase(pollingInterval);
            short multiplier = this.getMultiplier(tb, pollingInterval);
            S7Tag[] s7tags = new S7Tag[]{S7Tag.of(tagAddress)};
            S7SubscriptionTag tag = new S7SubscriptionTag(S7SubscriptionType.CYCLIC_SUBSCRIPTION, s7tags, tb, multiplier);
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CYCLIC, pollingInterval, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval) {
            return this.addCyclicTag(name, tag, pollingInterval, null);
        }

        public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            if (!(tag instanceof S7SubscriptionTag)) {
                throw new PlcRuntimeException(S7PlcSubscriptionRequest.CONST_INVALID_TYPE);
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CYCLIC, pollingInterval, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress) {
            return this.addChangeOfStateTagAddress(tagAddress, name);
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            S7Tag[] s7tags = new S7Tag[]{S7Tag.of(tagAddress)};
            S7SubscriptionTag tag = new S7SubscriptionTag(S7SubscriptionType.CYCLIC_SUBSCRIPTION, s7tags, TimeBase.B01SEC, 1);
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CHANGE_OF_STATE, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag) {
            return this.addChangeOfStateTag(name, tag, null);
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            if (!(tag instanceof S7SubscriptionTag)) {
                throw new PlcRuntimeException(S7PlcSubscriptionRequest.CONST_INVALID_TYPE);
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CHANGE_OF_STATE, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress) {
            return this.addEventTagAddress(name, tagAddress, null);
        }

        public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            PlcTag tag = this.tagHandler.parseTag(tagAddress);
            if (!(tag instanceof S7SubscriptionTag)) {
                throw new PlcRuntimeException(S7PlcSubscriptionRequest.CONST_INVALID_TYPE);
            }
            this.tags.put(name, new BuilderItem(() -> this.tagHandler.parseTag(tagAddress), PlcSubscriptionType.EVENT, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag) {
            return this.addEventTag(name, tag, null);
        }

        public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            if (!(tag instanceof S7SubscriptionTag)) {
                throw new PlcRuntimeException(S7PlcSubscriptionRequest.CONST_INVALID_TYPE);
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.EVENT, consumer));
            return this;
        }

        public PlcSubscriptionRequest build() {
            LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>> parsedTags = new LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>>();
            LinkedHashMap<String, Consumer<PlcSubscriptionEvent>> tagConsumers = new LinkedHashMap<String, Consumer<PlcSubscriptionEvent>>();
            this.tags.forEach((name, builderItem) -> {
                PlcTag parsedTag = builderItem.tag.get();
                parsedTags.put((String)name, (PlcTagItem<PlcSubscriptionTag>)new DefaultPlcTagItem((PlcTag)new DefaultPlcSubscriptionTag(builderItem.plcSubscriptionType, parsedTag, builderItem.duration)));
                if (builderItem.consumer != null) {
                    tagConsumers.put((String)name, builderItem.consumer);
                }
            });
            return new S7PlcSubscriptionRequest(this.subscriber, parsedTags, this.consumer, tagConsumers);
        }

        private TimeBase getTimeBase(Duration duration) {
            if (duration.equals(Duration.ZERO)) {
                throw new PlcRuntimeException(S7PlcSubscriptionRequest.CONST_TIME_CANNOT_BE_ZERO);
            }
            long millis = duration.toMillis();
            if (millis < 1000L) {
                return TimeBase.B01SEC;
            }
            if (millis < 10000L) {
                return TimeBase.B1SEC;
            }
            if (millis < 100000L) {
                return TimeBase.B10SEC;
            }
            throw new PlcRuntimeException("The maximum subscription time is 90 sec.");
        }

        private short getMultiplier(TimeBase timeBase, Duration duration) {
            short multiplier = 1;
            if (duration.equals(Duration.ZERO)) {
                throw new PlcRuntimeException(S7PlcSubscriptionRequest.CONST_TIME_CANNOT_BE_ZERO);
            }
            long millis = duration.toMillis();
            switch (timeBase) {
                case B01SEC: {
                    if (millis <= 100L) break;
                    multiplier = (short)(millis / 100L);
                    break;
                }
                case B1SEC: {
                    multiplier = (short)(millis / 1000L);
                    break;
                }
                case B10SEC: {
                    multiplier = (short)(millis / 10000L);
                }
            }
            return multiplier;
        }

        private static class BuilderItem {
            private final Supplier<PlcTag> tag;
            private final PlcSubscriptionType plcSubscriptionType;
            private final Duration duration;
            private final Consumer<PlcSubscriptionEvent> consumer;

            private BuilderItem(Supplier<PlcTag> tag, PlcSubscriptionType plcSubscriptionType, Consumer<PlcSubscriptionEvent> consumer) {
                this(tag, plcSubscriptionType, null, consumer);
            }

            private BuilderItem(Supplier<PlcTag> tag, PlcSubscriptionType plcSubscriptionType, Duration duration, Consumer<PlcSubscriptionEvent> consumer) {
                this.tag = tag;
                this.plcSubscriptionType = plcSubscriptionType;
                this.duration = duration;
                this.consumer = consumer;
            }
        }
    }
}

