/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.connection;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcPingRequest;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.simulated.connection.SimulatedDevice;
import org.apache.plc4x.java.simulated.tag.SimulatedTag;
import org.apache.plc4x.java.simulated.tag.SimulatedTagHandler;
import org.apache.plc4x.java.spi.connection.AbstractPlcConnection;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcPinger;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;
import org.apache.plc4x.java.spi.values.DefaultPlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedConnection
extends AbstractPlcConnection
implements PlcReader,
PlcWriter,
PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulatedConnection.class);
    private final SimulatedDevice device;
    private boolean connected = false;
    private final Map<PlcSubscriptionHandle, PlcConsumerRegistration> registrations = new ConcurrentHashMap<PlcSubscriptionHandle, PlcConsumerRegistration>();
    private final Map<Integer, Consumer<PlcSubscriptionEvent>> consumerIdMap = new ConcurrentHashMap<Integer, Consumer<PlcSubscriptionEvent>>();

    public SimulatedConnection(SimulatedDevice device) {
        super(true, true, true, true, false, (PlcValueHandler)new DefaultPlcValueHandler(), (PlcTagHandler)new SimulatedTagHandler(), null, null);
        this.device = device;
    }

    public PlcTagHandler getPlcTagHandler() {
        return new SimulatedTagHandler();
    }

    public void connect() {
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() {
        this.connected = false;
    }

    public CompletableFuture<? extends PlcPingResponse> ping() {
        return CompletableFuture.completedFuture(new DefaultPlcPingResponse((PlcPingRequest)new DefaultPlcPingRequest((PlcPinger)this), PlcResponseCode.OK));
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        HashMap<String, DefaultPlcResponseItem> tags = new HashMap<String, DefaultPlcResponseItem>();
        for (String tagName : readRequest.getTagNames()) {
            SimulatedTag tag = (SimulatedTag)readRequest.getTag(tagName);
            Optional<PlcValue> valueOptional = this.device.get(tag);
            boolean present = valueOptional.isPresent();
            DefaultPlcResponseItem tagPair = present ? new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)valueOptional.get()) : new DefaultPlcResponseItem(PlcResponseCode.NOT_FOUND, null);
            tags.put(tagName, tagPair);
        }
        DefaultPlcReadResponse response = new DefaultPlcReadResponse(readRequest, tags);
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        HashMap<String, PlcResponseCode> tags = new HashMap<String, PlcResponseCode>();
        for (String tagName : writeRequest.getTagNames()) {
            if (writeRequest.getTagResponseCode(tagName) == PlcResponseCode.OK) {
                SimulatedTag tag = (SimulatedTag)writeRequest.getTag(tagName);
                PlcValue value = writeRequest.getPlcValue(tagName);
                this.device.set(tag, value);
                tags.put(tagName, PlcResponseCode.OK);
                continue;
            }
            tags.put(tagName, writeRequest.getTagResponseCode(tagName));
        }
        DefaultPlcWriteResponse response = new DefaultPlcWriteResponse(writeRequest, tags);
        return CompletableFuture.completedFuture(response);
    }

    public String toString() {
        return String.format("simulated:%s", this.device);
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        LOGGER.info("subscribing {}", (Object)subscriptionRequest);
        HashMap values = new HashMap();
        subscriptionRequest.getTagNames().forEach(name -> {
            LOGGER.info("creating handle for tag name {}", name);
            DefaultPlcSubscriptionHandle handle = new DefaultPlcSubscriptionHandle((PlcSubscriber)this);
            PlcSubscriptionTag subscriptionTag = subscriptionRequest.getTag(name);
            switch (subscriptionTag.getPlcSubscriptionType()) {
                case CYCLIC: {
                    LOGGER.info("Adding cyclic subscription for tag name {}", name);
                    this.device.addCyclicSubscription(this.dispatchSubscriptionEvent((String)name, (PlcSubscriptionHandle)handle), (PlcSubscriptionHandle)handle, subscriptionTag, (Duration)subscriptionTag.getDuration().orElseThrow(RuntimeException::new));
                    break;
                }
                case CHANGE_OF_STATE: {
                    LOGGER.info("Adding change of state subscription for tag name {}", name);
                    this.device.addChangeOfStateSubscription(this.dispatchSubscriptionEvent((String)name, (PlcSubscriptionHandle)handle), (PlcSubscriptionHandle)handle, subscriptionTag);
                    break;
                }
                case EVENT: {
                    LOGGER.info("Adding event subscription for tag name {}", name);
                    this.device.addEventSubscription(this.dispatchSubscriptionEvent((String)name, (PlcSubscriptionHandle)handle), (PlcSubscriptionHandle)handle, subscriptionTag);
                }
            }
            values.put(name, new DefaultPlcResponseItem(PlcResponseCode.OK, (Object)handle));
        });
        DefaultPlcSubscriptionResponse response = new DefaultPlcSubscriptionResponse(subscriptionRequest, values);
        return CompletableFuture.completedFuture(response);
    }

    private Consumer<PlcValue> dispatchSubscriptionEvent(String name, PlcSubscriptionHandle handle) {
        return plcValue -> {
            LOGGER.info("handling plc value {}", plcValue);
            PlcConsumerRegistration plcConsumerRegistration = this.registrations.get(handle);
            if (plcConsumerRegistration == null) {
                LOGGER.warn("no registration for handle {}", (Object)handle);
                return;
            }
            int consumerId = plcConsumerRegistration.getConsumerId();
            Consumer<PlcSubscriptionEvent> consumer = this.consumerIdMap.get(consumerId);
            if (consumer == null) {
                LOGGER.warn("no consumer for id {}", (Object)consumerId);
                return;
            }
            consumer.accept((PlcSubscriptionEvent)new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(name, new DefaultPlcResponseItem(PlcResponseCode.OK, plcValue))));
        };
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        LOGGER.info("unsubscribing {}", (Object)unsubscriptionRequest);
        this.device.removeHandles(unsubscriptionRequest.getSubscriptionHandles());
        DefaultPlcUnsubscriptionResponse response = new DefaultPlcUnsubscriptionResponse(unsubscriptionRequest);
        return CompletableFuture.completedFuture(response);
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        LOGGER.info("Registering consumer {} with handles {}", consumer, handles);
        DefaultPlcConsumerRegistration plcConsumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
        handles.stream().map(PlcSubscriptionHandle.class::cast).forEach(arg_0 -> this.lambda$4((PlcConsumerRegistration)plcConsumerRegistration, arg_0));
        this.consumerIdMap.put(plcConsumerRegistration.getConsumerId(), consumer);
        return plcConsumerRegistration;
    }

    public void unregister(PlcConsumerRegistration registration) {
        LOGGER.info("Unregistering {}", (Object)registration);
        Iterator<Map.Entry<PlcSubscriptionHandle, PlcConsumerRegistration>> entryIterator = this.registrations.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<PlcSubscriptionHandle, PlcConsumerRegistration> entry = entryIterator.next();
            if (!entry.getValue().equals(registration)) {
                LOGGER.debug("not the value we looking for {}. We are looking for {}", (Object)entry.getValue(), (Object)registration);
                continue;
            }
            PlcConsumerRegistration consumerRegistration = entry.getValue();
            int consumerId = consumerRegistration.getConsumerId();
            LOGGER.info("Removing consumer {}", (Object)consumerId);
            this.consumerIdMap.remove(consumerId);
            LOGGER.info("Removing handles {}", (Object)consumerRegistration.getSubscriptionHandles());
            this.device.removeHandles(consumerRegistration.getSubscriptionHandles());
            entryIterator.remove();
        }
    }

    private /* synthetic */ void lambda$4(PlcConsumerRegistration plcConsumerRegistration, PlcSubscriptionHandle handle) {
        PlcConsumerRegistration plcConsumerRegistration2 = this.registrations.put(handle, plcConsumerRegistration);
    }
}

