/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler;

import java.util.ArrayList;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScrapeJobImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperTask;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.TriggerConfiguration;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.TriggerHandler;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerHandlerImpl
implements TriggerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerHandlerImpl.class);
    private final TriggerConfiguration triggerConfiguration;
    private final TriggerCollector triggerCollector;
    private boolean lastTriggerState;

    public TriggerHandlerImpl(String triggerStrategy, TriggeredScrapeJobImpl triggeredScrapeJob, TriggeredScraperTask parentScraperTask, TriggerCollector triggerCollector) throws ScraperException {
        this.triggerConfiguration = TriggerConfiguration.createConfiguration(triggerStrategy, triggeredScrapeJob);
        for (TriggerConfiguration.TriggerElement triggerElement : this.triggerConfiguration.getTriggerElementList()) {
            triggerElement.setPlcConnectionString(parentScraperTask.getConnectionString());
            triggerElement.setUuid(triggerCollector.submitTrigger(triggerElement.getPlcFieldString(), parentScraperTask.getConnectionString(), this.triggerConfiguration.getScrapeInterval()));
        }
        this.lastTriggerState = false;
        this.triggerCollector = triggerCollector;
    }

    @Override
    public boolean checkTrigger() {
        switch (this.triggerConfiguration.getTriggerType()) {
            case SCHEDULED: {
                return true;
            }
            case S7_TRIGGER_VAR: {
                return this.checkS7TriggerVariable();
            }
            case TRIGGER_VAR: {
                return this.checkGenericTrigger();
            }
        }
        return false;
    }

    private boolean checkS7TriggerVariable() {
        ArrayList<Object> acquiredValuesList = new ArrayList<Object>();
        for (TriggerConfiguration.TriggerElement triggerElement : this.triggerConfiguration.getTriggerElementList()) {
            try {
                Object result = this.triggerCollector.requestResult(triggerElement.getUuid());
                if (result == null) {
                    return false;
                }
                acquiredValuesList.add(result);
            }
            catch (ScraperException e) {
                LOGGER.warn("Went wrong", (Throwable)e);
            }
        }
        boolean trigger = false;
        try {
            trigger = this.triggerConfiguration.evaluateTrigger(acquiredValuesList);
        }
        catch (ScraperException e) {
            LOGGER.warn("Could not evaluate trigger");
        }
        if (trigger && !this.lastTriggerState) {
            this.lastTriggerState = true;
            return true;
        }
        this.lastTriggerState = trigger;
        return false;
    }

    private boolean checkGenericTrigger() {
        ArrayList<Object> acquiredValuesList = new ArrayList<Object>();
        for (TriggerConfiguration.TriggerElement triggerElement : this.triggerConfiguration.getTriggerElementList()) {
            try {
                Object result = this.triggerCollector.requestResult(triggerElement.getUuid());
                if (result == null) {
                    return false;
                }
                acquiredValuesList.add(result);
            }
            catch (ScraperException e) {
                LOGGER.warn("Went wrong", (Throwable)e);
            }
        }
        boolean trigger = false;
        try {
            trigger = this.triggerConfiguration.evaluateTrigger(acquiredValuesList);
        }
        catch (ScraperException e) {
            LOGGER.warn("Could not evaluate trigger");
        }
        if (trigger && !this.lastTriggerState) {
            this.lastTriggerState = true;
            return true;
        }
        this.lastTriggerState = trigger;
        return false;
    }
}

