/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.triggeredscraper;

import java.util.Map;
import org.apache.plc4x.java.scraper.ScrapeJob;
import org.apache.plc4x.java.scraper.exception.ScraperConfigurationException;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.TriggerConfiguration;

public class TriggeredScrapeJobImpl
implements ScrapeJob {
    private final String jobName;
    private final Map<String, String> sourceConnections;
    private final Map<String, String> tags;
    private final String triggerConfig;
    private final TriggerConfiguration triggerConfiguration;

    public TriggeredScrapeJobImpl(String jobName, String triggerConfig, Map<String, String> connections, Map<String, String> tags) throws ScraperConfigurationException {
        this.jobName = jobName;
        this.triggerConfig = triggerConfig;
        this.sourceConnections = connections;
        this.tags = tags;
        this.triggerConfiguration = TriggerConfiguration.createConfiguration(triggerConfig, this);
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public long getScrapeRate() {
        return this.triggerConfiguration.getScrapeInterval();
    }

    @Override
    public Map<String, String> getSourceConnections() {
        return this.sourceConnections;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getTriggerConfig() {
        return this.triggerConfig;
    }
}

