/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.util;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;

public class PercentageAboveThreshold
implements UnivariateStatistic {
    private final double threshold;

    public PercentageAboveThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double evaluate(double[] values) throws MathIllegalArgumentException {
        long below = Arrays.stream(values).filter(val -> val <= this.threshold).count();
        return (double)below / (double)values.length;
    }

    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        long below = IntStream.range(begin, length).mapToDouble(i -> values[i]).filter(val -> val > this.threshold).count();
        return 100.0 * (double)below / (double)length;
    }

    public UnivariateStatistic copy() {
        return new PercentageAboveThreshold(this.threshold);
    }
}

