/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageCodec;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.listener.EventListener;
import org.apache.plc4x.java.spi.Plc4xNettyWrapper;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.GeneratedProtocolMessageCodec;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageInput;
import org.apache.plc4x.java.spi.generation.MessageOutput;

public class SingleProtocolStackConfigurer<BASE_PACKET_CLASS extends Message>
implements ProtocolStackConfigurer<BASE_PACKET_CLASS> {
    private final Class<BASE_PACKET_CLASS> basePacketClass;
    private final ByteOrder byteOrder;
    private final Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocolClass;
    private final Class<? extends DriverContext> driverContextClass;
    private final MessageInput<BASE_PACKET_CLASS> messageInput;
    private final MessageOutput<BASE_PACKET_CLASS> messageOutput;
    private final Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimatorClass;
    private final Class<? extends Consumer<ByteBuf>> corruptPacketRemoverClass;
    private final MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler;
    private final Object[] parserArgs;

    public static <BPC extends Message> SingleProtocolStackBuilder<BPC> builder(Class<BPC> basePacketClass, MessageInput<BPC> messageInput) {
        return new SingleProtocolStackBuilder<BPC>(basePacketClass, messageInput, null);
    }

    public static <BPC extends Message> SingleProtocolStackBuilder<BPC> builder(Class<BPC> basePacketClass, MessageInput<BPC> messageInput, MessageOutput<BPC> messageOutput) {
        return new SingleProtocolStackBuilder<BPC>(basePacketClass, messageInput, messageOutput);
    }

    SingleProtocolStackConfigurer(Class<BASE_PACKET_CLASS> basePacketClass, ByteOrder byteOrder, Object[] parserArgs, Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol, Class<? extends DriverContext> driverContextClass, MessageInput<BASE_PACKET_CLASS> messageInput, MessageOutput<BASE_PACKET_CLASS> messageOutput, Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimatorClass, Class<? extends Consumer<ByteBuf>> corruptPacketRemoverClass, MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler) {
        this.basePacketClass = basePacketClass;
        this.byteOrder = byteOrder;
        this.parserArgs = parserArgs;
        this.protocolClass = protocol;
        this.driverContextClass = driverContextClass;
        this.messageInput = messageInput;
        this.messageOutput = messageOutput;
        this.packetSizeEstimatorClass = packetSizeEstimatorClass;
        this.corruptPacketRemoverClass = corruptPacketRemoverClass;
        this.encryptionHandler = encryptionHandler;
    }

    private ChannelHandler getMessageCodec(Configuration configuration) {
        return new GeneratedProtocolMessageCodec<BASE_PACKET_CLASS>(this.basePacketClass, this.messageInput, this.messageOutput, this.byteOrder, this.parserArgs, this.packetSizeEstimatorClass != null ? ConfigurationFactory.configure(configuration, this.createInstance(this.packetSizeEstimatorClass, new Object[0])) : null, this.corruptPacketRemoverClass != null ? ConfigurationFactory.configure(configuration, this.createInstance(this.corruptPacketRemoverClass, new Object[0])) : null);
    }

    @Override
    public Plc4xProtocolBase<BASE_PACKET_CLASS> configurePipeline(Configuration configuration, ChannelPipeline pipeline, PlcAuthentication authentication, boolean passive, List<EventListener> ignore) {
        if (this.encryptionHandler != null) {
            pipeline.addLast(new ChannelHandler[]{this.encryptionHandler});
        }
        pipeline.addLast(new ChannelHandler[]{this.getMessageCodec(configuration)});
        Plc4xProtocolBase<BASE_PACKET_CLASS> protocol = ConfigurationFactory.configure(configuration, this.createInstance(this.protocolClass, new Object[0]));
        if (this.driverContextClass != null) {
            protocol.setDriverContext(ConfigurationFactory.configure(configuration, this.createInstance(this.driverContextClass, new Object[0])));
        }
        Plc4xNettyWrapper<BASE_PACKET_CLASS> context = new Plc4xNettyWrapper<BASE_PACKET_CLASS>(pipeline, passive, protocol, authentication, this.basePacketClass);
        pipeline.addLast(new ChannelHandler[]{context});
        return protocol;
    }

    private <T> T createInstance(Class<T> clazz, Object ... args) {
        try {
            Class[] parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                parameterTypes[i] = args[i].getClass();
            }
            return clazz.getDeclaredConstructor(parameterTypes).newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PlcRuntimeException("Error creating instance of class " + clazz.getName());
        }
    }

    public static final class SingleProtocolStackBuilder<BASE_PACKET_CLASS extends Message> {
        private final Class<BASE_PACKET_CLASS> basePacketClass;
        private final MessageInput<BASE_PACKET_CLASS> messageInput;
        private final MessageOutput<BASE_PACKET_CLASS> messageOutput;
        private Class<? extends DriverContext> driverContextClass;
        private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        private Object[] parserArgs;
        private Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol;
        private Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimator;
        private Class<? extends Consumer<ByteBuf>> corruptPacketRemover;
        private MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler;

        public SingleProtocolStackBuilder(Class<BASE_PACKET_CLASS> basePacketClass, MessageInput<BASE_PACKET_CLASS> messageInput, MessageOutput<BASE_PACKET_CLASS> messageOutput) {
            this.basePacketClass = basePacketClass;
            this.messageInput = messageInput;
            this.messageOutput = messageOutput;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withDriverContext(Class<? extends DriverContext> driverContextClass) {
            this.driverContextClass = driverContextClass;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> byteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> bigEndian() {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> littleEndian() {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withParserArgs(Object ... parserArgs) {
            this.parserArgs = parserArgs;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withProtocol(Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol) {
            this.protocol = protocol;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withPacketSizeEstimator(Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimator) {
            this.packetSizeEstimator = packetSizeEstimator;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withCorruptPacketRemover(Class<? extends Consumer<ByteBuf>> corruptPacketRemover) {
            this.corruptPacketRemover = corruptPacketRemover;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withEncryptionHandler(MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler) {
            this.encryptionHandler = encryptionHandler;
            return this;
        }

        public SingleProtocolStackConfigurer<BASE_PACKET_CLASS> build() {
            assert (this.protocol != null);
            return new SingleProtocolStackConfigurer<BASE_PACKET_CLASS>(this.basePacketClass, this.byteOrder, this.parserArgs, this.protocol, this.driverContextClass, this.messageInput, this.messageOutput, this.packetSizeEstimator, this.corruptPacketRemover, this.encryptionHandler);
        }
    }
}

