/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.withAdditionalStringRepresentation;
import org.apache.plc4x.java.spi.generation.withRenderAsList;

public interface BufferCommons {
    public static final String rwDataTypeKey = "dataType";
    public static final String rwBitLengthKey = "bitLength";
    public static final String rwStringRepresentationKey = "stringRepresentation";
    public static final String rwBitKey = "bit";
    public static final String rwByteKey = "byte";
    public static final String rwUintKey = "uint";
    public static final String rwIntKey = "int";
    public static final String rwFloatKey = "float";
    public static final String rwStringKey = "string";
    public static final String rwEncodingKey = "encoding";
    public static final String rwIsListKey = "isList";

    default public String sanitizeLogicalName(String logicalName) {
        if (StringUtils.isBlank((CharSequence)logicalName)) {
            return "value";
        }
        return logicalName;
    }

    default public boolean isToBeRenderedAsList(WithReaderArgs ... readerArgs) {
        return this.isToBeRenderedAsList((WithReaderWriterArgs[])Stream.of(readerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public boolean isToBeRenderedAsList(WithWriterArgs ... writerArgs) {
        return this.isToBeRenderedAsList((WithReaderWriterArgs[])Stream.of(writerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public boolean isToBeRenderedAsList(WithReaderWriterArgs ... readerWriterArgs) {
        for (WithReaderWriterArgs arg : readerWriterArgs) {
            if (!(arg instanceof withRenderAsList)) continue;
            return ((withRenderAsList)arg).renderAsList();
        }
        return false;
    }

    default public Optional<String> extractAdditionalStringRepresentation(WithReaderArgs ... readerArgs) {
        return this.extractAdditionalStringRepresentation((WithReaderWriterArgs[])Stream.of(readerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public Optional<String> extractAdditionalStringRepresentation(WithWriterArgs ... writerArgs) {
        return this.extractAdditionalStringRepresentation((WithReaderWriterArgs[])Stream.of(writerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public Optional<String> extractAdditionalStringRepresentation(WithReaderWriterArgs ... readerWriterArgs) {
        for (WithReaderWriterArgs arg : readerWriterArgs) {
            if (!(arg instanceof withAdditionalStringRepresentation)) continue;
            return Optional.of(((withAdditionalStringRepresentation)arg).stringRepresentation());
        }
        return Optional.empty();
    }
}

