/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcStruct;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcReadResponse
implements PlcReadResponse,
Serializable {
    private final PlcReadRequest request;
    private final Map<String, ResponseItem<PlcValue>> values;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcReadResponse(@JsonProperty(value="request") PlcReadRequest request, @JsonProperty(value="values") Map<String, ResponseItem<PlcValue>> values) {
        this.request = request;
        this.values = values;
    }

    public PlcReadRequest getRequest() {
        return this.request;
    }

    @JsonIgnore
    public PlcValue getAsPlcValue() {
        HashMap<String, PlcValue> structMap = new HashMap<String, PlcValue>();
        for (String fieldName : this.request.getFieldNames()) {
            PlcValue plcValue = this.getPlcValue(fieldName);
            structMap.put(fieldName, plcValue);
        }
        return new PlcStruct(structMap);
    }

    @JsonIgnore
    public PlcValue getPlcValue(String name) {
        return this.values.getOrDefault(name, new ResponseItem<Object>(null, null)).getValue();
    }

    @JsonIgnore
    public int getNumberOfValues(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            return plcList.getLength();
        }
        return 1;
    }

    @JsonIgnore
    public Collection<String> getFieldNames() {
        return this.request.getFieldNames();
    }

    @JsonIgnore
    public PlcField getField(String name) {
        return this.request.getField(name);
    }

    @JsonIgnore
    public PlcResponseCode getResponseCode(String name) {
        if (this.values.get(name) == null) {
            throw new PlcInvalidFieldException(name);
        }
        return this.values.get(name).getCode();
    }

    @JsonIgnore
    public Map<String, ResponseItem<PlcValue>> getValues() {
        return this.values;
    }

    @JsonIgnore
    public Object getObject(String name) {
        if (this.getFieldInternal(name) != null) {
            return this.getFieldInternal(name).getObject();
        }
        return null;
    }

    @JsonIgnore
    public Object getObject(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        if (fieldInternal != null) {
            return fieldInternal.getObject();
        }
        return null;
    }

    @JsonIgnore
    public Collection<Object> getAllObjects(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Object> items = new ArrayList<Object>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getObject());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getObject());
    }

    @JsonIgnore
    public boolean isValidBoolean(String name) {
        return this.isValidBoolean(name, 0);
    }

    @JsonIgnore
    public boolean isValidBoolean(String name, int index) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isBoolean();
    }

    @JsonIgnore
    public Boolean getBoolean(String name) {
        return this.getBoolean(name, 0);
    }

    @JsonIgnore
    public Boolean getBoolean(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getBoolean();
    }

    @JsonIgnore
    public Collection<Boolean> getAllBooleans(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Boolean> items = new ArrayList<Boolean>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getBoolean());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getBoolean());
    }

    @JsonIgnore
    public boolean isValidByte(String name) {
        return this.isValidByte(name, 0);
    }

    @JsonIgnore
    public boolean isValidByte(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isByte();
    }

    @JsonIgnore
    public Byte getByte(String name) {
        return this.getByte(name, 0);
    }

    @JsonIgnore
    public Byte getByte(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getByte();
    }

    @JsonIgnore
    public Collection<Byte> getAllBytes(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Byte> items = new ArrayList<Byte>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getByte());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getByte());
    }

    @JsonIgnore
    public boolean isValidShort(String name) {
        return this.isValidShort(name, 0);
    }

    @JsonIgnore
    public boolean isValidShort(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isShort();
    }

    @JsonIgnore
    public Short getShort(String name) {
        return this.getShort(name, 0);
    }

    @JsonIgnore
    public Short getShort(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getShort();
    }

    @JsonIgnore
    public Collection<Short> getAllShorts(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Short> items = new ArrayList<Short>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getShort());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getShort());
    }

    @JsonIgnore
    public boolean isValidInteger(String name) {
        return this.isValidInteger(name, 0);
    }

    @JsonIgnore
    public boolean isValidInteger(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isInteger();
    }

    @JsonIgnore
    public Integer getInteger(String name) {
        return this.getInteger(name, 0);
    }

    @JsonIgnore
    public Integer getInteger(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getInteger();
    }

    @JsonIgnore
    public Collection<Integer> getAllIntegers(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Integer> items = new ArrayList<Integer>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getInteger());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getInteger());
    }

    @JsonIgnore
    public boolean isValidBigInteger(String name) {
        return this.isValidBigInteger(name, 0);
    }

    @JsonIgnore
    public boolean isValidBigInteger(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isBigInteger();
    }

    @JsonIgnore
    public BigInteger getBigInteger(String name) {
        return this.getBigInteger(name, 0);
    }

    @JsonIgnore
    public BigInteger getBigInteger(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getBigInteger();
    }

    @JsonIgnore
    public Collection<BigInteger> getAllBigIntegers(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<BigInteger> items = new ArrayList<BigInteger>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getBigInteger());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getBigInteger());
    }

    @JsonIgnore
    public boolean isValidLong(String name) {
        return this.isValidLong(name, 0);
    }

    @JsonIgnore
    public boolean isValidLong(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isLong();
    }

    @JsonIgnore
    public Long getLong(String name) {
        return this.getLong(name, 0);
    }

    @JsonIgnore
    public Long getLong(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getLong();
    }

    @JsonIgnore
    public Collection<Long> getAllLongs(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Long> items = new ArrayList<Long>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getLong());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getLong());
    }

    @JsonIgnore
    public boolean isValidFloat(String name) {
        return this.isValidFloat(name, 0);
    }

    @JsonIgnore
    public boolean isValidFloat(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isFloat();
    }

    @JsonIgnore
    public Float getFloat(String name) {
        return this.getFloat(name, 0);
    }

    @JsonIgnore
    public Float getFloat(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return Float.valueOf(fieldInternal.getFloat());
    }

    @JsonIgnore
    public Collection<Float> getAllFloats(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Float> items = new ArrayList<Float>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(Float.valueOf(plcValue.getFloat()));
            }
            return items;
        }
        return Collections.singletonList(Float.valueOf(fieldInternal.getFloat()));
    }

    @JsonIgnore
    public boolean isValidDouble(String name) {
        return this.isValidDouble(name, 0);
    }

    @JsonIgnore
    public boolean isValidDouble(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isDouble();
    }

    @JsonIgnore
    public Double getDouble(String name) {
        return this.getDouble(name, 0);
    }

    @JsonIgnore
    public Double getDouble(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getDouble();
    }

    @JsonIgnore
    public Collection<Double> getAllDoubles(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<Double> items = new ArrayList<Double>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getDouble());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getDouble());
    }

    @JsonIgnore
    public boolean isValidBigDecimal(String name) {
        return this.isValidBigDecimal(name, 0);
    }

    @JsonIgnore
    public boolean isValidBigDecimal(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isBigDecimal();
    }

    @JsonIgnore
    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, 0);
    }

    @JsonIgnore
    public BigDecimal getBigDecimal(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getBigDecimal();
    }

    @JsonIgnore
    public Collection<BigDecimal> getAllBigDecimals(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<BigDecimal> items = new ArrayList<BigDecimal>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getBigDecimal());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getBigDecimal());
    }

    @JsonIgnore
    public boolean isValidString(String name) {
        return this.isValidString(name, 0);
    }

    @JsonIgnore
    public boolean isValidString(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isString();
    }

    @JsonIgnore
    public String getString(String name) {
        return this.getString(name, 0);
    }

    @JsonIgnore
    public String getString(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getString();
    }

    @JsonIgnore
    public Collection<String> getAllStrings(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<String> items = new ArrayList<String>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getString());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getString());
    }

    @JsonIgnore
    public boolean isValidTime(String name) {
        return this.isValidTime(name, 0);
    }

    @JsonIgnore
    public boolean isValidTime(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isTime();
    }

    @JsonIgnore
    public LocalTime getTime(String name) {
        return this.getTime(name, 0);
    }

    @JsonIgnore
    public LocalTime getTime(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getTime();
    }

    @JsonIgnore
    public Collection<LocalTime> getAllTimes(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<LocalTime> items = new ArrayList<LocalTime>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getTime());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getTime());
    }

    @JsonIgnore
    public boolean isValidDate(String name) {
        return this.isValidDate(name, 0);
    }

    @JsonIgnore
    public boolean isValidDate(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isDate();
    }

    @JsonIgnore
    public LocalDate getDate(String name) {
        return this.getDate(name, 0);
    }

    @JsonIgnore
    public LocalDate getDate(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getDate();
    }

    @JsonIgnore
    public Collection<LocalDate> getAllDates(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<LocalDate> items = new ArrayList<LocalDate>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getDate());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getDate());
    }

    @JsonIgnore
    public boolean isValidDateTime(String name) {
        return this.isValidDateTime(name, 0);
    }

    @JsonIgnore
    public boolean isValidDateTime(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.isDateTime();
    }

    @JsonIgnore
    public LocalDateTime getDateTime(String name) {
        return this.getDateTime(name, 0);
    }

    @JsonIgnore
    public LocalDateTime getDateTime(String name, int index) {
        PlcValue fieldInternal = this.getFieldIndexInternal(name, index);
        return fieldInternal.getDateTime();
    }

    @JsonIgnore
    public Collection<LocalDateTime> getAllDateTimes(String name) {
        PlcValue fieldInternal = this.getFieldInternal(name);
        if (fieldInternal instanceof PlcList) {
            PlcList plcList = (PlcList)fieldInternal;
            ArrayList<LocalDateTime> items = new ArrayList<LocalDateTime>(plcList.getLength());
            for (PlcValue plcValue : plcList.getList()) {
                items.add(plcValue.getDateTime());
            }
            return items;
        }
        return Collections.singletonList(fieldInternal.getDateTime());
    }

    @JsonAnySetter
    public void add(String key, ResponseItem<PlcValue> value) {
        this.values.put(key, value);
    }

    @JsonAnyGetter
    public Map<String, ResponseItem<PlcValue>> getMap() {
        return this.values;
    }

    protected PlcValue getFieldInternal(String name) {
        Objects.requireNonNull(name, "Name argument required");
        if (this.values.get(name) == null) {
            throw new PlcInvalidFieldException(name);
        }
        if (this.values.get(name).getCode() != PlcResponseCode.OK) {
            throw new PlcRuntimeException("Field '" + name + "' could not be fetched, response was " + this.values.get(name).getCode());
        }
        return this.values.get(name).getValue();
    }

    protected PlcValue getFieldIndexInternal(String name, int index) {
        PlcValue field = this.getFieldInternal(name);
        if (field instanceof PlcList) {
            PlcList plcList = (PlcList)field;
            if (index > plcList.getLength() - 1) {
                return null;
            }
            return plcList.getIndex(index);
        }
        if (index != 0) {
            return null;
        }
        return field;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcReadResponse", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)this.request).serialize(writeBuffer);
        }
        writeBuffer.pushContext("values", new WithWriterArgs[0]);
        for (Map.Entry<String, ResponseItem<PlcValue>> valueEntry : this.values.entrySet()) {
            String fieldName = valueEntry.getKey();
            writeBuffer.pushContext(fieldName, new WithWriterArgs[0]);
            ResponseItem<PlcValue> valueResponse = valueEntry.getValue();
            valueResponse.serialize(writeBuffer);
            writeBuffer.popContext(fieldName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("values", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcReadResponse", new WithWriterArgs[0]);
    }
}

