/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.transaction;

import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestTransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(RequestTransactionManager.class);
    static final ExecutorService executor = Executors.newFixedThreadPool(4);
    private final Set<RequestTransaction> runningRequests;
    private int numberOfConcurrentRequests;
    private AtomicInteger transactionId = new AtomicInteger(0);
    private Queue<RequestTransaction> workLog = new ConcurrentLinkedQueue<RequestTransaction>();

    public RequestTransactionManager(int numberOfConcurrentRequests) {
        this.numberOfConcurrentRequests = numberOfConcurrentRequests;
        this.runningRequests = ConcurrentHashMap.newKeySet();
    }

    public RequestTransactionManager() {
        this(1);
    }

    public int getNumberOfConcurrentRequests() {
        return this.numberOfConcurrentRequests;
    }

    public void setNumberOfConcurrentRequests(int numberOfConcurrentRequests) {
        if (numberOfConcurrentRequests < this.runningRequests.size()) {
            logger.warn("The number of concurrent requests was reduced and currently more requests are in flight.");
        }
        this.numberOfConcurrentRequests = numberOfConcurrentRequests;
        this.processWorklog();
    }

    public void submit(Consumer<RequestTransaction> context) {
        RequestTransaction transaction = this.startRequest();
        context.accept(transaction);
    }

    void submit(RequestTransaction handle) {
        assert (handle.operation != null);
        this.workLog.add(handle);
        this.processWorklog();
    }

    private void processWorklog() {
        while (this.runningRequests.size() < this.getNumberOfConcurrentRequests() && !this.workLog.isEmpty()) {
            RequestTransaction next = this.workLog.remove();
            this.runningRequests.add(next);
            Future<?> completionFuture = executor.submit(next.operation);
            next.setCompletionFuture(completionFuture);
        }
    }

    public RequestTransaction startRequest() {
        return new RequestTransaction(this, this.transactionId.getAndIncrement());
    }

    public int getNumberOfActiveRequests() {
        return this.runningRequests.size();
    }

    private void failRequest(RequestTransaction transaction) {
        transaction.getCompletionFuture().cancel(true);
        this.endRequest(transaction);
    }

    private void endRequest(RequestTransaction transaction) {
        if (!this.runningRequests.contains(transaction)) {
            throw new IllegalArgumentException("Unknown Transaction or Transaction already finished!");
        }
        this.runningRequests.remove(transaction);
        this.processWorklog();
    }

    public static class RequestTransaction {
        private final RequestTransactionManager parent;
        private final int transactionId;
        private Runnable operation;
        private Future<?> completionFuture;

        public RequestTransaction(RequestTransactionManager parent, int transactionId) {
            this.parent = parent;
            this.transactionId = transactionId;
        }

        public void start() {
        }

        public void failRequest(Throwable t) {
            this.parent.failRequest(this);
        }

        public void endRequest() {
            this.parent.endRequest(this);
        }

        public void setOperation(Runnable operation) {
            this.operation = operation;
        }

        public Future<?> getCompletionFuture() {
            return this.completionFuture;
        }

        public void setCompletionFuture(Future<?> completionFuture) {
            this.completionFuture = completionFuture;
        }

        public void submit(Runnable operation) {
            logger.trace("Submission of transaction {}", (Object)this.transactionId);
            this.setOperation(new TransactionOperation(this.transactionId, operation));
            this.parent.submit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestTransaction that = (RequestTransaction)o;
            return this.transactionId == that.transactionId;
        }

        public int hashCode() {
            return Objects.hash(this.transactionId);
        }
    }

    static class TransactionOperation
    implements Runnable {
        private final int transactionId;
        private final Runnable delegate;

        public TransactionOperation(int transactionId, Runnable delegate) {
            this.transactionId = transactionId;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try (MDC.MDCCloseable closeable = MDC.putCloseable((String)"plc4x.transactionId", (String)Integer.toString(this.transactionId));){
                logger.trace("Start execution of transaction {}", (Object)this.transactionId);
                this.delegate.run();
                logger.trace("Completed execution of transaction {}", (Object)this.transactionId);
            }
        }
    }
}

