/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcINT
extends PlcIECValue<Short> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static Short minValue = Short.MIN_VALUE;
    static Short maxValue = Short.MAX_VALUE;

    public static PlcINT of(Object value) {
        if (value instanceof Boolean) {
            return new PlcINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcINT((BigDecimal)value);
        }
        return new PlcINT((String)value);
    }

    public PlcINT(Boolean value) {
        this.value = value != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        this.isNullable = false;
    }

    public PlcINT(Byte value) {
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcINT(Short value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcINT(Integer value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcINT(Long value) {
        if (value < (long)minValue.shortValue() || value > (long)maxValue.shortValue()) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcINT(Float value) {
        if (value.floatValue() < (float)minValue.shortValue() || value.floatValue() > (float)maxValue.shortValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcINT(Double value) {
        if (value < (double)minValue.shortValue() || value > (double)maxValue.shortValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcINT(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigInteger.valueOf(maxValue.shortValue())) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcINT(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.shortValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcINT(String value) {
        try {
            this.value = Short.valueOf(value.trim());
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcINT(@JsonProperty(value="value") short value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.INT;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Short)this.value).equals((short)0);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Short)this.value <= 127 && (Short)this.value >= -128;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Short)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return true;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return (Short)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Short)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Short)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Short)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Short)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Integer.toString(((Short)this.value).shortValue());
    }

    @JsonIgnore
    public byte[] getBytes() {
        return new byte[]{(byte)((Short)this.value >> 8 & 0xFF), (byte)((Short)this.value & 0xFF)};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeInt(this.getClass().getSimpleName(), 16, ((Short)this.value).shortValue(), new WithWriterArgs[0]);
    }
}

